/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gvd.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : GARP VLAN Database (Maintaining the relationship between gid_index and vid )
// ********************************************

#include "common.h"
#include "garp_common.h"
#include "gvrp_common.h"

extern Gvr *my_gvr;
extern TstLPortMask    astStaticVlanGrp[4096];

/*
* Creates a new instance of gvd, allocating space for up to max_vlans
* VLAN IDs. Returns True if the creation suceeded together with a pointer to the
* gvd information.
*/  
Tbool gvd_create_gvd(Tuint32 max_vlans, void **gvd)
{
 Vlan_id *my_gvd;

 if (!sysmalloc(sizeof(Vlan_id)*max_vlans, (void **)&my_gvd)) {
    *gvd = NULL;
    return(False);
 }

 *gvd = my_gvd; 

 return(True);
}


// Dstroys the instance of gvd, releasing previously allocated database and control space.
void gvd_destroy_gvd(void *gvd)
{
  Garp *application=&my_gvr->garp;

  application->last_gid_used=0;
  sysfree(gvd);
}

// search database to find the vlan_id's gid_index
Tbool gvd_find_entry(void *gvd, Vlan_id key,Tuint32 *found_at_index)
{
  Vlan_id *my_gvd=(Vlan_id *)gvd;
  Tuint32 i=1;
  
  for(i=1;i<GVRP_DB_SIZE;i++) {
   if( my_gvd[i]==key ) {
    *found_at_index=i;
    return (True);
   }
  }

  return (False);  
}

// add entry in gvrp database
Tbool gvd_create_entry(void *gvd, Vlan_id key,Tuint32 *created_at_index)
{
  Vlan_id *my_gvd=(Vlan_id *)gvd;
  Garp *application=&my_gvr->garp;
  Tuint32 i=1;
 
  for(i=1;i<GVRP_DB_SIZE;i++) {
    if(my_gvd[i]==0) { // entry not exist 
      *created_at_index=i;
      my_gvd[i]=key;

      //maintain last_gid_used pointer     
      if(application->last_gid_used < i)
         application->last_gid_used=i;

      return(True);
    } 
  }

  return (False);    
}

// remove entry from gvrp database
Tbool gvd_delete_entry(void *gvd,Tuint32  delete_at_index)
{
 Vlan_id *my_gvd=(Vlan_id *)gvd;
  
 if(my_gvd[delete_at_index]!=0) { // entry exist
   my_gvd[delete_at_index]=0;
   return(True);
 }
 
 return(False);    
}

// get vlan_id info using gid_index
Tbool gvd_get_key(void *gvd, Tuint32 index, Vlan_id *key)
{
  Vlan_id *my_gvd=(Vlan_id *)gvd;
  
  if(my_gvd[index]!=0) { //entry exist
    *key=my_gvd[index];
    return(True);
  }
 
  *key=0; // invalid value
  return(False);    
}

// get gvrp database info
void gvrp_db_info(gvrp_db show_db[])
{
 Garp 		*application= &my_gvr->garp;
 Tuint32	i;

 for(i=1; i<= application->last_gid_used && application->gid !=NULL && i<GVRP_DB_SIZE ;i++) {
     gvd_get_key(my_gvr->gvd, i , &show_db[(i-1)].attr);
          
     if(show_db[(i-1)].attr==0){
       show_db[(i-1)].attr=4096;//4096 mean not used in this time
     }
	  
     show_db[(i-1)].used=application->gip[i];
  }

 //end of mark
 show_db[(i-1)].attr=GVRP_DB_END;
 show_db[(i-1)].used=GVRP_DB_END;
}


/* when port x enable gvrp, we have to get current vlan setting from vlan table
 * and set into gvrp database.
 *
 * Example: static vlan 10 , member port = 1,2,3
 *          port 4 receive GVRP Join 10
 *          => member port of vlan 10 = 1,2,3,4
 *   
 * At this time, port 4 not static configure setting, so we can't save this setting in astStaticVlanGrp variable
 */
       
void set_gvrp_db_from_reg(void)
{
 Tuint16 	usTblSize, usIndex=0;
 Tuint32 	gid_index;
 Tuint32 	i=0;
 Tuint16        usVlanId;
 Tbool          bStatic;
 Gid		*my_gid;
 TstPPortMask   stPortPhyMask, stTagPhyMask;
 TstLPortMask   stPortLogMask;

 K_VlanGetTblSize(&usTblSize);
 for (usIndex= 0; usIndex < usTblSize; ++usIndex) {

 if (K_VlanGetTblEntry(usIndex, &usVlanId, &bStatic,  &stPortPhyMask, 
	 &stTagPhyMask) == KRN_RET_OK) {
          
	  if(bStatic) {
  	     cclmx_PMask2LMask( &stPortLogMask, &stPortPhyMask);
             
	     if(!gvd_find_entry(my_gvr->gvd,usVlanId,&gid_index))
                gvd_create_entry(my_gvr->gvd, usVlanId , &gid_index);//update gvrp database

		for(i=0;i < MAX_LOGIC_PORT ; i++) {

                  //if( stPortLogMask.ulMask[i/32] & (0x01<< (i%32) ) ) {
	          if(K_LPortMaskGetPort(&stPortLogMask, i)) {

                      if(!gid_find_port( (&my_gvr->garp)->gid , i , &my_gid))
                        continue;
		      
		        gid_machine_set(my_gid,gid_index,Va,Inr);
                        gip_propagate_join(my_gid,gid_index);
		  }

	     }//for
	  }
   }//if
 }
}

// This function most like set_gvrp_db_from_reg(), and add the following line to save
// static vlan setting when GVRP startup
// memcpy(&astStaticVlanGrp[usVlanId],&stPortLogMask,sizeof(stPortLogMask)); 
void set_gvrp_db_from_reg_init(void)
{
 Tuint16 	usTblSize, usIndex=0;
 Tuint32 	gid_index;
 Tuint32 	i=0;
 Tuint16        usVlanId;
 Tbool          bStatic;
 Gid		*my_gid;
 TstPPortMask   stPortPhyMask, stTagPhyMask;
 TstLPortMask   stPortLogMask;

 K_VlanGetTblSize(&usTblSize);
 for (usIndex= 0; usIndex < usTblSize; ++usIndex) {

 if (K_VlanGetTblEntry(usIndex, &usVlanId, &bStatic,  &stPortPhyMask, 
	 &stTagPhyMask) == KRN_RET_OK) {
          
	  if(bStatic) {
  	     cclmx_PMask2LMask( &stPortLogMask, &stPortPhyMask);
             memcpy(&astStaticVlanGrp[usVlanId],&stPortLogMask,sizeof(stPortLogMask)); //save static vlan setting
             
	     if(!gvd_find_entry(my_gvr->gvd,usVlanId,&gid_index))
                gvd_create_entry(my_gvr->gvd, usVlanId , &gid_index);//update gvrp database

		for(i=0;i < MAX_LOGIC_PORT ; i++) {

                  //if( stPortLogMask.ulMask[i/32] & (0x01<< (i%32) ) ) {
	          if(K_LPortMaskGetPort(&stPortLogMask, i)) {

                      if(!gid_find_port( (&my_gvr->garp)->gid , i , &my_gid))
                        continue;
		      
		        gid_machine_set(my_gid,gid_index,Va,Inr);
                        gip_propagate_join(my_gid,gid_index);
		  }

	     }//for
	  }
   }//if
 }
}

//when pvid be modified
//Step1: clean original setting
//Step2: read vlan table again.
void reset_gvrp_db(void)
{
 Tuint8 i=0,j=0;
 Garp   *application= &my_gvr->garp;
 Gid    *my_gid;

 for(i=0;i< MAX_LOGIC_PORT;i++) {
   
   if(!gid_find_port(application->gid, i , &my_gid)){
       continue;
   }

   for(j = 1; j <= application->last_gid_used; j++) {
      gid_machine_set(my_gid,j,Vo,Mt);
   }
 }

 for (i = 1; i <= application->last_gid_used; i++) {
      application->gip[i]=0; //reset gip ring counter
      gvd_delete_entry(my_gvr->gvd,i); //del whole gvrp db
 }

}
