/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gmrp_netfilter.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2004/01/01
// Note   : communicate with user land program(CLI/Web)
// ********************************************

#include "krndef.h"
#include "garp_netfilter.h"

#ifndef GMRP_NETFILTER_H
#define GMRP_NETFILTER_H


#define GMRP_BASE_CTL		            (64+1024+64+64+1400)

#define SET_GMRP_GLOBAL_ENABLE              (GMRP_BASE_CTL+1)
#define SET_GMRP_GLOBAL_DISABLE        	    (GMRP_BASE_CTL+2)
#define SET_PORT_GMRP_ENABLE         	    (GMRP_BASE_CTL+3)
#define SET_PORT_GMRP_DISABLE	    	    (GMRP_BASE_CTL+4)
#define SET_GMRP_DEBUG_ENABLE          	    (GMRP_BASE_CTL+5)
#define SET_GMRP_DEBUG_DISABLE         	    (GMRP_BASE_CTL+6)
#define CLEAR_GMRP_STATISTICS_COUNTER       (GMRP_BASE_CTL+7)
#define SET_PORT_GMRP_FA                    (GMRP_BASE_CTL+8)
#define SET_NO_PORT_GMRP_FA                 (GMRP_BASE_CTL+9)
#define ADD_STATIC_MULTICAST_ENTRY          (GMRP_BASE_CTL+10)
#define DEL_STATIC_MULTICAST_ENTRY          (GMRP_BASE_CTL+11)
#define SET_GMRP_TRUNK_ADD		    (GMRP_BASE_CTL+12)
#define SET_GMRP_TRUNK_DEL		    (GMRP_BASE_CTL+13)
#define GMRP_SET_MAX                        (GMRP_BASE_CTL+50)

#define SHOW_GMRP_STATUS      	            (GMRP_BASE_CTL+1)
#define SHOW_GMRP_STATISTICS                (GMRP_BASE_CTL+2)
#define SHOW_PORT_GMRP                      (GMRP_BASE_CTL+3)
#define SHOW_GMRP_GIP                       (GMRP_BASE_CTL+4)
#define SHOW_GMRP_MACHINE                   (GMRP_BASE_CTL+5)
#define SHOW_GMRP_DB                        (GMRP_BASE_CTL+6)
#define GMRP_GET_MAX                        (GMRP_BASE_CTL+50)


#define GMRP_DB_END            		    (0)

/******************************************************************************
* GVR : GARP VLAN REGISTRATION APPLICATION : IMPLEMENTATION SIZING
*******************************************************************************/
enum {GMRP_DB_SIZE = 256};

//data structure is used when gvrp communicate with userland program
typedef struct
{
 Mac_addr attr;
 Tuint8   used;
} TstGmrpDB;


typedef struct  {
  Mac_addr      addr;
  TstLPortMask  stPortMask;
} TstGmrpMcst;


#endif
