/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gmrp_netfilter.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/01/01
// Note   : communicate with user land program(CLI/Web)
// ********************************************

#include "common.h"
#include "garp_common.h"
#include "gmrp_common.h"

extern Gmr 		*my_gmr;
extern Tuint32  	gmrp_debug_level;
extern Tbool 		gmrp_enable;
extern Mac_addr 	gmd_entry_not_exist;
extern garp_statistics  gmrp_statistics[MAX_LOGIC_PORT];

extern void 		(*gmrp_stp_port_forwarding)(Tuint32 );
extern void 		(*gmrp_stp_port_disabled)(Tuint32 );

Tuint8 			aucGmrpPortEbl[MAX_LOGIC_PORT];
TstGmrpMcst    		astStaticMcstGrp[GMRP_DB_SIZE];

/* This function is called whenever a process tries to do setsockopt */
int do_gmrp_set_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
{
 TstGmrpMcst    multicast_info;
 Garp     	*application=&my_gmr->garp;
 Mac_addr 	fa={1,1,1,1,1,1},fu={2,2,2,2,2,2}; //random number
 Tuint8		trunk_id;
 Tuint32  	i=0;
 Tuint32  	gid_index=0;
 Tuint32        debug_ebl=0;
 TstGarpTrk     stTrkInfo;
 TstLPortMask   logic_pm;
		 
 switch (cmd)
 {
 
 case SET_GMRP_GLOBAL_ENABLE:
      if(gmrp_enable==False) {     
         gmrp_stp_port_forwarding = gmrp_stp_connect_port;
         gmrp_stp_port_disabled   = gmrp_stp_disconnect_port;

 	 gip_create_gip(GMRP_DB_SIZE, &application->gip);
         gmd_create_gmd(GMRP_DB_SIZE, &my_gmr->gmd);
      
         gmd_create_entry(my_gmr->gmd, fa , &gid_index);
         gmd_create_entry(my_gmr->gmd, fu , &gid_index);
 
	 for(i=0;i < MAX_LOGIC_PORT; i++) {
             if(aucGmrpPortEbl[i] == True){
	        gid_create_port( &my_gmr->garp,i);
	     }
	 }
 
         gmrp_enable=True;
	 reset_gmrp_db();
	 set_gmrp_db_from_reg();
	 K_GmrpSetEbl(True);//Forward GMRP packet to CPU
      } 
      break;

  // disable GMRP protocol      
 case SET_GMRP_GLOBAL_DISABLE:
      if(gmrp_enable==True) {
         gmrp_enable=False;
      
         gmrp_stp_port_forwarding = NULL;
         gmrp_stp_port_disabled = NULL;
      
         K_GmrpSetEbl(False);//Broadcast GMRP packet 
         gmr_destroy_gmr(my_gmr);
      } 
      break;     

 case SET_PORT_GMRP_ENABLE:
      copy_from_user(&logic_pm,user,len);
      gid_port_enable(application,&logic_pm);
      reset_gmrp_db(); 
      set_gmrp_db_from_reg();
      break;
      
 case CLEAR_GMRP_STATISTICS_COUNTER:
      copy_from_user(&logic_pm,user,len); //get port info
      for(i=0;i < MAX_LOGIC_PORT ; i++) {
          //if(logic_pm.ulMask[i/32] & (0x01 <<(i%32) ) )
          if(K_LPortMaskGetPort(&logic_pm, i)) {
             memset(&gmrp_statistics[i],0,sizeof(gmrp_statistics[i]));
          }
      }
      break;

 case SET_GMRP_DEBUG_ENABLE:
      copy_from_user(&debug_ebl,user,len);
      gmrp_debug_level=gmrp_debug_level | debug_ebl;
      break;

 case SET_GMRP_DEBUG_DISABLE: 
      copy_from_user(&debug_ebl,user,len);
      gmrp_debug_level=gmrp_debug_level & ~debug_ebl;
      break;

 case ADD_STATIC_MULTICAST_ENTRY:
      copy_from_user(&multicast_info,user,len); //get port info
      for(i=0; i<GMRP_DB_SIZE ; i++) {
          if(mac_compare(astStaticMcstGrp[i].addr, gmd_entry_not_exist)) {
   	     memcpy(&astStaticMcstGrp[i], &multicast_info, sizeof(multicast_info));
	  }
      }
      gid_add_edit_static_multicast(multicast_info.addr, &multicast_info.stPortMask);
      break;


 case DEL_STATIC_MULTICAST_ENTRY:
      copy_from_user(&multicast_info,user,len); //get port info
      for(i=0; i<GMRP_DB_SIZE; i++) {
          if(mac_compare(astStaticMcstGrp[i].addr, multicast_info.addr)){
             memset(&astStaticMcstGrp[i],0 ,sizeof(TstGmrpMcst));
	  }
      }
      gid_del_static_multicast(multicast_info.addr);
      break;

 case SET_GMRP_TRUNK_ADD:
      copy_from_user(&stTrkInfo,user,len);
      if(gid_trunk_add(application, stTrkInfo)) {
         reset_gmrp_db();
	 set_gmrp_db_from_reg();
      }
      break;

 case SET_GMRP_TRUNK_DEL:
      copy_from_user(&trunk_id,user,len);
      if (gid_trunk_del(application, trunk_id)) {
	  reset_gmrp_db();
	  set_gmrp_db_from_reg();
      }
      break;

 default:
     if(gmrp_debug_level & GMRP_DEBUG_SYS)
        printk(" ioctl_num error..\n");
     break;  

 }//switch
 return 0;
}


/* This function is called whenever a process tries to do getsockopt */
int do_gmrp_get_ctl(struct sock *sk, int cmd, void *user, int *len)
{
  Tuint8   	 ucPortId=0;
  Garp   	 *application=&my_gmr->garp;
  Tuint8         gip_ring[MAX_LOGIC_PORT+1]; // store gip ring info
  TstGmrpDB 	 show_db[GMRP_DB_SIZE];// used by show_garp_db command
  TstLPortMask   logic_pm;
  Gid_machine    gmrp_machine[GMRP_DB_SIZE * MAX_LOGIC_PORT]; // store machine state

  switch(cmd)
  {
   case SHOW_GMRP_STATUS:
        copy_to_user(user,&gmrp_enable,sizeof(gmrp_enable));
        break;

   case SHOW_GMRP_STATISTICS:
        copy_to_user(user,gmrp_statistics,sizeof(gmrp_statistics));
        break;

   case SHOW_PORT_GMRP:
	memset(&logic_pm,0,sizeof(logic_pm));
        if(gmrp_enable==True) {
           for(ucPortId=0;ucPortId< MAX_LOGIC_PORT;ucPortId++) {
             if(aucGmrpPortEbl[ucPortId] == True){
               //logic_pm.ulMask[ucPortId/32] |= (0x01<<(ucPortId%32) );
               K_LPortMaskSetPort(&logic_pm, ucPortId);
             }
           }
        }
        copy_to_user(user,&logic_pm,sizeof(logic_pm));
	break;

   case SHOW_GMRP_GIP:
        gip_ring_info(application,gip_ring);
        copy_to_user(user,gip_ring,sizeof(gip_ring));
        break;
  
   case SHOW_GMRP_MACHINE:
        gidtt_machine_info(application, gmrp_machine);
        copy_to_user(user,gmrp_machine,  sizeof(gmrp_machine));
        break; 
  
   case SHOW_GMRP_DB:
        gmrp_db_info(show_db); 
        copy_to_user(user,show_db, sizeof(show_db));
        break;
      

  }//switch

  return 0;
}

struct nf_sockopt_ops gmrp_sockopts = {
                { NULL, NULL }, PF_INET,
                GMRP_BASE_CTL, GMRP_SET_MAX+1, do_gmrp_set_ctl, NULL,
                GMRP_BASE_CTL, GMRP_GET_MAX+1, do_gmrp_get_ctl, NULL};   
