/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ***********************************************************
// Name   : gmr.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/11/26
// Note   : GMR = "GARP Multicast REGISTRATION APPLICATION" 
// ************************************************************

#include "common.h"
#include "garp_common.h"
#include "gmrp_common.h"

extern garp_statistics  gmrp_statistics[MAX_LOGIC_PORT];
extern Tuint32 		gmrp_debug_level;
extern Mac_addr 	gmd_entry_not_exist;
extern Gmr 		*my_gmr;

Tbool gmr_create_gmr(Tuint32 process_id, Tuint16 vid,void **gmr)
{ 
     
	Garp *my_gmr;

	if (!sysmalloc(sizeof(Gmr), (void **)&my_gmr)){
  	   goto gmr_creation_failure;
	}
		
	my_gmr->process_id = process_id;
	my_gmr->gid = NULL;
	
	my_gmr->max_gid_index = GMRP_DB_SIZE  - 1;
	my_gmr->last_gid_used = 0;
	my_gmr->join_indication_fn = gmr_join_indication;
	my_gmr->leave_indication_fn = gmr_leave_indication;
	my_gmr->join_propagated_fn = gmr_join_propagated;
	my_gmr->leave_propagated_fn = gmr_leave_propagated;
	my_gmr->transmit_fn = gmr_tx;
        my_gmr->receive_fn = gmr_rcv; 
	my_gmr->added_port_fn = gmr_added_port;
	my_gmr->removed_port_fn = gmr_removed_port;
        ((Gmr *)my_gmr)->vlan_id=vid;

        ((Gmr *)my_gmr)->number_of_gmd_entries = GMRP_DB_SIZE;
	((Gmr *)my_gmr)->last_gmd_used_plus1 = 0;

	*gmr = my_gmr;
         return(True);

gmr_creation_failure: return (False);
}


void gmr_destroy_gmr(void *gmr)
{
   Gid 	*my_port;
   Garp *application=&my_gmr->garp;
 
   while((my_port = application->gid) != NULL) {
       gid_stop_all_timer(my_port);
       gid_destroy_port( application, my_port->port_no);
       memset(&gmrp_statistics[my_port->port_no],0,sizeof(garp_statistics));
   }
   
   gmd_destroy_gmd(my_gmr->gmd);
   gip_destroy_gip(application->gip);

}


/*
 * Provide any management initialization of legacy control or multicast
 * attributes from templates here for the new port.
*/
void gmr_added_port(void *gmr, Tuint32 port_no)
{ 
 Garp *application=&my_gmr->garp;

 if(cclmx_PortGetStpState(port_no) == STP_PORT_FORWARDING){
    gip_connect_port(application, port_no);
 }

}



/*
 * Provide any GMR specific cleanup or management alert functions for the removed port.
*/
void gmr_removed_port(void *my_gmr, Tuint32 port_no)
{ 
}

/******************************************************************************
 *  GMR : GARP MULTICAST REGISTRATION APPLICATION : JOIN, LEAVE INDICATIONS
 * ******************************************************************************
*/
/*
* This implementation of gmr_join_indication() respects the three cases
* described in the header file for the state of the Filtering Database and
* the registered Legacy controls (Forward All, Forward Unregistered) and
* Multicasts. It makes some, but not a perfect, attempt to optimize
* calls to the Filtering Database when one Legacy mode transitions to
* another.
*/
void gmr_join_indication(void *gmr, void *port, Tuint32 joining_gid_index)
{

     Gid 	*my_port=(Gid *)port;
     Mac_addr 	key;

     if ((joining_gid_index == Forward_all ) || (joining_gid_index == Forward_unregistered)) {
	     if(joining_gid_index == Forward_all){
	        fdb_forward_all_by_default( ((Gmr *)my_gmr)->vlan_id, my_port->port_no);
	     }
	     else {
	        fdb_forward_unregistered_by_default( ((Gmr *)my_gmr)->vlan_id, my_port->port_no);
	     }
     }
     else { /* Multicast Attribute */
	     if(gmd_get_key(((Gmr *)my_gmr)->gmd, joining_gid_index , key)){
	        mfdb_forward( ((Gmr *)my_gmr)->vlan_id,my_port->port_no, key);
	     }
     }

}
		
		
void gmr_join_propagated(void *gmr, void *port, Tuint32 joining_gid_index)
{ 
}
		

void gmr_leave_indication(void *gmr, void *port, Tuint32 leaving_gid_index)
{ 
     
	Tuint32 	gmd_index=0;
        Gid 		*my_port=(Gid *)port;
        Mac_addr 	key;
	
        if ( (leaving_gid_index == Forward_all ) || ( leaving_gid_index == Forward_unregistered)) {
		// Set port x to normal port not router port
		fdb_filter_by_default(((Gmr *)my_gmr)->vlan_id, my_port->port_no);
	}
	else {
		gmd_index = leaving_gid_index;

		if(gmd_get_key(((Gmr *)my_gmr)->gmd, gmd_index, key)){
			mfdb_filter(((Gmr *)my_gmr)->vlan_id, my_port->port_no, key);
		}
        } 
}
		
		
void gmr_leave_propagated(void *gmr, void *port, Tuint32 leaving_gid_index)
{

}
		
		
/******************************************************************************
 * * GMR : GARP MULTICAST REGISTRATION APPLICATION : RECEIVE MESSAGE PROCESSING
 ******************************************************************************
*/
 
/*
* If it is desirable to be able to operate correctly with an undersized
* database, add code here. The best approach seems to be to use GID
* management controls to configure the attribute for the Legacy mode
* control Forward_all to be Registration fixed on all ports on which join
* messages have been discarded because their keys are not in the database.
* Then start a retry timer, which attempts to scavenge space from the
* database at a later time, and, if it succeeds, waits for a few LeaveAll
* times before switching Forward_all back to Normal_registration.
*/

static void gmr_db_full(Gmr *my_gmr, Gid *my_port)
{
  if(gmrp_debug_level & GMRP_DEBUG_DB){
    printk("GMRP: GMRP Database full...\n");
  }

}

/*
 * Process one received message.
 * *
 * * Dispatch messages by message event, and by attribute type (legacy mode
 * * control, or multicast address) except in the case of the LeaveAll
 * * message event, which applies equally to all attributes.
 * *
 * * A LeaveAll message never causes an indication (join or leave directly),
 * * even for the poTuint32 to poTuint32 link protocol enhancements (where an
 * * ordinary Leave does). No further work is needed here.
 * *
 * * A LeaveAllRange message is currently treated exactly as a LeaveAll
 * * (i.e., the range is ignored).
 * *
 * * All the remaining messages refer to a single attribute (i.e., a single
 * * registered group address). Try to find a matching entry in the MCD
 * * database. If one is found, dispatch the message to a routine that will
 * * handle both the local GID effects and the GIP propagation to other ports.
 * *
 * * If no entry is found, Leave and Empty messages can be discarded, but
 * * JoinIn and JoinEmpty messages demand further treatment. First, an attempt
 * * is made to create a new entry using free space (in the database, which
 * * corresponds to a free GID machine set). If this fails, an attempt may be
 * * made to recover space from a machine set that is in an unused or less
 * * significant state. Finally, the database is considered full and the received
 * * message is discarded.
 * *
 * * Once (if) an entry is found, Leave, Empty, JoinIn, and JoinEmpty are
 * * all submitted to GID (gid_rcv_msg()).
 * *
 * * JoinIn and JoinEmpty may cause Join indications, which are then propagated
 * * by GIP.
 * *
 * * On a shared medium, Leave and Empty will not give rise to indications
 * * immediately. However, this routine does test for and propagate
 * * Leave indications so that it can be used unchanged with a point-to-point
 * * protocol enhancement.
 * *
 * */
     
static void gmr_rcv_msg(Gmr *gmr, Gid *my_port, Gmf_msg *msg)
{
  Garp 		*application=&my_gmr->garp;
  Tuint32 	gid_index = GMRP_DB_SIZE;

  if ( msg->event == Gid_rcv_leaveall ) {
     gid_rcv_leaveall(my_port);
  }
  else {
    if (msg->attribute == Legacy_attribute) { //0x02: Group service requirement information
      gid_index = msg->legacy_control+1; //Forward All=1, Forward unregister=2
    }
    else if (!gmd_find_entry(((Gmr *)my_gmr)->gmd, msg->key1, &gid_index)) {//0x01:Group address registration
       if ( (msg->event == Gid_rcv_joinin) || (msg->event == Gid_rcv_joinempty)) {
 	 if (!gmd_create_entry( my_gmr->gmd, msg->key1, &gid_index)) {
	    if (gid_find_unused( application, 3 , &gid_index)) { //skip FA(1) / FU(2)
		  gmd_delete_entry(my_gmr->gmd, gid_index);
		  (void) gmd_create_entry(my_gmr->gmd, msg->key1, &gid_index);
	    }
	    else{
		  gmr_db_full(my_gmr, my_port);
	    }
	 }//if
       }//if
    }//else if

    if (gid_index != GMRP_DB_SIZE){
        gid_rcv_msg(my_port, gid_index, msg->event);
    }
  }//else
}
	
	
/*
* Process an entire received pdu for this instance of GMR: initialize
* the Gmf pdu parsing routine, and, while messages last, read and process
* them one at a time.
*/
Tuint32 gmr_rcv(void *gmr, void *port, void *rx_pdu)
{

  Gmf_msg  	msg;
  Gid 		*my_port=(Gid *)port;
  
  Pdu 		*rcv_pdu=(Pdu *)rx_pdu;
  Tuint8 	*pdu= rcv_pdu->data+3; //skip dsap+ssap+cf
#ifdef __LINUX_2_6_19__
  Tuint16 	pdu_len =ntohs(eth_hdr(rcv_pdu)->h_proto);
#else
  Tuint16 	pdu_len =ntohs(rcv_pdu->mac.ethernet->h_proto);
#endif
  Tuint32 	i;

  // *** Parsing GMRP PDU
  if(gmrp_debug_level & GMRP_DEBUG_PDU) {
   for(i=0;i< pdu_len ;i++){
      printk("%x-",*(rcv_pdu->data+i));
   }
   printk("\n");
  }

   // get protocol id 
  if( get_2_bytes(&pdu) != 0x01 ) {
   if(gmrp_debug_level & GMRP_DEBUG_ERR){
      printk(" GMRP: protocol id != 0x01 \n");
   }
   return(False);
  }   
  

  // Maybe more than one message in the same PDU
  while( (check_1_byte(&pdu)!= 0x00) && (pdu < rcv_pdu->data+pdu_len) ) {
   
     // get attribute type: 0x01=gmrp_parsing_attribute; 0x02=Service requirement registration
     if((msg.attribute = get_1_byte(&pdu)) > 0x02) {
       if(gmrp_debug_level & GMRP_DEBUG_ERR){
          printk(" GMRP: attribute type =%d > 2\n",msg.attribute);
       }

       if(skip_attribute_list(&pdu, pdu_len)==True){
          continue;
       }
       else {
          return(True); //no other message in PDU 
       }
     }   

     // get attribute list
     // if attribute length or event or value has error...skip this attribute
     while(check_1_byte(&pdu)!=0x00) {//check attribute length
	     
	     //There is another attribute in the message X
	     //boundary check
	     if((rcv_pdu->data+pdu_len)-pdu >= 4 ) {//4bytes = len+event+2xend_of_mark
		 if(!gmrp_parsing_attribute(&pdu,&msg)){ //get attribute length/event/value
		    return(False);
		 }
	     }  
	     else {
	         return(False);
	     }

	     // invaild value for attribute event
	     if( msg.event==Gid_null) {
		 if(gmrp_debug_level & GMRP_DEBUG_ERR){
	   	    printk(" GMRP: msg.event ==Gid_null \n");
		 }
		 continue;   
	     }


	     //attribute_length of LeaveAll msg is 2(attribute_length+attribute_event)
	     if((msg.event==Gid_rcv_leaveall) && (msg.length!=2) ) {
		 if(gmrp_debug_level & GMRP_DEBUG_ERR){
	   	    printk(" GMRP: msg.event==Gid_rcv_leaveall && msg.length=%lu !=2 \n",msg.length);
		 }
		 continue;
	     }

	     if((msg.attribute==0x01) && (msg.event!=Gid_rcv_leaveall) && (msg.length!=8)) {
	         if(gmrp_debug_level & GMRP_DEBUG_ERR){
		    printk(" GMRP: msg.event!=Gid_rcv_leaveall  && msg.length=%lu!=8 \n",msg.length);
		 }          
		 continue;
	     }

	     if((msg.attribute==0x02) && (msg.length>3)){ //attribute value only 1 byte
		 if(gmrp_debug_level & GMRP_DEBUG_ERR){
	   	    printk(" GMRP: Recv Group service requirement information msg but len=%lu > 3 \n",msg.length);
		 }
		 continue;
	     }

	     //update statistics counter 
	     if(msg.event==Gid_rcv_leaveall){
	        gmrp_statistics[my_port->port_no].LeaveAll_rx++;
	     }
	     else if(msg.event==Gid_rcv_joinempty){ 
		gmrp_statistics[my_port->port_no].JoinEmpty_rx++;
	     }
	     else if(msg.event==Gid_rcv_joinin){ 
		gmrp_statistics[my_port->port_no].JoinIn_rx++;
	     }
	     else if(msg.event==Gid_rcv_empty){ 
		gmrp_statistics[my_port->port_no].Empty_rx++;
	     }
	     else if(msg.event==Gid_rcv_leavein){ 
		gmrp_statistics[my_port->port_no].LeaveIn_rx++;
	     }
	     else if(msg.event==Gid_rcv_leaveempty){ 
		gmrp_statistics[my_port->port_no].LeaveEmpty_rx++;
	     }

	     gmr_rcv_msg(my_gmr, my_port, &msg); 

     }//while
     (void)get_1_byte(&pdu); //There is a end_of_mark field between two message 
 
 }//while

  return(True);
}

/******************************************************************************
 * * GMR : GARP MULTICAST REGISTRATION APPLICATION : TRANSMIT PROCESSING
 * ******************************************************************************
 * */
Tbool gmr_tx_msg(Gmr *gmr, Tuint32 gid_index, Gmf_msg *msg)
{
  Garp *application=&my_gmr->garp;
 
  if(msg->event == Gid_tx_leaveall) {
     msg->attribute = Gmr_All_attributes;
     return True;
  }

  else if (gid_index == Forward_all || gid_index== Forward_unregistered) {
     
     msg->attribute = Legacy_attribute;
     if(gid_index==Forward_all){
	     msg->legacy_control = Forward_all - 1; //1->0
     } else {
	     msg->legacy_control = Forward_unregistered - 1;//2->1
     }

     return True;
  }
  else { /* index for Multicast_attribute */
     msg->attribute = Multicast_attribute;
   
     //gmd_index = gid_index - Number_of_legacy_controls;
     gmd_get_key(my_gmr->gmd, gid_index, msg->key1);

     if((mac_compare(msg->key1,gmd_entry_not_exist)) || ( application->gip[gid_index]==0) ){ //entry exist
	 return False;//can't find or inactive
     }
     else{
	 return True;
     }
  } 
}



/*
* Get and prepare a pdu for the transmission, if one is not available,
* simply return; if there is more to transmit, GID will reschedule a call
* to this function. Get messages to transmit from GID and pack them into the pdu using Gmf
* (MultiCast pdu Formatter).
*/
 
void gmr_tx(void *gmr, void *port)
{
 Pdu         *pdu;
 Gmf_msg     msg;
 Gid_event   tx_event;
 Tuint32     gid_index;
 Gid         *my_port=port;
 Tuint8      end_mark=0x00;
 Tuint32     pkt_valid=0;
 garp_statistics tmp_counter;

 memset(&tmp_counter,0,sizeof(garp_statistics));

 /*if there is more to transmit GID will reschedule a call to this function*/
 if ((tx_event = gid_next_tx(my_port, &gid_index)) != Gid_null) {
    
   if (syspdu_alloc(&pdu)) {
     gmrp_wrmsg_init(&pdu);
     
     do {
	msg.event = tx_event; //attribute event
	
	if(!gmr_tx_msg(my_gmr, gid_index, &msg)){ 
	  continue; 
	}
		           
       	if (!gmrp_wrmsg(&pdu, &msg)){ // fill out message N
	  syspdu_free(pdu);//added by rhliu
	  return;
	}	

	if(msg.event==0){
	   tmp_counter.LeaveAll_tx++;
	}
	else if(msg.event==1){
  	   tmp_counter.JoinEmpty_tx++;
	}
	else if(msg.event==2){
	   tmp_counter.JoinIn_tx++;
	}
	else if(msg.event==3){
   	   tmp_counter.LeaveEmpty_tx++;
	}
	else if(msg.event==4){
	   tmp_counter.LeaveIn_tx++;
	}
	else if(msg.event==5){
	   tmp_counter.Empty_tx++;
	}

	//Now, PDU have payload
	pkt_valid=True;	
	
     } while((tx_event = gid_next_tx(my_port, &gid_index))!= Gid_null);

     //end of pdu
     put_unaligned(end_mark,(Tuint8 *)skb_put(pdu,1));  

     if(pkt_valid==False) {//Is pkt empty (only have garp header)
	syspdu_free(pdu);
     }
     else {
	gmrp_statistics[my_port->port_no].LeaveAll_tx +=tmp_counter.LeaveAll_tx;
	gmrp_statistics[my_port->port_no].JoinEmpty_tx +=tmp_counter.JoinEmpty_tx;
	gmrp_statistics[my_port->port_no].JoinIn_tx +=tmp_counter.JoinIn_tx;
	gmrp_statistics[my_port->port_no].LeaveEmpty_tx +=tmp_counter.LeaveEmpty_tx;
	gmrp_statistics[my_port->port_no].LeaveIn_tx +=tmp_counter.LeaveIn_tx;
	gmrp_statistics[my_port->port_no].Empty_tx +=tmp_counter.Empty_tx;

	syspdu_tx(pdu,my_port->port_no);
     }
   }//if
 }//if


} 
