/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gmd.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2004/01/01
// Note   : gmrp database 
// ********************************************

#ifndef GARP_GMD_H__
#define GARP_GMD_H__

#include "gmrp_netfilter.h"

/******************************************************************************
* GMD : GARP MULTICAST REGISTRATION APPLICATION DATABASE
******************************************************************************
*/

/*
* Creates a new instance of GMD, allocating space for up to max_multicasts
* MAC addresses. Returns True if the creation succeeded together with a pointer to the
* GMD information.
*/
extern Tbool gmd_create_gmd(Tuint32 max_multicasts, void **gmd);

/*
* Destroys the instance of gmd, releasing previously allocated database and
* control space.
*/
extern void gmd_destroy_gmd(void *gmd);


extern Tbool gmd_find_entry( void *my_gmd, Mac_addr key,Tuint32 *found_at_index);
extern Tbool gmd_create_entry(void *my_gmd, Mac_addr key,Tuint32 *created_at_index);
extern Tbool gmd_delete_entry(void *my_gmd,Tuint32 delete_at_index);
extern Tbool gmd_get_key( void *my_gmd, Tuint32 index, Mac_addr key);
extern void gmrp_db_info(TstGmrpDB show_db[]);
extern void set_gmrp_db_from_reg(void);
extern void reset_gmrp_db(void);
#endif /* gmd_h__ */
