/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// *******************************************************************
// Name   : gmd.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/11/25
// Note   : GARP Multicast Database 
//         (Maintaining the relationship between gid_index and multicast addr)
// ********************************************************************

#include "common.h"
#include "garp_common.h"
#include "gmrp_common.h"

extern Gmr 		*my_gmr;
extern TstGmrpMcst      astStaticMcstGrp[GMRP_DB_SIZE];
Mac_addr 		gmd_entry_not_exist={0x00,0x00,0x00,0x00,0x00,0x00};

/*
* Creates a new instance of GMD, allocating space for up to max_multicasts
* MAC addresses. Returns True if the creation succeeded together with a pointer to the
* GMD information.
*/
Tbool gmd_create_gmd(Tuint32 max_multicasts, void **gmd)
{
 void *my_gmd;

 if (!sysmalloc(sizeof(Mac_addr)* max_multicasts , (void **)&my_gmd)){
    return(False);
 }

 *gmd = my_gmd; 
  
 return(True);
}


/*
* Destroys the instance of gmd, releasing previously allocated database and
* control space.
*/
void gmd_destroy_gmd(void *gmd)
{
 Garp *application=&my_gmr->garp;

 application->last_gid_used=0;
 sysfree(gmd);
} 

// search certain entry using mac address
Tbool gmd_find_entry( void *gmd, Mac_addr key,Tuint32 *found_at_index)
{ 
  Mac_addr *my_gmd=(Mac_addr *)gmd;
  Tuint32 i=1;

  for(i=1 ;i<GMRP_DB_SIZE;i++) {
   if( mac_compare(my_gmd[i],key)){ //entry exist
    *found_at_index=i;
    return (True);
   }
  }

  return (False); 
}

// create new entry in gmrp database
Tbool gmd_create_entry(void *gmd, Mac_addr key,Tuint32 *created_at_index)
{
  Mac_addr *my_gmd=(Mac_addr *)gmd;
  Garp *application=&my_gmr->garp;
  Tuint32 i=1;

  for(i=1 ;i<GMRP_DB_SIZE;i++) {
  
   if( mac_compare(my_gmd[i], gmd_entry_not_exist) ) { // entry not exist 
      
      *created_at_index=i;

      //maintain last_gid_used pointer
      if(application->last_gid_used < i) {
        my_gmr->last_gmd_used_plus1=i;
        application->last_gid_used=i;
      }

      mac_clone(key,my_gmd[i]);
      return(True);
    } 
  }

  return (False);    

}

// delete certain entry using gmd index
Tbool gmd_delete_entry(void *gmd,Tuint32 delete_at_index)
{
 Mac_addr *my_gmd=(Mac_addr *)gmd;
  
 if( !mac_compare(my_gmd[delete_at_index], gmd_entry_not_exist)) { // entry exist
     mac_clone(gmd_entry_not_exist,my_gmd[delete_at_index]); 
     return(True);
 }

 return(False);  

}

// get mac address using gmd index
Tbool gmd_get_key( void *gmd, Tuint32 index, Mac_addr key)
{
  Mac_addr *my_gmd=(Mac_addr *)gmd;

  if(!mac_compare(my_gmd[index], gmd_entry_not_exist)) {//entry exist
    mac_clone(my_gmd[index],key);
    return(True);
  }
 
  mac_clone(gmd_entry_not_exist, key); //invaild value
  return(False);    
}

// get all GMRP Database info
void gmrp_db_info(TstGmrpDB show_db[])
{
 Garp 		*application= &my_gmr->garp;
 Tuint8  	aucUnused[MAC_ADDR_LEN]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
 Tuint32	i=0;

 for(i=1; i <= application->last_gid_used && i<GMRP_DB_SIZE ;i++) {
     gmd_get_key(my_gmr->gmd, i , show_db[(i-1)].attr);

     if(mac_compare(show_db[(i-1)].attr, gmd_entry_not_exist)) {
         memcpy(show_db[(i-1)].attr,aucUnused,MAC_ADDR_LEN);
     }

     show_db[(i-1)].used=application->gip[i];
 }
      
 //end of mark
 memcpy(show_db[(i-1)].attr, gmd_entry_not_exist,sizeof(gmd_entry_not_exist) ) ;
 show_db[(i-1)].used=GMRP_DB_END;

}


//get mac info from mac table and set gmrp database
void set_gmrp_db_from_reg(void)
{
  Tbool   	bStatic;
  Tuint8 	aucMac[MAC_ADDR_LEN];
  Tuint32 	gid_index;
  Tuint32 	i;
  Tuint16 	usSize;
  Tuint16 	usIndex;
  Tuint16 	usFid;
  Gid     	*my_gid;
  TstPPortMask  stMcstPhyMask;
  TstLPortMask  stMcstLogMask;

  K_MacGetTblSize(&usSize);
  for (usIndex = 0; usIndex < usSize; ++usIndex) {

      if (K_MacGetTblEntry(True, usIndex, aucMac, &usFid, &bStatic, &stMcstPhyMask ) != KRN_RET_OK) {
         continue;
      }

      if(bStatic) {
         cclmx_PMask2LMask( &stMcstLogMask, &stMcstPhyMask);
  
  	 // save static multicast setting
	 for(i=0; i<GMRP_DB_SIZE; i++) {
           if(mac_compare(astStaticMcstGrp[i].addr, aucMac)){
              memcpy(&astStaticMcstGrp[i],&stMcstLogMask,sizeof(stMcstLogMask)); 
	      break;
	   }
	 }

         if(!gmd_find_entry(my_gmr->gmd, aucMac , &gid_index)){
            gmd_create_entry(my_gmr->gmd, aucMac , &gid_index);
	 }

	 for(i=0;i<MAX_LOGIC_PORT;i++) {
	     //if( stMcstLogMask.ulMask[i/32] & (0x01 << (i%32) )) {
	     if(K_LPortMaskGetPort(&stMcstLogMask, i)) {
	   	    
	        if(!gid_find_port( (&my_gmr->garp)->gid, i , &my_gid)){
	  	    continue;
		}

		gid_machine_set(my_gid,gid_index,Va,Inr);
		gip_propagate_join(my_gid,gid_index);
	     }
	 }
      }
  }
}

// clear all entry in GMRP Database
void reset_gmrp_db(void)
{
 Tuint8 i=0,j=0;
 Garp   *application= &my_gmr->garp;
 Gid    *my_gid;

 for(i=0;i< MAX_LOGIC_PORT;i++) {
   
   if(!gid_find_port(application->gid, i , &my_gid)){
       continue;
   }

   // skip "Forward all" and "Forward unregister"
   for(j = 3; j <= application->last_gid_used; j++) { 
      gid_machine_set(my_gid,j,Vo,Mt);
   }
 }

 for (i = 3; i <= application->last_gid_used; i++) {
      application->gip[i]=0; //reset gip ring counter
      gmd_delete_entry(my_gmr->gmd,i); //del whole gmrp db
 }

}

