/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gip.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : GARP INFORMATION PROPAGATION
// ********************************************

#ifndef GARP_GIP_H__
#define GARP_GIP_H__

/******************************************************************************
* GIP : GARP INFORMATION PROPAGATION : CREATION, DESTRUCTION
*******************************************************************************/
extern Tbool gip_create_gip(Tuint32 max_attributes, Tuint32 **gip);
extern void gip_destroy_gip(void *gip);

/******************************************************************************
* GIP : GARP INFORMATION PROPAGATION : PROPAGATION FUNCTIONS
*******************************************************************************/
extern void gip_connect_port(Garp *application, Tuint32 port_no);
extern void gip_disconnect_port(Garp *application, Tuint32 port_no);
extern void gip_propagate_join(Gid *my_port, Tuint32 index);
extern void gip_propagate_leave(Gid *my_port, Tuint32 index);
extern Tbool gip_propagates_to(Gid *my_port, Tuint32 index);
extern void gip_do_actions(Gid *my_port);
extern void gip_ring_info(Garp *application,Tuint8 gip_ring[]);

extern void gvrp_stp_connect_port(Tuint32 port_no);
extern void gvrp_stp_disconnect_port(Tuint32 port_no);
extern void gmrp_stp_connect_port(Tuint32 port_no);
extern void gmrp_stp_disconnect_port(Tuint32 port_no);

#endif /* gip_h__ */

