/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gidtt.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : GID PROTOCOL TRANSITION TABLES
// ********************************************

#ifndef GARP_GIDTT_H__
#define GARP_GIDTT_H__


enum {Number_of_applicant_states = Qon + 1}; /* for array sizing */
enum {Number_of_registrar_states = Mtf + 1}; /* for array sizing */

enum Timers
{
 Nt = 0,  /* No timer action */
 Jt = 1,  /* cstart_join_timer */
 Lt = 1   /* cstart_leave_timer */
};

enum Applicant_msg
{
 Nm = 0, /* No message to transmit */
 Jm, /* Transmit a Join */
 Lm, /* Transmit a Leave */
 Em  /* Transmit an Empty */
};

enum Registrar_indications
{
 Ni = 0, // No indication
 Li = 1, // Leave indication
 Ji = 2  // Join indication
};

/******************************************************************************
* GIDTT : GID PROTOCOL TRANSITION TABLES : TRANSITION TABLE STRUCTURE
*******************************************************************************/

typedef struct /* Applicant_tt_entry */
{
 Tuint32 new_app_state : 5; /* {Applicant_states} */
 Tuint32 cstart_join_timer : 1;  // Nt, Jt or Lt (1bit)
} Applicant_tt_entry;

typedef struct /* Registrar_tt_entry */
{
 Tuint32 new_reg_state : 5;
 Tuint32 indications : 2;
 Tuint32 cstart_leave_timer : 1;
} Registrar_tt_entry;

typedef struct /* Applicant_txtt_entry */
{
 Tuint32 new_app_state : 5;
 Tuint32 msg_to_transmit : 2; /* Applicant_msgs */
 Tuint32 cstart_join_timer : 1;
} Applicant_txtt_entry;

typedef struct /* Registrar_leave_timer_entry */
{
 Tuint32 new_reg_state : 5; /* Registrar_states */
 Tuint32 leave_indication : 1;
 Tuint32 cstart_leave_timer : 1;
} Registrar_leave_timer_entry;


extern Tbool registrar_in_table[];
extern Gid_registrar_mgt registrar_mgt_table[];
extern Gid_registrar_state registrar_state_table[];
extern Gid_applicant_mgt applicant_mgt_table[];
extern Gid_applicant_state applicant_state_table[];
extern Registrar_leave_timer_entry registrar_leave_timer_table[];
extern Applicant_txtt_entry applicant_txtt[];

extern Applicant_tt_entry applicant_tt[Number_of_gid_rcv_events  +
                                       Number_of_gid_req_events  +
                                       Number_of_gid_amgt_events +
				       Number_of_gid_rmgt_events]
				       [Number_of_applicant_states];
				       
extern Registrar_tt_entry registrar_tt[Number_of_gid_rcv_events  + 
                                       Number_of_gid_req_events  +
                                       Number_of_gid_amgt_events + 
				       Number_of_gid_rmgt_events]
				       [Number_of_registrar_states]; 

extern Gid_event gidtt_event(Gid *my_port,Gid_machine *machine,Gid_event event);
extern Gid_event gidtt_tx(Gid *my_port,Gid_machine *machine);
extern Gid_event gidtt_leave_timer_expiry(Gid *my_port,Gid_machine *machine);
extern Tbool gidtt_in(Gid_machine *machine);
extern Tbool gidtt_machine_active(Gid_machine *machine);
extern void gidtt_states(Gid_machine *machine,Gid_states *state);
extern void gidtt_machine_info(Garp *application, Gid_machine  gvrp_machine[]);

#endif /* gidtt_h__ */

