/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : garp_pdu.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : 802.1D-1998 p163, Format of the GARP PDU
// ********************************************
#ifndef GARP_PDU_H__
#define GARP_PDU_H__

#ifdef __GVRP__
#include "gvrp_common.h"
#endif

#ifdef __GMRP__
#include "gmrp_common.h"
#endif

/******************************************************************************
* GVF : GARP VLAN REGISTRATION APPLICATION PDU FORMATTING
*******************************************************************************/
/*
* This data structure saves the temporary state required to parse GVR
* PDUs in particular. 
*/

#ifdef __GVRP__
typedef struct 
{
 Attribute_type attribute;
 Tuint32        length;
 Gid_event  event;
 Vlan_id    key1;
} Gvf_msg;
#endif


#ifdef __GMRP__
typedef struct 
{
 Attribute_type     attribute;
 Tuint8             legacy_control;
 Tuint32            length;
 Gid_event          event;
 Mac_addr           key1;
} Gmf_msg;
#endif


#ifdef __GVRP__
extern Tbool gvrp_wrmsg_init(Pdu **pdu);
extern Tbool gvrp_wrmsg(Pdu **pdu, Gvf_msg *msg);
extern Tbool gvrp_parsing_attribute(Tuint8 **p, Gvf_msg *msg);
#endif

#ifdef __GMRP__
extern Tbool gmrp_wrmsg_init(Pdu **pdu);
extern Tbool gmrp_wrmsg(Pdu **pdu, Gmf_msg *msg);
extern Tbool gmrp_parsing_attribute(Tuint8 **p, Gmf_msg *msg);
#endif

extern Tbool skip_attribute_list(Tuint8 **p, Tuint32 size);

#endif
