/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : garp_pdu.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : garp pdu processing
// ********************************************

#include "common.h"
#include "garp_common.h"

#ifdef __GVRP__
#include "gvrp_common.h"
#endif

#ifdef __GMRP__
#include "gmrp_common.h"
#endif

extern Tuint8 ga_my_mac[MAC_ADDR_LEN];

// skip attribute_list in GVRP PDU
Tbool skip_attribute_list(Tuint8 **p, Tuint32 size)
{
 Tuint8 *init=*p;
 
 while(*p - init < size) {
  //search boundary: end_mark of message N-1 (0x00)+ attribyte_type of message N(0x01)
  if( (get_1_byte(p)==0x00) && (get_1_byte(p)==0x01) ) {
     *p=*p-1; //pointer to attribute type field
     return (True);
  }
 }
 
 return(False);
}


#ifdef __GVRP__
//fill in common header including dest_mac, source_mac, len, dsap, ssap, control flag, proto_id, and type
Tbool gvrp_wrmsg_init(Pdu **pdu)
{
  Tuint8  dsap=0x42, ssap=0x42, cf=0x03, attr_type=0x01; //control filed
  Tuint16 len=0x00, protocol_id=htons(0x0001);
  
  //gvrp dst_mac= 01:80:c2:00:00:21
  put_unaligned(0x8001,(Tuint16 *)skb_put(*pdu,2));
  put_unaligned(0x210000c2,(Tuint32 *)skb_put(*pdu,4));
     
  //src mac
  memcpy(skb_put(*pdu,MAC_ADDR_LEN),ga_my_mac,MAC_ADDR_LEN);
   
  put_unaligned(len ,(Tuint16 *)skb_put(*pdu,2)); //rewrite this field before pkt sent
  put_unaligned(dsap,(Tuint8 *)skb_put(*pdu,1));
  put_unaligned(ssap,(Tuint8 *)skb_put(*pdu,1));
  put_unaligned(cf  ,(Tuint8 *)skb_put(*pdu,1));

  put_unaligned(protocol_id,(Tuint16 *)skb_put(*pdu,2));
  put_unaligned(attr_type,(Tuint8 *)skb_put(*pdu,1)); //attribute type

  return(True);

}
#endif

#ifdef __GVRP__
// extract length/event/value from attribute N in GVRP PDU
Tbool gvrp_parsing_attribute(Tuint8 **pdu, Gvf_msg *msg)
{
  msg->length = get_1_byte(pdu);  //attribute_length
  msg->event  = get_1_byte(pdu);  //atttribute_event

  if(msg->event!=0) {             //leaveall msg don't have value field
     msg->key1=get_2_bytes(pdu);  //attribute_value
  }

  switch(msg->event)
  {
   case 0: //LeaveAll
     msg->event=Gid_rcv_leaveall;
     break;
   case 1: //Joinempty
     msg->event=Gid_rcv_joinempty;
     break;
   case 2: //JoinIn
     msg->event=Gid_rcv_joinin;
     break;
   case 3: //LeaveEmpty
     msg->event=Gid_rcv_leaveempty;
     break;
   case 4: //LeaveIn
     msg->event=Gid_rcv_leavein;
     break;
   case 5: //Empty
     msg->event=Gid_rcv_empty;
     break;
   default:
     msg->event=Gid_null;
     break;
  }
  return(True);
}
#endif

#ifdef __GVRP__
//fill in attribute N (length & event & attribute) in GARP PDU based on input parameter - msg
Tbool gvrp_wrmsg(Pdu **pdu, Gvf_msg *msg)
{
  Tuint8 leaveall_len=2;//The attribute len of LeaveAll msg
  Tuint8 others_len=4;  //The attribute len of Join/Leave/Empty msg

  switch(msg->event)
  {
   case Gid_tx_leaveempty:
     msg->event=3;
     break;
   case Gid_tx_leavein:
     msg->event=4;
     break;
   case Gid_tx_empty:
     msg->event=5;
     break;
   case Gid_tx_joinempty:
     msg->event=1;
     break;
   case Gid_tx_joinin:
     msg->event=2;
     break;
   case Gid_tx_leaveall:
     msg->event=0;
     break;
   case Gid_tx_leaveall_range:
     msg->event=0;
     break;
   default:
      return(False);

  }
  
  msg->key1=htons(msg->key1);

  if(msg->event==0) { //leaveall
     put_unaligned(leaveall_len,(Tuint8 *)skb_put(*pdu,1));
     put_unaligned(msg->event,(Tuint8 *)skb_put(*pdu,1));
  }
  else { //other messages-Join/Leave
     put_unaligned(others_len,(Tuint8 *)skb_put(*pdu,1));
     put_unaligned(msg->event,(Tuint8 *)skb_put(*pdu,1));
     put_unaligned(msg->key1,(Tuint16 *)skb_put(*pdu,2));
  }

  return(True);
}
#endif
                           
#ifdef __GMRP__
//fill in garp common header including Dest_mac, source_mac, len, dsap, ssap, control flag, protocol_id
Tbool gmrp_wrmsg_init(Pdu **pdu)
{
  Tuint8  dsap=0x42, ssap=0x42, cf=0x03; //control filed
  Tuint16 len=0x00, protocol_id=htons(0x0001);
 
  //gmrp dst_mac= 01:80:c2:00:00:20
  put_unaligned(0x8001,(Tuint16 *)skb_put(*pdu,2));   
  put_unaligned(0x200000c2,(Tuint32 *)skb_put(*pdu,4));   
 
  //src mac
  memcpy(skb_put(*pdu,MAC_ADDR_LEN),ga_my_mac,MAC_ADDR_LEN);
  
  put_unaligned(len,(Tuint16 *)skb_put(*pdu,2));
  put_unaligned(dsap,(Tuint8 *)skb_put(*pdu,1)); 
  put_unaligned(ssap,(Tuint8 *)skb_put(*pdu,1)); 
  put_unaligned(cf,(Tuint8 *)skb_put(*pdu,1)); 
  
  put_unaligned(protocol_id,(Tuint16 *)skb_put(*pdu,2)); 

  return(True);

}
#endif

#ifdef __GMRP__
// extract length/event/value from attribute N in GMRP PDU
Tbool gmrp_parsing_attribute(Tuint8 **pdu, Gmf_msg *msg)
{
  msg->length=get_1_byte(pdu); // attribute_length
  msg->event=get_1_byte(pdu);  // atttribute_event
  
  switch(msg->event)
  {
   case 0: //LeaveAll
     msg->event=Gid_rcv_leaveall;  
     break;
   case 1: //Joinempty
     msg->event=Gid_rcv_joinempty;
     break;
   case 2: //JoinIn
     msg->event=Gid_rcv_joinin;
     break;
   case 3: //LeaveEmpty
     msg->event=Gid_rcv_leaveempty;
     break;
   case 4: //LeaveIn
     msg->event=Gid_rcv_leavein;
     break;
   case 5: //Empty
     msg->event=Gid_rcv_empty;
     break;
   default:
     msg->event=Gid_null;   
     break;
  }

  //Attribute Type=0x02: Group Service Requirement Information
  if( (msg->attribute==Legacy_attribute) && (msg->event!=Gid_rcv_leaveall) ) { 
    msg->legacy_control=get_1_byte(pdu);//get attribute value
   
    if(msg->legacy_control > 1) { //attribute value -> 0: Forward_all, 1:Forward_unregistered
      return (False);
    }
  }//Attriubte Type=0x01: Group address registration 
  else if(msg->event!=Gid_rcv_leaveall ) { //not leaveall msg 
    memcpy(msg->key1, *pdu, MAC_ADDR_LEN);//get attribute value: mac address
    K_MacReverseMac(msg->key1); //change to host order
    *pdu += MAC_ADDR_LEN;
    
    //multicast mac= 01:00:5e....
    //GMRP payload only carry multicast mac addr
    if( (msg->key1[5] != 0x01) || (msg->key1[4]!=0x00) || (msg->key1[3]!=0x5e) ){
         return (False);
    } 
  }
 
  return(True);
}
#endif



#ifdef __GMRP__
//fill in attribute N in GARP PDU based on msg info
Tbool gmrp_wrmsg(Pdu **pdu, Gmf_msg *msg)
{
 Tuint8 leaveall_len=2, others_len=8, service_require_len=3;
  
 switch(msg->event)
  {
   case Gid_tx_leaveempty: 
     msg->event=3;  
     break;
   case Gid_tx_leavein:
     msg->event=4;
     break;
   case Gid_tx_empty: 
     msg->event=5;
     break;
   case Gid_tx_joinempty:
     msg->event=1;
     break;
   case Gid_tx_joinin: 
     msg->event=2;
     break;
   case Gid_tx_leaveall:
     msg->event=0;
     break;
   case Gid_tx_leaveall_range: 
     msg->event=0;
     break;
   default:
      return(False);   
      
  }

  if(msg->event==0) {//leaveall
    put_unaligned(Legacy_attribute, (Tuint8 *)skb_put(*pdu,1)); 
    put_unaligned(leaveall_len, (Tuint8 *)skb_put(*pdu,1)); 
    put_unaligned(msg->event, (Tuint8 *)skb_put(*pdu,1)); 
    put_unaligned(0x00, (Tuint8 *)skb_put(*pdu,1)); //end of mark
    return (True);
  }

  // Legacy_attribute only have 1 byte attriubte value
  if(msg->attribute==Legacy_attribute) { 
    put_unaligned(Legacy_attribute, (Tuint8 *)skb_put(*pdu,1));    //attribute type 
    put_unaligned(service_require_len, (Tuint8 *)skb_put(*pdu,1)); //len 
    put_unaligned(msg->event, (Tuint8 *)skb_put(*pdu,1));          //event
    put_unaligned(msg->legacy_control, (Tuint8 *)skb_put(*pdu,1)); //value (0 or 1)
    put_unaligned( 0x00, (Tuint8 *)skb_put(*pdu,1));               //end of mark
    return (True);
  }
  else { //other messages
     
    //Group attribute type (0x01)
    put_unaligned(Multicast_attribute ,(Tuint8 *)skb_put(*pdu,1)); 
    put_unaligned(others_len,(Tuint8 *)skb_put(*pdu,1)); 
    put_unaligned(msg->event,(Tuint8 *)skb_put(*pdu,1)); 
    K_MacReverseMac(msg->key1); //change to network order
    memcpy(skb_put(*pdu,MAC_ADDR_LEN),msg->key1,MAC_ADDR_LEN);
    put_unaligned( 0x00  ,(Tuint8 *)skb_put(*pdu,1)); //end of mark
  }

  return(True);
}
#endif
