/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : garp_netfilter.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : communicate with user land program(CLI/Web)
// ********************************************

#include "krntype.h"
#include "krndef.h"

#ifndef GARP_NETFILTER_H
#define GARP_NETFILTER_H

#define GARP_BASE_CTL		            (64+1024+64+64+100)

#define SET_GARP_JOIN_TIMER                 (GARP_BASE_CTL+1)
#define SET_GARP_LEAVE_TIMER                (GARP_BASE_CTL+2)
#define SET_GARP_LEAVEALL_TIMER             (GARP_BASE_CTL+3)
#define GARP_SET_MAX	     	            (GARP_BASE_CTL+10)

#define GET_GARP_JOIN_TIMER       	    (GARP_BASE_CTL+1)
#define GET_GARP_LEAVE_TIMER      	    (GARP_BASE_CTL+2)
#define GET_GARP_LEAVEALL_TIMER    	    (GARP_BASE_CTL+3)
#define GARP_GET_MAX	       	            (GARP_BASE_CTL+10)

#define GID_MACHINE_MAX 		    (31)
#define END_OF_GIP    			    (99)

/******************************************************************************
* DEBUG : Debug Level
*******************************************************************************/
#define GVRP_DEBUG_SYS    0x00000001
#define GVRP_DEBUG_ERR    0x00000010
#define GVRP_DEBUG_PDU    0x00000100
#define GVRP_DEBUG_DB     0x00001000
#define GVRP_DEBUG_GEN    0x00010000
#define GVRP_DEBUG_GVRP   0x00100000
#define GVRP_DEBUG_VLAN   0x01000000

#define GMRP_DEBUG_SYS    0x00000001
#define GMRP_DEBUG_ERR    0x00000010
#define GMRP_DEBUG_PDU    0x00000100
#define GMRP_DEBUG_DB     0x00001000
#define GMRP_DEBUG_GEN    0x00010000


/******************************************************************************
* SYS : SYSTEM CONVENTIONS
*******************************************************************************/
typedef Tuint8 Mac_addr[6];

typedef struct /* Gid_machine */
{
/* The GID state of each attribute on each port is held in a GID machine
* which comprises the Applicant and Registrar states for the port,
* including control modifiers for the states.
*
* The GID machine and its internal representation of GID states is not
* accessed directly: this struct is defined here to allow the GID
* Control Block (which is accessed externally) to be defined below.
*/
Tuint32 applicant : 5; /* Applicant_states */
Tuint32 registrar : 5; /* Registrar_states */
} Gid_machine;

typedef struct {
	Tuint8		ucTrkId;
	TstLPortMask	stPortMask;
} TstGarpTrk;

/******************************************************************************
* Statistics : GARP Statistics
*******************************************************************************/
typedef struct {
Tuint32 JoinEmpty_rx;
Tuint32 JoinIn_rx;
Tuint32 Empty_rx;
Tuint32 LeaveIn_rx;
Tuint32 LeaveEmpty_rx;
Tuint32 LeaveAll_rx;
Tuint32 JoinEmpty_tx;
Tuint32 JoinIn_tx;
Tuint32 Empty_tx;
Tuint32 LeaveIn_tx;
Tuint32 LeaveEmpty_tx;
Tuint32 LeaveAll_tx;
}garp_statistics;



/******************************************************************************
* GIDTT : GARP INFORMATION DISTRIBUTION PROTOCOL : TRANSITION TABLES
*******************************************************************************/

enum Applicant_states
{
 Va, /* Very anxious, active */
 Aa, /* Anxious, active */
 Qa, /* Quiet, active */
 La, /* Leaving, active */
 Vp, /* Very anxious, passive */
 Ap, /* Anxious, passive */
 Qp, /* Quiet, passive */
 Vo, /* Very anxious observer */
 Ao, /* Anxious observer */
 Qo, /* Quiet observer */
 Lo, /* Leaving observer */
 Von, /* Very anxious observer, non-participant */
 Aon, /* Anxious observer, non-participant */
 Qon /* Quiet_observer, non-participant */
};

/* In, Leave, Empty, but with Leave states implementing
*  a countdown for the leave timer. 
*/
enum Registrar_states
{ 

 Inn, // In, registration normal */
 Lv,L3,L2,L1,
 Mt,

 Inr, /* In, registration fixed */
 Lvr,L3r,L2r,L1r,
 Mtr,

 Inf, /* In, registration forbidden */
 Lvf,L3f,L2f,L1f,
 Mtf
};



#endif

