/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************************
// Name   : garp_netfilter.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : Communicate with CLI/Web using netfilter method
// *********************************************************

#include "common.h"
#include "garp_common.h"

/* Unit: msec */
extern Tuint32 Gid_default_join_time;     
extern Tuint32 Gid_default_leave_time;   
extern Tuint32 Gid_default_leaveall_time;

/* This function is called whenever a process tries to do setsockopt */
int do_garp_set_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
{
 Tuint32 data;
 
 switch (cmd)
 {
  // set GARP timer      
  case SET_GARP_JOIN_TIMER:
       copy_from_user(&data,user,len); //get timer info
       Gid_default_join_time = data > 0 ? data : 20; 
       break;

  case SET_GARP_LEAVE_TIMER:
       copy_from_user(&data,user,len); //get timer info
       Gid_default_leave_time = data > 0 ? data : 60;
       break;

  case SET_GARP_LEAVEALL_TIMER:
       copy_from_user(&data,user,len); //get timer info
       Gid_default_leaveall_time = data > 0 ? data : 1000; 
       break;
  }

  return 0;
}


/* This function is called whenever a process tries to do getsockopt */
int do_garp_get_ctl(struct sock *sk, int cmd, void *user, int *len)
{

 switch(cmd)
 {
  // get GARP timer
  case GET_GARP_JOIN_TIMER:
       copy_to_user(user,&Gid_default_join_time,sizeof(Gid_default_join_time));
       break;

  case GET_GARP_LEAVE_TIMER:
       copy_to_user(user,&Gid_default_leave_time,sizeof(Gid_default_leave_time));
       break;

  case GET_GARP_LEAVEALL_TIMER:
       copy_to_user(user,&Gid_default_leaveall_time,sizeof(Gid_default_leaveall_time));
       break;
 }

 return 0;
}

struct nf_sockopt_ops garp_sockopts = {
   { NULL, NULL }, PF_INET,
   GARP_BASE_CTL, GARP_SET_MAX+1, do_garp_set_ctl, NULL,
   GARP_BASE_CTL, GARP_GET_MAX+1, do_garp_get_ctl, NULL
};


