/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : garp_.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : 
// ********************************************

#ifndef GARP_H__
#define GARP_H__

/******************************************************************************
* GARP : GENERIC ATTRIBUTE REGISTRATION PROTOCOL : COMMON APPLICATION ELEMENTS
*******************************************************************************/

/*
* Each GARP, i.e., each instance of an application that uses the GARP
* protocol, is represented as a struct or control block with common initial
* fields. These comprise pointers to application-specific functions that
* are by the GID and GIP components to signal protocol events to the
* application, and other controls common to all applications. The pointers
* include a pointer to the instances of GID (one per port) for the application,
* and to GIP (one per application). The signaling functions include the
* addition and removal of ports, which the application should use to
* initialize port attributes with any management state required.
*/

// Each GARP struct is an instance of GVRP/GMRP ...etc
// i.e., Each GARP Struct means GARP Application

// GID and GIP components using application-specific functions to signal 
// protocol events to the application.

// GARP Participant = GARP Application + GID
// One GID has many attribute machines


typedef struct /* Garp */
{ 
 Tuint32 process_id;
 void *gid; //pointer to the instances of GID (one per port)
 Tuint32 *gip; //pointer to GIP (one per application)
 Tuint32 max_gid_index;
 Tuint32 last_gid_used;
 void(*join_indication_fn)( void *, void *my_port, Tuint32 joining_gid_index);
 void(*leave_indication_fn)(void *, void *gid,Tuint32 leaving_gid_index);
 void(*join_propagated_fn)( void *, void *gid,Tuint32 joining_gid_index);
 void(*leave_propagated_fn)(void *, void *gid,Tuint32 leaving_gid_index);
 void(*transmit_fn)( void *, void *gid);
 Tuint32 (*receive_fn)( void *, void *gid, void *pdu);
 void (*added_port_fn)( void *, Tuint32 port_no);
 void (*removed_port_fn)( void *, Tuint32 port_no);
} Garp;

#endif /* garp_h__ */
