/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : garp.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : initiate gvrp/gmrp module
// ********************************************

#include "common.h"
#include "garp_common.h"

#ifdef __GVRP__
#include "gvrp_common.h"
Gvr 	 *my_gvr;
#endif

#ifdef __GMRP__
#include "gmrp_common.h"
Gmr 	 *my_gmr;
#endif

Tuint8	      ga_my_mac[MAC_ADDR_LEN];
extern struct nf_sockopt_ops garp_sockopts, gvrp_sockopts, gmrp_sockopts;

// Register GVRP/GMRP rx_handler & netfilter socket option 
static int __init garp_init(void)
{
#ifdef __GMRP__
  Tint8 gmrp_mac[MAC_ADDR_LEN]={0x01,0x80,0xc2,0x00,0x00,0x20};  
#endif
#ifdef __GVRP__
  Tint8 gvrp_mac[MAC_ADDR_LEN]={0x01,0x80,0xc2,0x00,0x00,0x21};
#endif
  Tint8 mask[MAC_ADDR_LEN]={0xff,0xff,0xff,0xff,0xff,0xff};

  // read switch's mac addr from register and change to network order
  K_SysGetMac(ga_my_mac);

  if(nf_register_sockopt(&garp_sockopts)) {
    printk(" GARP: nf_register_sockopt...Fail \n");
    return (False);
  }

#ifdef __GVRP__
  if(nf_register_sockopt(&gvrp_sockopts)) {
    printk(" GVRP: nf_register_sockopt...Fail \n");
    return (False);
  }
  //Create one GVRP Application per box 
  if( gvr_create_gvr( GVRP_PROCESS_ID ,(void **)&my_gvr)!=True) {
      printk("GVRP: Creating GVRP Application Fail!\n");
      return (False);
  }
  // Register GVRP RX Handler  
  ccl_mx_register(gvrp_mac,mask,gvrp_pdu_rcv);
#endif


#ifdef __GMRP__
  if(nf_register_sockopt(&gmrp_sockopts)) {
    printk(" GMRP: nf_register_sockopt...Fail \n");
    return (False);
  }
  //Create one GMRP Application per box
  //We just support one vlan mode which means all multicast group must belong to default vlan 
  if( gmr_create_gmr( GMRP_PROCESS_ID, 1 /*default vid*/  , (void **)&my_gmr)!=True) {
      printk("GMRP: Creating GMRP Application Fail!\n");
      return (False);
  }
  // Register GMRP RX Handler 
  ccl_mx_register(gmrp_mac,mask,gmrp_pdu_rcv);
#endif

  return 0;

}

static void __exit garp_exit(void)
{
#ifdef __GVRP__
 Tint8 gvrp_mac[MAC_ADDR_LEN]={0x01,0x80,0xc2,0x00,0x00,0x21};
#endif
#ifdef __GMRP__
 Tint8 gmrp_mac[MAC_ADDR_LEN]={0x01,0x80,0xc2,0x00,0x00,0x20};  
#endif
 Tint8 mask[MAC_ADDR_LEN]={0xff,0xff,0xff,0xff,0xff,0xff};


 nf_unregister_sockopt(&garp_sockopts);

#ifdef __GVRP__
 printk("Leaving GVRP Protocol... \n");
 nf_unregister_sockopt(&gvrp_sockopts);
 ccl_mx_unregister(gvrp_mac,mask);
#endif

#ifdef __GMRP__
 printk("Leaving GMRP Protocol... \n");
 nf_unregister_sockopt(&gmrp_sockopts);
 ccl_mx_unregister(gmrp_mac,mask);
#endif
}

module_init(garp_init);
module_exit(garp_exit);
