#ifndef _CCLMX_NETFILTER_H
#define _CCLMX_NETFILTER_H

#include <linux/netfilter.h>

#include "krntype.h"

int do_cclmx_set_ctl (struct sock *sk, int cmd, void *user, unsigned int len);
int do_cclmx_get_ctl (struct sock *sk, int cmd, void *user, int *len);

typedef struct TRUNK_MEMBER {
	Tuint8		ucTrkId;
	TstPPortMask	stPhyMask;
} TstTrkMem;


#define CCLMX_BASE_CTL		(64 + 1024 + 64 + 64 + 300)


// vvv for testing vvv
#define CCLMX_GET_TRK		(CCLMX_BASE_CTL + 1)
#define CCLMX_GET_L2P		(CCLMX_BASE_CTL + 2)
#define CCLMX_GET_P2L		(CCLMX_BASE_CTL + 3)
#define CCLMX_GET_SPEED		(CCLMX_BASE_CTL + 4)
// ^^^ for testing ^^^
#define CCLMX_GET_MAX		(CCLMX_BASE_CTL + 10)


#define CCLMX_SET_ADD_TRK	(CCLMX_BASE_CTL + 1)
#define CCLMX_SET_DEL_TRK	(CCLMX_BASE_CTL + 2)
#define CCLMX_SET_MAX		(CCLMX_BASE_CTL + 10)

#endif
