#ifndef CCL_MX_H
#define CCL_MX_H

#include <linux/skbuff.h> /* for struct sk_buff */

#include "krntype.h"
#include "krndef.h"

enum 
{
	CCL_MX_ACCEPT=0,	//done
	CCL_MX_CONTINUE,	//continue to do this packet
	CCL_MX_DROP,		//drop the packet
	CCL_MX_NONE		//send to upper layer
};

enum				/* link of logical port */
{
	CCLMX_PORT_LINKDOWN=0,
	CCLMX_PORT_LINKUP,
	CCLMX_PORT_INTRUNK	/* is physical port and in some trunk */
};

enum
{				/* state of logical port */
	CCLMX_PORT_OFF=0,
	CCLMX_PORT_ON
};

typedef enum
{
	CCLMX_PORT_SPEED_0,
	CCLMX_PORT_SPEED_10,
	CCLMX_PORT_SPEED_20,
	CCLMX_PORT_SPEED_30,
	CCLMX_PORT_SPEED_40,
	CCLMX_PORT_SPEED_100,
	CCLMX_PORT_SPEED_200,
	CCLMX_PORT_SPEED_300,
	CCLMX_PORT_SPEED_400,
	CCLMX_PORT_SPEED_1000,
	CCLMX_PORT_SPEED_2000
} CCLMX_PORT_SPEED;

#define CCLMX_PORT_SPEED_NEXT(myspeed) \
	do { \
		switch (myspeed) { \
		case CCLMX_PORT_SPEED_0:    myspeed = CCLMX_PORT_SPEED_0;    break; \
		case CCLMX_PORT_SPEED_10:   myspeed = CCLMX_PORT_SPEED_20;   break; \
		case CCLMX_PORT_SPEED_20:   myspeed = CCLMX_PORT_SPEED_30;   break; \
		case CCLMX_PORT_SPEED_30:   myspeed = CCLMX_PORT_SPEED_40;   break; \
		case CCLMX_PORT_SPEED_40:   myspeed = CCLMX_PORT_SPEED_40;   break; \
		case CCLMX_PORT_SPEED_100:  myspeed = CCLMX_PORT_SPEED_200;  break; \
		case CCLMX_PORT_SPEED_200:  myspeed = CCLMX_PORT_SPEED_300;  break; \
		case CCLMX_PORT_SPEED_300:  myspeed = CCLMX_PORT_SPEED_400;  break; \
		case CCLMX_PORT_SPEED_400:  myspeed = CCLMX_PORT_SPEED_400;  break; \
		case CCLMX_PORT_SPEED_1000: myspeed = CCLMX_PORT_SPEED_2000; break; \
		case CCLMX_PORT_SPEED_2000: myspeed = CCLMX_PORT_SPEED_2000; break; \
		} \
	} while (0)

typedef enum
{
	CCLMX_PORT_DUPLEX_HALF,
	CCLMX_PORT_DUPLEX_FULL,
	CCLMX_PORT_DUPLEX_UNKNOWN
} CCLMX_PORT_DUPLEX;


int	ccl_mx_register (char *mac, char *mask, int(*callback)(struct sk_buff *skb));
int	ccl_mx_unregister (char *mac, char *mask);

int	cclmx_InsTrk (Tuint8 ucTrkId, TstPPortMask stPMask);
int	cclmx_DelTrk (Tuint8 ucTrkId);
int	cclmx_AddPortToTrk (Tuint8 ucTrkId, Tuint8 ucPortId);
int	cclmx_DelPortFromTrk (Tuint8 ucPortId);
Tuint8	cclmx_PortInTrunk (Tuint8 ucPortId);

inline Tuint8	cclmx_MapPortId   (Tuint8  ucPhyId);
inline Tuint8	cclmx_DemapPortId (Tuint8  ucPhyId);

Tuint8	cclmx_PId2LId (Tuint8 ucPhyId);
Tuint8	cclmx_LId2PId (Tuint8 ucLogicId);
int	cclmx_LId2PMask (TstPPortMask * pstPMask, Tuint8 ucLogicId);
int	cclmx_PMask2LMask (TstLPortMask * pstLMask, TstPPortMask * pstPMask);
int	cclmx_LMask2PMask (TstPPortMask * pstPMask, TstLPortMask * pstLMask);

int	cclmx_GetActPortMask (TstPPortMask * pstPMask);

int	cclmx_PortGetLink (Tuint8 ucLogicId);
int	cclmx_PortGetEbl (Tuint8 ucLogicId);
Tuint8	cclmx_PortGetStpState (Tuint8 ucLogicId);
void	cclmx_PortSetStpState (Tuint8 ucLogicId, Tuint8 ucState);
int	cclmx_PortGetSpeedDuplex (Tuint8 ucPortId, Tuint8 * pucSpeed, Tuint8 * pucDuplex);
int	cclmx_RxPkt (struct sk_buff * skb);
int	cclmx_TxPkt (struct sk_buff * skb);

#endif
