#ifndef CCL_H
#define CCL_H

#include "krndef.h"

/*
 * CCL: module support
 */
#define CCL_SLOT_NUM 1
#define CCL_SLOT_PORT_NUM {26}
#define CCL_PORT_MAP \
	{ \
	 {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26}\
	}


extern unsigned int ccl_port_map[CCL_SLOT_NUM][MAX_PORT];
extern unsigned int ccl_slot_port_num[CCL_SLOT_NUM];


/* Map internel port to front panel */
static inline int CCL_PORT(unsigned int slot, unsigned int port) 
 {
  if(slot>0 && slot<=CCL_SLOT_NUM && port>0 && port<=ccl_slot_port_num[slot]) 
   return (ccl_port_map[(slot-1)][(port-1)]); 
  else
   return -1; 
 }


struct ccl_p
 {
  //unsigned long   dwIgmpCpuMask;         // Igmp CpuPortMask
  unsigned short  wSize;                 // Packet size
  unsigned short  wVid;                  // VLAN tag
  unsigned char   byPriority;
  unsigned char   bySrcPortId;           // Source port id
  unsigned char   byFwdReason;
  unsigned char   bIfTagged;
  unsigned long   dwDstPortMsk;          // Destination port mask
  unsigned long   dwTagPortMsk;          // Tagged port mask, no tag for each port
 };

struct ccl_lp
 {
  //unsigned long   dwIgmpCpuMask;         // Igmp CpuPortMask
  unsigned short  wSize;                 // Packet size
  unsigned short  wVid;                  // VLAN tag
  unsigned char   byPriority;
  unsigned char   bySrcPortId;           // Source port id
  unsigned char   byFwdReason;
  unsigned char   bIfTagged;
  TstLPortMask    dwDstPortMsk;          // Destination port mask
  TstLPortMask    dwTagPortMsk;          // Tagged port mask, no tag for each port
 };

#define CCL_P(skb) (((struct ccl_p *)(skb)->cb))
#define CCL_LP(skb) (((struct ccl_lp *)(skb)->cb))

#endif
