/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

#ifndef __CCLDRIVER_NETFILTER_H__
#define __CCLDRIVER_NETFILTER_H__

#include "krndef.h"
#include "krntype.h"
#include "krnmac.h"

#define CCLDRIVER_BASE_CTL		(64+1024+64+64+1800) /* 1800-1999 */

#define CCLDRIVER_FWD_SET_MAC_AGE_EBL			(CCLDRIVER_BASE_CTL+1)
#define CCLDRIVER_FWD_SET_MAC_AGE_TIME			(CCLDRIVER_BASE_CTL+2)
#define CCLDRIVER_FWD_SET_BCST_STRM_FLTR		(CCLDRIVER_BASE_CTL+3)
#define CCLDRIVER_FWD_SET_BCST_STRM_FLTR_PORT_EBL	(CCLDRIVER_BASE_CTL+4)
#define CCLDRIVER_FWD_SET_TRNSMT_DLY_BND		(CCLDRIVER_BASE_CTL+5)
#define CCLDRIVER_FWD_SET_QOS				(CCLDRIVER_BASE_CTL+6)
#define CCLDRIVER_FWD_SET_HIGH_QUE_PTN			(CCLDRIVER_BASE_CTL+7)
#define CCLDRIVER_FWD_SET_LOW_QUE_DLY_BND		(CCLDRIVER_BASE_CTL+8)
#define CCLDRIVER_FWD_SET_LOW_QUE_DLY_BND_TIME		(CCLDRIVER_BASE_CTL+9)
#define CCLDRIVER_FWD_SET_PORT_PRIO			(CCLDRIVER_BASE_CTL+10)
#define CCLDRIVER_FWD_SET_CLLSN_RTRY			(CCLDRIVER_BASE_CTL+11)
//#define CCLDRIVER_FWD_SET_HASH_ALG			(CCLDRIVER_BASE_CTL+12)
#define CCLDRIVER_FWD_SET_IFG_CPSN			(CCLDRIVER_BASE_CTL+13)
#define CCLDRIVER_FWD_SET_PORT_MIRROR			(CCLDRIVER_BASE_CTL+14)
#define CCLDRIVER_FWD_SET_MAX_FRAME_SIZE		(CCLDRIVER_BASE_CTL+15)
#define CCLDRIVER_FWD_INS_RULE				(CCLDRIVER_BASE_CTL+16)
#define CCLDRIVER_FWD_DEL_RULE				(CCLDRIVER_BASE_CTL+17)
#define CCLDRIVER_PORT_SET_EBL				(CCLDRIVER_BASE_CTL+21)
#define CCLDRIVER_PORT_SET_NEGO				(CCLDRIVER_BASE_CTL+22)
#define CCLDRIVER_PORT_SET_SPEED_DUPLEX			(CCLDRIVER_BASE_CTL+23)
#define CCLDRIVER_PORT_SET_FLOW_CTRL			(CCLDRIVER_BASE_CTL+24)
#define CCLDRIVER_PORT_SET_SECURITY			(CCLDRIVER_BASE_CTL+25)
#define CCLDRIVER_PORT_SET_RATE_INGRS			(CCLDRIVER_BASE_CTL+26)
#define CCLDRIVER_PORT_SET_RATE_EGRS			(CCLDRIVER_BASE_CTL+27)
#define CCLDRIVER_MAC_CLR_TBL				(CCLDRIVER_BASE_CTL+30)
#define CCLDRIVER_MAC_INS_ENTRY				(CCLDRIVER_BASE_CTL+31)
#define CCLDRIVER_MAC_DEL_ENTRY				(CCLDRIVER_BASE_CTL+32)
#define CCLDRIVER_IP_MCST_CLR_TBL			(CCLDRIVER_BASE_CTL+35)
#define CCLDRIVER_IP_MCST_INS_ENTRY			(CCLDRIVER_BASE_CTL+36)
#define CCLDRIVER_IP_MCST_DEL_ENTRY			(CCLDRIVER_BASE_CTL+37)
//#define CCLDRIVER_TRK_SET_MAC_HASH			(CCLDRIVER_BASE_CTL+40)
#define CCLDRIVER_TRK_SET_TCKT_GEN_ALG			(CCLDRIVER_BASE_CTL+41)
#define CCLDRIVER_TRK_INS_TRK				(CCLDRIVER_BASE_CTL+42)
#define CCLDRIVER_TRK_DEL_TRK				(CCLDRIVER_BASE_CTL+43)
#define CCLDRIVER_TRK_SET_PORT_AGGR_ID			(CCLDRIVER_BASE_CTL+44)
#define CCLDRIVER_TRK_SET_PORT_STATUS			(CCLDRIVER_BASE_CTL+45)
#define CCLDRIVER_TRK_SET_PORT_ADM_CRI			(CCLDRIVER_BASE_CTL+46)
#define CCLDRIVER_SYS_SET_MAC				(CCLDRIVER_BASE_CTL+47)
#define CCLDRIVER_SYS_REBOOT				(CCLDRIVER_BASE_CTL+48)
#define CCLDRIVER_VLAN_SET_PROTOCOL_VLAN_EBL		(CCLDRIVER_BASE_CTL+50)
#define CCLDRIVER_VLAN_SET_MODE				(CCLDRIVER_BASE_CTL+51)
#define CCLDRIVER_VLAN_SET_PVID				(CCLDRIVER_BASE_CTL+52)
#define CCLDRIVER_VLAN_SET_INGRS_FLTR_CFG		(CCLDRIVER_BASE_CTL+53)
#define CCLDRIVER_VLAN_CLR_TBL				(CCLDRIVER_BASE_CTL+54)
#define CCLDRIVER_VLAN_INS_ENTRY			(CCLDRIVER_BASE_CTL+55)
#define CCLDRIVER_VLAN_DEL_ENTRY			(CCLDRIVER_BASE_CTL+56)
#define CCLDRIVER_VLAN_INS_PROTOCOL_VLAN_ENTRY		(CCLDRIVER_BASE_CTL+57)
#define CCLDRIVER_VLAN_DEL_PROTOCOL_VLAN_ENTRY		(CCLDRIVER_BASE_CTL+58)
#define CCLDRIVER_VLAN_CLR_PORT_BASED			(CCLDRIVER_BASE_CTL+59)
#define CCLDRIVER_VLAN_ADD_PORT_BASED			(CCLDRIVER_BASE_CTL+60)
#define CCLDRIVER_VLAN_PER_VLAN_FLOODING_PORTMASK_EBL	(CCLDRIVER_BASE_CTL+61)
#define CCLDRIVER_VLAN_STACKING_SET_EBL			(CCLDRIVER_BASE_CTL+62)
#define CCLDRIVER_VLAN_STACKING_SET_PORT		(CCLDRIVER_BASE_CTL+63)
#define CCLDRIVER_VLAN_STACKING_INS_ENTRY		(CCLDRIVER_BASE_CTL+64)
#define CCLDRIVER_VLAN_STACKING_DEL_ENTRY		(CCLDRIVER_BASE_CTL+65)
#define CCLDRIVER_MIB_CLR_CNTR				(CCLDRIVER_BASE_CTL+70)
#define CCLDRIVER_GMRP_SET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+150)
#define CCLDRIVER_GVRP_SET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+160)
#define CCLDRIVER_IGMP_SET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+170)
#define CCLDRIVER_LACP_SET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+180)
#define CCLDRIVER_STP_SET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+190)
#define CCLDRIVER_STP_SET_PORT_STATE			(CCLDRIVER_BASE_CTL+191)
#define CCLDRIVER_SET_MAX				(CCLDRIVER_BASE_CTL+199)

#define CCLDRIVER_FWD_GET_MAC_AGE_EBL			(CCLDRIVER_BASE_CTL+1)
#define CCLDRIVER_FWD_GET_MAC_AGE_TIME			(CCLDRIVER_BASE_CTL+2)
#define CCLDRIVER_FWD_GET_BCST_STRM_FLTR		(CCLDRIVER_BASE_CTL+3)
#define CCLDRIVER_FWD_GET_BCST_STRM_FLTR_PORT_EBL	(CCLDRIVER_BASE_CTL+4)
#define CCLDRIVER_FWD_GET_TRNSMT_DLY_BND		(CCLDRIVER_BASE_CTL+5)
#define CCLDRIVER_FWD_GET_QOS				(CCLDRIVER_BASE_CTL+6)
#define CCLDRIVER_FWD_GET_HIGH_QUE_PTN			(CCLDRIVER_BASE_CTL+7)
#define CCLDRIVER_FWD_GET_LOW_QUE_DLY_BND		(CCLDRIVER_BASE_CTL+8)
#define CCLDRIVER_FWD_GET_LOW_QUE_DLY_BND_TIME		(CCLDRIVER_BASE_CTL+9)
#define CCLDRIVER_FWD_GET_PORT_PRIO			(CCLDRIVER_BASE_CTL+10)
#define CCLDRIVER_FWD_GET_CLLSN_RTRY			(CCLDRIVER_BASE_CTL+11)
//#define CCLDRIVER_FWD_GET_HASH_ALG			(CCLDRIVER_BASE_CTL+12)
#define CCLDRIVER_FWD_GET_IFG_CPSN			(CCLDRIVER_BASE_CTL+13)
#define CCLDRIVER_FWD_GET_PORT_MIRROR			(CCLDRIVER_BASE_CTL+14)
#define CCLDRIVER_FWD_GET_MAX_FRAME_SIZE		(CCLDRIVER_BASE_CTL+15)
#define CCLDRIVER_FWD_GET_RULE_SIZE			(CCLDRIVER_BASE_CTL+16)
#define CCLDRIVER_FWD_GET_RULE_ENTRY			(CCLDRIVER_BASE_CTL+17)
#define CCLDRIVER_PORT_GET_LINK				(CCLDRIVER_BASE_CTL+20)
#define CCLDRIVER_PORT_GET_EBL				(CCLDRIVER_BASE_CTL+21)
#define CCLDRIVER_PORT_GET_NEGO				(CCLDRIVER_BASE_CTL+22)
#define CCLDRIVER_PORT_GET_SPEED_DUPLEX			(CCLDRIVER_BASE_CTL+23)
#define CCLDRIVER_PORT_GET_FLOW_CTRL			(CCLDRIVER_BASE_CTL+24)
#define CCLDRIVER_PORT_GET_SECURITY			(CCLDRIVER_BASE_CTL+25)
#define CCLDRIVER_PORT_GET_RATE_INGRS			(CCLDRIVER_BASE_CTL+26)
#define CCLDRIVER_PORT_GET_RATE_EGRS			(CCLDRIVER_BASE_CTL+27)
#define CCLDRIVER_MAC_GET_ENTRY				(CCLDRIVER_BASE_CTL+30)
#define CCLDRIVER_MAC_GET_TBL_SIZE			(CCLDRIVER_BASE_CTL+31)
#define CCLDRIVER_MAC_GET_TBL_ENTRY			(CCLDRIVER_BASE_CTL+32)
#define CCLDRIVER_IP_MCST_GET_ENTRY			(CCLDRIVER_BASE_CTL+35)
#define CCLDRIVER_IP_MCST_GET_TBL_SIZE			(CCLDRIVER_BASE_CTL+36)
#define CCLDRIVER_IP_MCST_GET_TBL_ENTRY			(CCLDRIVER_BASE_CTL+37)
//#define CCLDRIVER_TRK_GET_MAC_HASH			(CCLDRIVER_BASE_CTL+40)
#define CCLDRIVER_TRK_GET_TCKT_GEN_ALG			(CCLDRIVER_BASE_CTL+41)
#define CCLDRIVER_TRK_GET_PORT_AGGR_ID			(CCLDRIVER_BASE_CTL+42)
#define CCLDRIVER_TRK_GET_PORT_STATUS			(CCLDRIVER_BASE_CTL+43)
#define CCLDRIVER_TRK_GET_PORT_ADM_CRI			(CCLDRIVER_BASE_CTL+44)
#define CCLDRIVER_SYS_GET_MAC				(CCLDRIVER_BASE_CTL+45)
#define CCLDRIVER_SYS_GET_FIRMWARE_VER			(CCLDRIVER_BASE_CTL+46)
#define CCLDRIVER_SYS_GET_ASIC_VER			(CCLDRIVER_BASE_CTL+47)
#define CCLDRIVER_SYS_GET_PCBA_VER			(CCLDRIVER_BASE_CTL+48)
#define CCLDRIVER_VLAN_GET_MODE				(CCLDRIVER_BASE_CTL+51)
#define CCLDRIVER_VLAN_GET_PVID				(CCLDRIVER_BASE_CTL+52)
#define CCLDRIVER_VLAN_GET_INGRS_FLTR_CFG		(CCLDRIVER_BASE_CTL+53)
#define CCLDRIVER_VLAN_GET_ENTRY			(CCLDRIVER_BASE_CTL+54)
#define CCLDRIVER_VLAN_GET_TBL_SIZE			(CCLDRIVER_BASE_CTL+55)
#define CCLDRIVER_VLAN_GET_TBL_ENTRY			(CCLDRIVER_BASE_CTL+56)
#define CCLDRIVER_VLAN_GET_NUM_DELETES			(CCLDRIVER_BASE_CTL+57)
#define CCLDRIVER_VLAN_STACKING_GET_EBL			(CCLDRIVER_BASE_CTL+58)
#define CCLDRIVER_VLAN_STACKING_GET_PORT		(CCLDRIVER_BASE_CTL+59)
#define CCLDRIVER_VLAN_STACKING_GET_TBL_SIZE		(CCLDRIVER_BASE_CTL+60)
#define CCLDRIVER_VLAN_STACKING_GET_TBL_ENTRY		(CCLDRIVER_BASE_CTL+61)
#define CCLDRIVER_MOD_GET_TYPE				(CCLDRIVER_BASE_CTL+64)
#define CCLDRIVER_MOD_GET_DEFAULT_EBL			(CCLDRIVER_BASE_CTL+65)
#define CCLDRIVER_MOD_GET_DEFAULT_NEGO			(CCLDRIVER_BASE_CTL+66)
#define CCLDRIVER_MOD_GET_DEFAULT_SPEED_DUPLEX		(CCLDRIVER_BASE_CTL+67)
#define CCLDRIVER_MOD_GET_DEFAULT_FLOW_CTRL		(CCLDRIVER_BASE_CTL+68)
#define CCLDRIVER_MOD_GET_DEFAULT_SECURITY		(CCLDRIVER_BASE_CTL+69)
#define CCLDRIVER_MIB_GET_STATS_ALIGNMENT_ERRORS	(CCLDRIVER_BASE_CTL+70)
#define CCLDRIVER_MIB_GET_STATS_FCS_ERRORS		(CCLDRIVER_BASE_CTL+71)
#define CCLDRIVER_MIB_GET_STATS_SINGLE_COLLISION_FRAMES	(CCLDRIVER_BASE_CTL+72)
#define CCLDRIVER_MIB_GET_STATS_MULTIPLE_COLLISION_FRAMES	(CCLDRIVER_BASE_CTL+73)
#define CCLDRIVER_MIB_GET_STATS_SQE_TEST_ERRORS		(CCLDRIVER_BASE_CTL+74)
#define CCLDRIVER_MIB_GET_STATS_DEFERRED_TRANSMISSIONS	(CCLDRIVER_BASE_CTL+75)
#define CCLDRIVER_MIB_GET_STATS_LATE_COLLISIONS		(CCLDRIVER_BASE_CTL+76)
#define CCLDRIVER_MIB_GET_STATS_EXCESSIVE_COLLISIONS	(CCLDRIVER_BASE_CTL+77)
#define CCLDRIVER_MIB_GET_STATS_INTERNAL_MAC_TRANSMIT_ERRORS	(CCLDRIVER_BASE_CTL+78)
#define CCLDRIVER_MIB_GET_STATS_CARRIER_SENSE_ERRORS	(CCLDRIVER_BASE_CTL+79)
#define CCLDRIVER_MIB_GET_STATS_FRAME_TOO_LONGS		(CCLDRIVER_BASE_CTL+80)
#define CCLDRIVER_MIB_GET_STATS_INTERNAL_MAC_RECEIVE_ERRORS	(CCLDRIVER_BASE_CTL+81)
#define CCLDRIVER_MIB_GET_STATS_ETHER_CHIP_SET		(CCLDRIVER_BASE_CTL+82)
#define CCLDRIVER_MIB_GET_ETHER_STATS_DROP_EVENTS	(CCLDRIVER_BASE_CTL+83)
#define CCLDRIVER_MIB_GET_ETHER_STATS_OCTETS		(CCLDRIVER_BASE_CTL+84)
#define CCLDRIVER_MIB_GET_ETHER_STATS_PKTS		(CCLDRIVER_BASE_CTL+85)
#define CCLDRIVER_MIB_GET_ETHER_STATS_BROADCAST_PKTS	(CCLDRIVER_BASE_CTL+86)
#define CCLDRIVER_MIB_GET_ETHER_STATS_MULTICAST_PKTS	(CCLDRIVER_BASE_CTL+87)
#define CCLDRIVER_MIB_GET_ETHER_STATS_CRC_ALIGN_ERRORS	(CCLDRIVER_BASE_CTL+88)
#define CCLDRIVER_MIB_GET_ETHER_STATS_UNDER_SIZE_PKTS	(CCLDRIVER_BASE_CTL+89)
#define CCLDRIVER_MIB_GET_ETHER_STATS_OVER_SIZE_PKTS	(CCLDRIVER_BASE_CTL+90)
#define CCLDRIVER_MIB_GET_ETHER_STATS_FRAGMENTS		(CCLDRIVER_BASE_CTL+91)
#define CCLDRIVER_MIB_GET_ETHER_STATS_JABBERS		(CCLDRIVER_BASE_CTL+92)
#define CCLDRIVER_MIB_GET_ETHER_STATS_COLLISIONS	(CCLDRIVER_BASE_CTL+93)
#define CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_64_OCTETS	(CCLDRIVER_BASE_CTL+94)
#define CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_65_TO_127_OCTETS	(CCLDRIVER_BASE_CTL+95)
#define CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_128_TO_255_OCTETS	(CCLDRIVER_BASE_CTL+96)
#define CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_256_TO_511_OCTETS	(CCLDRIVER_BASE_CTL+97)
#define CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_512_TO_1023_OCTETS	(CCLDRIVER_BASE_CTL+98)
#define CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_1024_TO_1518_OCTETS	(CCLDRIVER_BASE_CTL+99)
#define CCLDRIVER_MIB_GET_ETHER_STATS_TX_UCAST_PKTS	(CCLDRIVER_BASE_CTL+100)
#define CCLDRIVER_MIB_GET_ETHER_STATS_TX_NUCAST_PKTS	(CCLDRIVER_BASE_CTL+101)
#define CCLDRIVER_MIB_GET_ETHER_STATS_TX_OCTETS		(CCLDRIVER_BASE_CTL+102)
#define CCLDRIVER_MIB_GET_ETHER_STATS_DROP_FWD_LKUP	(CCLDRIVER_BASE_CTL+103)
#define CCLDRIVER_MIB_GET_ETHER_STATS_DROP_IN_OVERRUN	(CCLDRIVER_BASE_CTL+104)
#define CCLDRIVER_MIB_GET_ETHER_STATS_TX_UNDERRUN	(CCLDRIVER_BASE_CTL+105)
#define CCLDRIVER_MIB_GET_ETHER_STATS_DROP_OUT_QUE_LIFE	(CCLDRIVER_BASE_CTL+106)
#define CCLDRIVER_MIB_GET_ETHER_STATS_OUT_QUE_LEN	(CCLDRIVER_BASE_CTL+107)
#define CCLDRIVER_GMRP_GET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+150)
#define CCLDRIVER_GVRP_GET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+160)
#define CCLDRIVER_IGMP_GET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+170)
#define CCLDRIVER_LACP_GET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+180)
#define CCLDRIVER_STP_GET_PROTOCOL_EBL			(CCLDRIVER_BASE_CTL+190)
#define CCLDRIVER_GET_MAX				(CCLDRIVER_BASE_CTL+199)

typedef struct {
	Tuint8	ucPortId;
	Tbool	bBool;
} TstPortBool;

typedef struct {
	Tuint8	ucPortId;
	Tuint8	ucUByte;
} TstPortUByte;

typedef struct {
	Tuint8	ucPortId;
	Tuint16	usUShort;
} TstPortUShort;

typedef struct {
	Tuint8	ucMode;
	Tuint8	ucHighQueWght;
	Tuint8	ucLowQueWght;
} TstFwdQos;

typedef struct {
	Tuint8		ucMode;
	Tuint8		ucPortId;
	TstLPortMask	stLPortMask;
} TstFwdPortMirror;

typedef struct {
	Tuint8	ucPortId;
	Tuint8	ucSpeed;
	Tuint8	ucDuplex;
} TstPortSpeedDuplex;

typedef struct {
	Tbool		bMcst;		/* multicast or unicast entry */
	Tuint16		usSlot;
	Tuint8		aucMac[MAC_ADDR_LEN];
	Tuint16		usFid;
	Tbool		bStatic;	/* static or dynamic entry */
	TstLPortMask	stLPortMask;
} TstMacEntry;

typedef struct {
	Tuint16		usSlot;
	Tuint32 	ulIp;
	Tbool		bStatic;
	TstLPortMask	stLPortMask;
} TstIpMcstEntry;

typedef struct {
	Tuint8	ucMajor;
	Tuint8	ucMinor;
	Tuint32	ulDate;
} TstSysVer;

typedef struct {
	Tuint16		usIndex;
	Tuint16		usVlanId;
	Tbool		bStatic;
	TstLPortMask	stPortMask;
	TstLPortMask	stTagMask;
	TstLPortMask	stFloodMask;
	TstLPortMask	stMcstMask;
        Tuint32 	ulCreationTime;
} TstVlanEntry;

typedef struct {
	Tuint16		usProtocolType;
	TstLPortMask	stPortMask;
	Tuint16		usVlanId;
} TstProtocolVlanEntry;

typedef struct {
	Tuint8	ucPortId;
	Tuint8	ucType;
	Tuint8	ucMode;
	Tuint16	usSvid;
} TstVlanStackingPort;

typedef struct {
	Tuint16	usIndex;
	Tuint16	usVlanId;
	Tuint16	usSvid;
} TstVlanStackingEntry;

typedef struct {
	Tuint8	ucModId;
	Tbool	bBool;
} TstModBool;

typedef struct {
	Tuint8	ucModId;
	Tuint8	ucUByte;
} TstModUByte;

typedef struct {
	Tuint8	ucModId;
	Tuint16	usUShort;
} TstModUShort;

typedef struct {
	Tuint8	ucModId;
	Tuint8	ucSpeed;
	Tuint8	ucDuplex;
} TstModSpeedDuplex;

typedef struct {
	Tuint8	ucPortId;
	Tuint32	ulResult;
} TstMibCntr;

#endif

