/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

#ifdef __LINUX_2_6_19__
#include <asm/uaccess.h>
#else
#include <linux/compatmac.h>
#endif
#include <linux/netfilter.h>

#include "krndef.h"
#include "krnerr.h"
#include "krnfwd.h"
#include "krngmrp.h"
#include "krngvrp.h"
#include "krnigmp.h"
#include "krnipmcst.h"
#include "krnlacp.h"
#include "krnmac.h"
#include "krnmib.h"
#include "krnmib_etherlike.h"
#include "krnmib_rmon.h"
#include "krnmod.h"
#include "krnport.h"
#include "krnportmask.h"
#include "krnstp.h"
#include "krnsys.h"
#include "krntrk.h"
#include "krntype.h"
#include "krnvlan.h"
#include "../cclmx/ccl_mx.h"
#include "../cclmx/ccl.h"

#include "ccldriver_netfilter.h"

//Save per vlan creation time : total 4096 entries
Tuint32   aulPerVlanCreationTime[MAX_NUM_VLANS+2]; 
Tuint32   ulVlanNumDeletes=0; 

void
MibGetCnt (
	Tuint8		ucPortId,
	Tuint32 *	pulResult,
	Tuint16 (*fn)(Tuint8, Tuint32 *)
	)
{
	TstPPortMask	pstPMask;
	Tuint8		ucPort;
	Tuint32		ulMibCnt = 0;
	Tuint32		ulMibAllCnt = 0;

	if (ucPortId < MAX_PHY_PORT) {
		ucPort = cclmx_LId2PId(ucPortId);
		fn(ucPort, pulResult);
	}
 	else if (ucPortId >= MAX_PHY_N_CPU_PORT) {
		cclmx_LId2PMask(&pstPMask, ucPortId);
		for (ucPort = 0; ucPort < MAX_PHY_PORT; ucPort++) {
			if (K_PPortMaskGetPort(&pstPMask, ucPort)) {
				fn(ucPort, &ulMibCnt);
				ulMibAllCnt += ulMibCnt;
			}
		}
		*pulResult = ulMibAllCnt;
	}
	else {
		*pulResult = 0;
	}
}		     
	 

/* This function is called whenever a process tries to do setsockopt */
int do_ccl_driver_set_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
{
	Tbool			bBool;
	Tuint8			ucUByte;
	Tuint16			usUShort;
	Tuint32			ulULong;
	TstPortBool		stPortBool;
	TstPortUByte		stPortUByte;
	TstPortUShort		stPortUShort;
	TstFwdQos		stFwdQos;
	TstFwdPortMirror	stFwdPortMirror;
	TstRule			stRule;
	TstPortSpeedDuplex	stPortSpeedDuplex;
	TstMacEntry		stMacEntry;
	TstIpMcstEntry		stIpMcstEntry;
	Tuint8			aucMac[MAC_ADDR_LEN];
	Tuint8			ucPPortId;
	TstPPortMask		stPPortMask;
	TstPPortMask		stPPortMask1;
#if 0
	TstPPortMask		stPPortMask2;
	TstPPortMask		stPPortMask3;
#endif
	TstVlanEntry		stVlanEntry;
	TstProtocolVlanEntry	stProtocolVlanEntry;
	TstVlanStackingPort	stVlanStackingPort;
	TstVlanStackingEntry	stVlanStackingEntry;
	TstLPortMask		stLPortMask;
 
	switch (cmd)
	{
	case CCLDRIVER_FWD_SET_MAC_AGE_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_FwdSetMacAge(bBool));
		break;
	case CCLDRIVER_FWD_SET_MAC_AGE_TIME:
		copy_from_user(&ulULong, user, sizeof(Tuint32));
		K_ErrOut(K_FwdSetMacAgeTime(ulULong));
		break;
	case CCLDRIVER_FWD_SET_BCST_STRM_FLTR:
		copy_from_user(&ulULong, user, sizeof(Tuint32));
		K_ErrOut(K_FwdSetBcstStrmFltr(ulULong));
		break;
	case CCLDRIVER_FWD_SET_BCST_STRM_FLTR_PORT_EBL:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		cclmx_LId2PMask(&stPPortMask, stPortBool.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_FwdSetBcstStrmFltrPortEbl(ucPPortId, stPortBool.bBool));
			}
		}
		break;
	case CCLDRIVER_FWD_SET_TRNSMT_DLY_BND:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_FwdSetTrnsmtDlyBnd(ucUByte));
		break;
	case CCLDRIVER_FWD_SET_QOS:
		copy_from_user(&stFwdQos, user, sizeof(TstFwdQos));
		K_ErrOut(K_FwdSetQos(stFwdQos.ucMode, stFwdQos.ucHighQueWght, stFwdQos.ucLowQueWght));
		break;
	case CCLDRIVER_FWD_SET_HIGH_QUE_PTN:
		copy_from_user(&usUShort, user, sizeof(Tuint16));
		K_ErrOut(K_FwdSetHighQuePtn(usUShort));
		break;
	case CCLDRIVER_FWD_SET_LOW_QUE_DLY_BND:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_FwdSetLowQueDlyBnd(bBool));
		break;
	case CCLDRIVER_FWD_SET_LOW_QUE_DLY_BND_TIME:
		copy_from_user(&ulULong, user, sizeof(Tuint32));
		K_ErrOut(K_FwdSetLowQueDlyBndTime(ulULong));
		break;
	case CCLDRIVER_FWD_SET_PORT_PRIO:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		cclmx_LId2PMask(&stPPortMask, stPortUByte.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_FwdSetPortPrio(ucPPortId, stPortUByte.ucUByte));
			}
		}
		break;
	case CCLDRIVER_FWD_SET_CLLSN_RTRY:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_FwdSetCllsnRtry(bBool));
		break;
#if 0
	case CCLDRIVER_FWD_SET_HASH_ALG:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_FwdSetHashAlg(ucUByte));
		break;
#endif
	case CCLDRIVER_FWD_SET_IFG_CPSN:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_FwdSetIFGCpsn(bBool));
		break;
	case CCLDRIVER_FWD_SET_PORT_MIRROR:
		copy_from_user(&stFwdPortMirror, user, sizeof(TstFwdPortMirror));
		cclmx_LMask2PMask(&stPPortMask, &stFwdPortMirror.stLPortMask);
		K_ErrOut(K_FwdSetPortMirror(stFwdPortMirror.ucMode, stFwdPortMirror.ucPortId, &stPPortMask));
		break;
	case CCLDRIVER_FWD_SET_MAX_FRAME_SIZE:
		copy_from_user(&ulULong, user, sizeof(Tuint32));
		K_ErrOut(K_FwdSetMaxFrameSize(ulULong));
		break;
	case CCLDRIVER_FWD_INS_RULE:
		copy_from_user(&stRule, user, sizeof(TstRule));
		K_ErrOut(K_FwdInsRule(&stRule.stClassifier, &stRule.stPolicy));
		break;
	case CCLDRIVER_FWD_DEL_RULE:
		copy_from_user(&usUShort, user, sizeof(Tuint16));
		K_ErrOut(K_FwdDelRule(usUShort));
		break;
	case CCLDRIVER_PORT_SET_EBL:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		cclmx_LId2PMask(&stPPortMask, stPortBool.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_PortSetEbl(ucPPortId, stPortBool.bBool));
			}
		}
		break;
	case CCLDRIVER_PORT_SET_NEGO:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		cclmx_LId2PMask(&stPPortMask, stPortUByte.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_PortSetNego(ucPPortId, stPortUByte.ucUByte));
			}
		}
		break;
	case CCLDRIVER_PORT_SET_SPEED_DUPLEX:
		copy_from_user(&stPortSpeedDuplex, user, sizeof(TstPortSpeedDuplex));
		cclmx_LId2PMask(&stPPortMask, stPortSpeedDuplex.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_PortSetSpeedDuplex(ucPPortId, stPortSpeedDuplex.ucSpeed, stPortSpeedDuplex.ucDuplex));
			}
		}
		break;
	case CCLDRIVER_PORT_SET_FLOW_CTRL:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		cclmx_LId2PMask(&stPPortMask, stPortUByte.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_PortSetFlowCtrl(ucPPortId, stPortUByte.ucUByte));
			}
		}
		break;
	case CCLDRIVER_PORT_SET_SECURITY:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		cclmx_LId2PMask(&stPPortMask, stPortBool.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
#ifdef __LEOA__
				K_ErrOut(K_PortSetSecurityEbl(ucPPortId, stPortBool.bBool));
#else
				K_ErrOut(K_PortSetSecurity(ucPPortId, stPortBool.bBool));
#endif
			}
		}
		break;
	case CCLDRIVER_PORT_SET_RATE_INGRS:
		copy_from_user(&stPortUShort, user, sizeof(TstPortUShort));
		cclmx_LId2PMask(&stPPortMask, stPortUShort.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_PortSetRateIngrs(ucPPortId, stPortUShort.usUShort));
			}
		}
		break;
	case CCLDRIVER_PORT_SET_RATE_EGRS:
		copy_from_user(&stPortUShort, user, sizeof(TstPortUShort));
		cclmx_LId2PMask(&stPPortMask, stPortUShort.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_PortSetRateEgrs(ucPPortId, stPortUShort.usUShort));
			}
		}
		break;
	case CCLDRIVER_MAC_CLR_TBL:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_MacClrTbl(ucUByte));
		break;
	case CCLDRIVER_MAC_INS_ENTRY:
		copy_from_user(&stMacEntry, user, sizeof(TstMacEntry));
		cclmx_LMask2PMask(&stPPortMask, &stMacEntry.stLPortMask);
		K_ErrOut(K_MacInsEntry(stMacEntry.aucMac, stMacEntry.usFid, stMacEntry.bStatic, &stPPortMask));
		break;
	case CCLDRIVER_MAC_DEL_ENTRY:
		copy_from_user(&stMacEntry, user, sizeof(TstMacEntry));
		K_ErrOut(K_MacDelEntry(stMacEntry.aucMac, stMacEntry.usFid));
		break;
	case CCLDRIVER_IP_MCST_CLR_TBL:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_IpMcstClrTbl(ucUByte));
		break;
	case CCLDRIVER_IP_MCST_INS_ENTRY:
		copy_from_user(&stIpMcstEntry, user, sizeof(TstIpMcstEntry));
		cclmx_LMask2PMask(&stPPortMask, &stIpMcstEntry.stLPortMask);
		K_ErrOut(K_IpMcstInsEntry(stIpMcstEntry.ulIp, stIpMcstEntry.bStatic, &stPPortMask));
		break;
	case CCLDRIVER_IP_MCST_DEL_ENTRY:
		copy_from_user(&ulULong, user, sizeof(Tuint32));
		K_ErrOut(K_IpMcstDelEntry(ulULong));
		break;
#if 0
	case CCLDRIVER_TRK_SET_MAC_HASH:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_TrkSetMacHash(ucUByte));
		break;
#endif
	case CCLDRIVER_TRK_SET_TCKT_GEN_ALG:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_TrkSetTcktGenAlg(ucUByte));
		break;
	case CCLDRIVER_TRK_INS_TRK:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_TrkInsTrk(ucUByte));
		break;
	case CCLDRIVER_TRK_DEL_TRK:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_TrkDelTrk(ucUByte));
		break;
	case CCLDRIVER_TRK_SET_PORT_AGGR_ID:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		K_ErrOut(K_TrkSetPortAggrId(stPortUByte.ucPortId, stPortUByte.ucUByte));
		break;
	case CCLDRIVER_TRK_SET_PORT_STATUS:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		K_ErrOut(K_TrkSetPortStatus(stPortBool.ucPortId, stPortBool.bBool));
		break;
	case CCLDRIVER_TRK_SET_PORT_ADM_CRI:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		K_ErrOut(K_TrkSetPortAdmCri(stPortUByte.ucPortId, stPortUByte.ucUByte));
		break;
	case CCLDRIVER_SYS_SET_MAC:
		copy_from_user(aucMac, user, sizeof(Tuint8)*MAC_ADDR_LEN);
		K_ErrOut(K_SysSetMac(aucMac));
		break;
	case CCLDRIVER_SYS_REBOOT:
		K_ErrOut(K_SysReboot());
		break;
	case CCLDRIVER_VLAN_SET_PROTOCOL_VLAN_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_VlanSetProtocolVlanEbl(bBool));
		break;
	case CCLDRIVER_VLAN_SET_MODE:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_VlanSetMode(ucUByte));
		break;
	case CCLDRIVER_VLAN_SET_PVID:
		copy_from_user(&stPortUShort, user, sizeof(TstPortUShort));
		cclmx_LId2PMask(&stPPortMask, stPortUShort.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_VlanSetPvid(ucPPortId, stPortUShort.usUShort));
			}
		}
		break;
	case CCLDRIVER_VLAN_SET_INGRS_FLTR_CFG:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		cclmx_LId2PMask(&stPPortMask, stPortUByte.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_VlanSetIngrsFltrCfg(ucPPortId, stPortUByte.ucUByte));
			}
		}
		break;
	case CCLDRIVER_VLAN_CLR_TBL:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		K_ErrOut(K_VlanClrTbl(ucUByte));
		break;
	case CCLDRIVER_VLAN_INS_ENTRY:
		copy_from_user(&stVlanEntry, user, sizeof(TstVlanEntry));
		cclmx_LMask2PMask(&stPPortMask, &stVlanEntry.stPortMask);
		cclmx_LMask2PMask(&stPPortMask1, &stVlanEntry.stTagMask);
#if 0
		cclmx_LMask2PMask(&stPPortMask2, &stVlanEntry.stFloodMask);
		cclmx_LMask2PMask(&stPPortMask3, &stVlanEntry.stMcstMask);
#endif
		K_ErrOut(K_VlanInsEntry(stVlanEntry.usVlanId, stVlanEntry.bStatic, &stPPortMask, &stPPortMask1));
                aulPerVlanCreationTime[stVlanEntry.usVlanId] = jiffies/HZ;
		break;
	case CCLDRIVER_VLAN_DEL_ENTRY:
		copy_from_user(&usUShort, user, sizeof(Tuint16));
		K_ErrOut(K_VlanDelEntry(usUShort));
		ulVlanNumDeletes++;
		break;
	case CCLDRIVER_VLAN_INS_PROTOCOL_VLAN_ENTRY:
		copy_from_user(&stProtocolVlanEntry, user, sizeof(TstProtocolVlanEntry));
		cclmx_LMask2PMask(&stPPortMask, &stProtocolVlanEntry.stPortMask);
		K_ErrOut(K_VlanInsProtocolVlanEntry(stProtocolVlanEntry.usProtocolType, &stPPortMask, stProtocolVlanEntry.usVlanId));
		break;
	case CCLDRIVER_VLAN_DEL_PROTOCOL_VLAN_ENTRY:
		copy_from_user(&stProtocolVlanEntry, user, sizeof(TstProtocolVlanEntry));
		cclmx_LMask2PMask(&stPPortMask, &stProtocolVlanEntry.stPortMask);
		K_ErrOut(K_VlanDelProtocolVlanEntry(stProtocolVlanEntry.usProtocolType, &stPPortMask));
		break;
	case CCLDRIVER_VLAN_CLR_PORT_BASED:
		K_ErrOut(K_VlanClrPortBased());
		break;
	case CCLDRIVER_VLAN_ADD_PORT_BASED:
		copy_from_user(&stLPortMask, user, sizeof(TstLPortMask));
		cclmx_LMask2PMask(&stPPortMask, &stLPortMask);
		K_ErrOut(K_VlanAddPortBased(&stPPortMask));
		break;
	case CCLDRIVER_VLAN_PER_VLAN_FLOODING_PORTMASK_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_VlanPerVlanFloodingPortmaskEbl(bBool));
		break;
	case CCLDRIVER_VLAN_STACKING_SET_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_VlanStackingSetEbl(bBool));
		break;
	case CCLDRIVER_VLAN_STACKING_SET_PORT:
		copy_from_user(&stVlanStackingPort, user, sizeof(TstVlanStackingPort));
		K_ErrOut(K_VlanStackingSetPort(stVlanStackingPort.ucPortId, stVlanStackingPort.ucType, stVlanStackingPort.ucMode, stVlanStackingPort.usSvid));
		break;
	case CCLDRIVER_VLAN_STACKING_INS_ENTRY:
		copy_from_user(&stVlanStackingEntry, user, sizeof(TstVlanStackingEntry));
		K_ErrOut(K_VlanStackingInsEntry(stVlanStackingEntry.usVlanId, stVlanStackingEntry.usSvid));
		break;
	case CCLDRIVER_VLAN_STACKING_DEL_ENTRY:
		copy_from_user(&usUShort, user, sizeof(Tuint16));
		K_ErrOut(K_VlanStackingDelEntry(usUShort));
		break;
	case CCLDRIVER_MIB_CLR_CNTR:
		copy_from_user(&ucUByte, user, sizeof(ucUByte));
		cclmx_LId2PMask(&stPPortMask, ucUByte);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_MibClrCntr(ucPPortId));
			}
		}
		break;
	case CCLDRIVER_GMRP_SET_PROTOCOL_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_GmrpSetEbl(bBool));
		break;
	case CCLDRIVER_GVRP_SET_PROTOCOL_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_GmrpSetEbl(bBool));
		break;
	case CCLDRIVER_IGMP_SET_PROTOCOL_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_IgmpSetEbl(bBool));
		break;
	case CCLDRIVER_LACP_SET_PROTOCOL_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_LacpSetEbl(bBool));
		break;
	case CCLDRIVER_STP_SET_PROTOCOL_EBL:
		copy_from_user(&bBool, user, sizeof(Tbool));
		K_ErrOut(K_StpSetEbl(bBool));
		break;
	case CCLDRIVER_STP_SET_PORT_STATE:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		cclmx_LId2PMask(&stPPortMask, stPortUByte.ucPortId);
		for (ucPPortId = 0; ucPPortId < MAX_PHY_PORT; ++ucPPortId) {
			if (K_PPortMaskGetPort(&stPPortMask, ucPPortId)) {
				K_ErrOut(K_StpSetPort(ucPPortId, stPortUByte.ucUByte));
			}
		}
		break;
	default:
		break;
	}

	return 0;
}


/* This function is called whenever a process tries to do getsockopt */
int do_ccl_driver_get_ctl(struct sock *sk, int cmd, void *user, int *len)
{
	Tbool			bBool;
	Tuint8			ucUByte;
	Tuint16			usUShort;
	Tuint32			ulULong;
	TstPortBool		stPortBool;
	TstPortUByte		stPortUByte;
	TstPortUShort		stPortUShort;
	TstFwdQos		stFwdQos;
	TstFwdPortMirror	stFwdPortMirror;
	TstRule			stRule;
	TstPortSpeedDuplex	stPortSpeedDuplex;
	TstMacEntry		stMacEntry;
	TstIpMcstEntry		stIpMcstEntry;
	Tuint8			aucMac[MAC_ADDR_LEN];
	TstSysVer		stSysVer;
	Tuint8			ucPPortId;
	TstPPortMask		stPPortMask;
	TstPPortMask		stPPortMask1;
#if 0
	TstPPortMask		stPPortMask2;
	TstPPortMask		stPPortMask3;
#endif
	TstModBool		stModBool;
	TstModUByte		stModUByte;
	TstModSpeedDuplex	stModSpeedDuplex;
	TstVlanEntry		stVlanEntry;
	TstVlanStackingPort	stVlanStackingPort;
	TstVlanStackingEntry	stVlanStackingEntry;
	TstMibCntr		stMibCntr;

	switch(cmd)
	{
	case CCLDRIVER_FWD_GET_MAC_AGE_EBL:
		K_ErrOut(K_FwdGetMacAge(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_FWD_GET_MAC_AGE_TIME:
		K_ErrOut(K_FwdGetMacAgeTime(&ulULong));
		copy_to_user(user, &ulULong, sizeof(Tuint32));
		break;
	case CCLDRIVER_FWD_GET_BCST_STRM_FLTR:
		K_ErrOut(K_FwdGetBcstStrmFltr(&ulULong));
		copy_to_user(user, &ulULong, sizeof(Tuint32));
		break;
	case CCLDRIVER_FWD_GET_BCST_STRM_FLTR_PORT_EBL:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		ucPPortId = cclmx_LId2PId(stPortBool.ucPortId);
		K_ErrOut(K_FwdGetBcstStrmFltrPortEbl(ucPPortId, &stPortBool.bBool));
		copy_to_user(user, &stPortBool, sizeof(TstPortBool));
		break;
	case CCLDRIVER_FWD_GET_TRNSMT_DLY_BND:
		K_ErrOut(K_FwdGetTrnsmtDlyBnd(&ucUByte));
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;
	case CCLDRIVER_FWD_GET_QOS:
		K_ErrOut(K_FwdGetQos(&stFwdQos.ucMode, &stFwdQos.ucHighQueWght, &stFwdQos.ucLowQueWght));
		copy_to_user(user, &stFwdQos, sizeof(TstFwdQos));
		break;
	case CCLDRIVER_FWD_GET_HIGH_QUE_PTN:
		K_ErrOut(K_FwdGetHighQuePtn(&usUShort));
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;
	case CCLDRIVER_FWD_GET_LOW_QUE_DLY_BND:
		K_ErrOut(K_FwdGetLowQueDlyBnd(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_FWD_GET_LOW_QUE_DLY_BND_TIME:
		K_ErrOut(K_FwdGetLowQueDlyBndTime(&ulULong));
		copy_to_user(user, &ulULong, sizeof(Tuint32));
		break;
	case CCLDRIVER_FWD_GET_PORT_PRIO:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		ucPPortId = cclmx_LId2PId(stPortUByte.ucPortId);
		K_ErrOut(K_FwdGetPortPrio(ucPPortId, &stPortUByte.ucUByte));
		copy_to_user(user, &stPortUByte, sizeof(TstPortUByte));
		break;
	case CCLDRIVER_FWD_GET_CLLSN_RTRY:
		K_ErrOut(K_FwdGetCllsnRtry(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
#if 0
	case CCLDRIVER_FWD_GET_HASH_ALG:
		K_ErrOut(K_FwdGetHashAlg(&ucUByte));
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;
#endif
	case CCLDRIVER_FWD_GET_IFG_CPSN:
		K_ErrOut(K_FwdGetIFGCpsn(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_FWD_GET_PORT_MIRROR:
		K_ErrOut(K_FwdGetPortMirror(&stFwdPortMirror.ucMode, &stFwdPortMirror.ucPortId, &stPPortMask));
		cclmx_PMask2LMask(&stFwdPortMirror.stLPortMask, &stPPortMask);
		copy_to_user(user, &stFwdPortMirror, sizeof(TstFwdPortMirror));
		break;
	case CCLDRIVER_FWD_GET_MAX_FRAME_SIZE:
		K_ErrOut(K_FwdGetMaxFrameSize(&ulULong));
		copy_to_user(user, &ulULong, sizeof(Tuint32));
		break;
	case CCLDRIVER_FWD_GET_RULE_SIZE:
		K_ErrOut(K_FwdGetRuleSize(&usUShort));
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;
	case CCLDRIVER_FWD_GET_RULE_ENTRY:
		copy_from_user(&stRule, user, sizeof(TstRule));
		if (K_FwdGetRuleEntry(stRule.usIndex, &stRule.stClassifier, &stRule.stPolicy) != KRN_RET_OK) {
			return -KRN_RET_ERR_FWD_GET_RULE_ENTRY;
		}
		copy_to_user(user, &stRule, sizeof(TstRule));
		break;
	case CCLDRIVER_PORT_GET_LINK:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		ucPPortId = cclmx_LId2PId(stPortBool.ucPortId);
		K_ErrOut(K_PortGetLink(ucPPortId, &stPortBool.bBool));
		copy_to_user(user, &stPortBool, sizeof(TstPortBool));
		break;
	case CCLDRIVER_PORT_GET_EBL:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		ucPPortId = cclmx_LId2PId(stPortBool.ucPortId);
		K_ErrOut(K_PortGetEbl(ucPPortId, &stPortBool.bBool));
		copy_to_user(user, &stPortBool, sizeof(TstPortBool));
		break;
	case CCLDRIVER_PORT_GET_NEGO:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		ucPPortId = cclmx_LId2PId(stPortUByte.ucPortId);
		K_ErrOut(K_PortGetNego(ucPPortId, &stPortUByte.ucUByte));
		copy_to_user(user, &stPortUByte, sizeof(TstPortUByte));
		break;
	case CCLDRIVER_PORT_GET_SPEED_DUPLEX:
		copy_from_user(&stPortSpeedDuplex, user, sizeof(TstPortSpeedDuplex));
		ucPPortId = cclmx_LId2PId(stPortSpeedDuplex.ucPortId);
		K_ErrOut(K_PortGetSpeedDuplex(ucPPortId, &stPortSpeedDuplex.ucSpeed, &stPortSpeedDuplex.ucDuplex));
		copy_to_user(user, &stPortSpeedDuplex, sizeof(TstPortSpeedDuplex));
		break;
	case CCLDRIVER_PORT_GET_FLOW_CTRL:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		ucPPortId = cclmx_LId2PId(stPortUByte.ucPortId);
		K_ErrOut(K_PortGetFlowCtrl(ucPPortId, &stPortUByte.ucUByte));
		copy_to_user(user, &stPortUByte, sizeof(TstPortUByte));
		break;
	case CCLDRIVER_PORT_GET_SECURITY:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		ucPPortId = cclmx_LId2PId(stPortBool.ucPortId);
#ifdef __LEOA__
		K_ErrOut(K_PortGetSecurityEbl(ucPPortId, &stPortBool.bBool));
#else
		K_ErrOut(K_PortGetSecurity(ucPPortId, &stPortBool.bBool));
#endif
		copy_to_user(user, &stPortBool, sizeof(TstPortBool));
		break;
	case CCLDRIVER_PORT_GET_RATE_INGRS:
		copy_from_user(&stPortUShort, user, sizeof(TstPortUShort));
		ucPPortId = cclmx_LId2PId(stPortUShort.ucPortId);
		K_ErrOut(K_PortGetRateIngrs(ucPPortId, &stPortUShort.usUShort));
		copy_to_user(user, &stPortUShort, sizeof(TstPortUShort));
		break;
	case CCLDRIVER_PORT_GET_RATE_EGRS:
		copy_from_user(&stPortUShort, user, sizeof(TstPortUShort));
		ucPPortId = cclmx_LId2PId(stPortUShort.ucPortId);
		K_ErrOut(K_PortGetRateEgrs(ucPPortId, &stPortUShort.usUShort));
		copy_to_user(user, &stPortUShort, sizeof(TstPortUShort));
		break;
	case CCLDRIVER_MAC_GET_ENTRY:
		copy_from_user(&stMacEntry, user, sizeof(TstMacEntry));
		if (K_MacGetEntry(stMacEntry.aucMac, &stMacEntry.usFid, &stMacEntry.bStatic, &stPPortMask) != KRN_RET_OK) {
			return -KRN_RET_ERR_MAC_GET_ENTRY;
		}
		cclmx_PMask2LMask(&stMacEntry.stLPortMask, &stPPortMask);
		copy_to_user(user, &stMacEntry, sizeof(TstMacEntry));
		break;
	case CCLDRIVER_MAC_GET_TBL_SIZE:
		K_ErrOut(K_MacGetTblSize(&usUShort));
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;
	case CCLDRIVER_MAC_GET_TBL_ENTRY:
		copy_from_user(&stMacEntry, user, sizeof(TstMacEntry));
		if (K_MacGetTblEntry(stMacEntry.bMcst, stMacEntry.usSlot, stMacEntry.aucMac, &stMacEntry.usFid, &stMacEntry.bStatic, &stPPortMask) != KRN_RET_OK) {
			return -KRN_RET_ERR_MAC_GET_TBL_ENTRY;
		}
		cclmx_PMask2LMask(&stMacEntry.stLPortMask, &stPPortMask);
		copy_to_user(user, &stMacEntry, sizeof(TstMacEntry));
		break;
	case CCLDRIVER_IP_MCST_GET_ENTRY:
		copy_from_user(&stIpMcstEntry, user, sizeof(TstIpMcstEntry));
		if (K_IpMcstGetEntry(stIpMcstEntry.ulIp, &stIpMcstEntry.bStatic, &stPPortMask) != KRN_RET_OK) {
			return -KRN_RET_ERR_IP_MCST_GET_ENTRY;
		}
		cclmx_PMask2LMask(&stIpMcstEntry.stLPortMask, &stPPortMask);
		copy_to_user(user, &stIpMcstEntry, sizeof(TstIpMcstEntry));
		break;
	case CCLDRIVER_IP_MCST_GET_TBL_SIZE:
		K_ErrOut(K_IpMcstGetTblSize(&usUShort));
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;
	case CCLDRIVER_IP_MCST_GET_TBL_ENTRY:
		copy_from_user(&stIpMcstEntry, user, sizeof(TstIpMcstEntry));
		if (K_IpMcstGetTblEntry(stIpMcstEntry.usSlot, &stIpMcstEntry.ulIp, &stIpMcstEntry.bStatic, &stPPortMask) != KRN_RET_OK) {
			return -KRN_RET_ERR_IP_MCST_GET_TBL_ENTRY;
		}
		cclmx_PMask2LMask(&stIpMcstEntry.stLPortMask, &stPPortMask);
		copy_to_user(user, &stIpMcstEntry, sizeof(TstIpMcstEntry));
		break;
#if 0
	case CCLDRIVER_TRK_GET_MAC_HASH:
		K_ErrOut(K_TrkGetMacHash(&ucUByte));
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;
#endif
	case CCLDRIVER_TRK_GET_TCKT_GEN_ALG:
		K_ErrOut(K_TrkGetTcktGenAlg(&ucUByte));
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;
	case CCLDRIVER_TRK_GET_PORT_AGGR_ID:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		ucPPortId = cclmx_LId2PId(stPortUByte.ucPortId);
		K_ErrOut(K_TrkGetPortAggrId(ucPPortId, &stPortUByte.ucUByte));
		copy_to_user(user, &stPortUByte, sizeof(TstPortUByte));
		break;
	case CCLDRIVER_TRK_GET_PORT_STATUS:
		copy_from_user(&stPortBool, user, sizeof(TstPortBool));
		ucPPortId = cclmx_LId2PId(stPortBool.ucPortId);
		K_ErrOut(K_TrkGetPortStatus(ucPPortId, &stPortBool.bBool));
		copy_to_user(user, &stPortBool, sizeof(TstPortBool));
		break;
	case CCLDRIVER_TRK_GET_PORT_ADM_CRI:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		ucPPortId = cclmx_LId2PId(stPortUByte.ucPortId);
		K_ErrOut(K_TrkGetPortAdmCri(ucPPortId, &stPortUByte.ucUByte));
		copy_to_user(user, &stPortUByte, sizeof(TstPortUByte));
		break;
	case CCLDRIVER_SYS_GET_MAC:
		K_ErrOut(K_SysGetMac(aucMac));
		copy_to_user(user, aucMac, sizeof(Tuint8)*MAC_ADDR_LEN);
		break;
	case CCLDRIVER_SYS_GET_FIRMWARE_VER:
		K_ErrOut(K_SysGetFirmwareVer(&stSysVer.ucMajor, &stSysVer.ucMinor, &stSysVer.ulDate));
		copy_to_user(user, &stSysVer, sizeof(TstSysVer));
		break;
	case CCLDRIVER_SYS_GET_ASIC_VER:
		K_ErrOut(K_SysGetASICVer(&stSysVer.ucMajor, &stSysVer.ucMinor));
		copy_to_user(user, &stSysVer, sizeof(TstSysVer));
		break;
	case CCLDRIVER_SYS_GET_PCBA_VER:
		K_ErrOut(K_SysGetPCBAVer(&stSysVer.ucMajor, &stSysVer.ucMinor));
		copy_to_user(user, &stSysVer, sizeof(TstSysVer));
		break;
	case CCLDRIVER_VLAN_GET_MODE:
		K_ErrOut(K_VlanGetMode(&ucUByte));
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;
	case CCLDRIVER_VLAN_GET_PVID:
		copy_from_user(&stPortUShort, user, sizeof(TstPortUShort));
		ucPPortId = cclmx_LId2PId(stPortUShort.ucPortId);
		K_ErrOut(K_VlanGetPvid(ucPPortId, &stPortUShort.usUShort));
		copy_to_user(user, &stPortUShort, sizeof(TstPortUShort));
		break;
	case CCLDRIVER_VLAN_GET_INGRS_FLTR_CFG:
		copy_from_user(&stPortUByte, user, sizeof(TstPortUByte));
		ucPPortId = cclmx_LId2PId(stPortUByte.ucPortId);
		K_ErrOut(K_VlanGetIngrsFltrCfg(ucPPortId, &stPortUByte.ucUByte));
		copy_to_user(user, &stPortUByte, sizeof(TstPortUByte));
		break;
	case CCLDRIVER_VLAN_GET_ENTRY:
		copy_from_user(&stVlanEntry, user, sizeof(TstVlanEntry));
		if (K_VlanGetEntry(stVlanEntry.usVlanId, &stVlanEntry.bStatic, &stPPortMask, &stPPortMask1) != KRN_RET_OK) {
			return -KRN_RET_ERR_VLAN_GET_ENTRY;
		}
		cclmx_PMask2LMask(&stVlanEntry.stPortMask, &stPPortMask);
		cclmx_PMask2LMask(&stVlanEntry.stTagMask, &stPPortMask1);
#if 0
		cclmx_PMask2LMask(&stVlanEntry.stFloodMask, &stPPortMask2);
		cclmx_PMask2LMask(&stVlanEntry.stMcstMask, &stPPortMask3);
#endif
	        stVlanEntry.ulCreationTime = aulPerVlanCreationTime[stVlanEntry.usVlanId];
	        copy_to_user(user, &stVlanEntry, sizeof(TstVlanEntry));
		break;
	case CCLDRIVER_VLAN_GET_TBL_SIZE:
		K_ErrOut(K_VlanGetTblSize(&usUShort));
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;
	case CCLDRIVER_VLAN_GET_TBL_ENTRY:
		copy_from_user(&stVlanEntry, user, sizeof(TstVlanEntry));
		if (K_VlanGetTblEntry(stVlanEntry.usIndex, &stVlanEntry.usVlanId, &stVlanEntry.bStatic, &stPPortMask, &stPPortMask1) != KRN_RET_OK) {
			return -KRN_RET_ERR_VLAN_GET_TBL_ENTRY;
		}
		cclmx_PMask2LMask(&stVlanEntry.stPortMask, &stPPortMask);
		cclmx_PMask2LMask(&stVlanEntry.stTagMask, &stPPortMask1);
#if 0
		cclmx_PMask2LMask(&stVlanEntry.stFloodMask, &stPPortMask2);
		cclmx_PMask2LMask(&stVlanEntry.stMcstMask, &stPPortMask3);
#endif
	        stVlanEntry.ulCreationTime = aulPerVlanCreationTime[stVlanEntry.usVlanId];
		copy_to_user(user, &stVlanEntry, sizeof(TstVlanEntry));
		break;
	case CCLDRIVER_VLAN_GET_NUM_DELETES:
	        copy_to_user(user, &ulVlanNumDeletes, sizeof(Tuint32));
		break;
	case CCLDRIVER_VLAN_STACKING_GET_EBL:
		K_ErrOut(K_VlanStackingGetEbl(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_VLAN_STACKING_GET_PORT:
		copy_from_user(&stVlanStackingPort, user, sizeof(TstVlanStackingPort));
		K_ErrOut(K_VlanStackingGetPort(stVlanStackingPort.ucPortId, &stVlanStackingPort.ucType, &stVlanStackingPort.ucMode, &stVlanStackingPort.usSvid));
		copy_to_user(user, &stVlanStackingPort, sizeof(TstVlanStackingPort));
		break;
	case CCLDRIVER_VLAN_STACKING_GET_TBL_SIZE:
		K_ErrOut(K_VlanStackingGetTblSize(&usUShort));
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;
	case CCLDRIVER_VLAN_STACKING_GET_TBL_ENTRY:
		copy_from_user(&stVlanStackingEntry, user, sizeof(TstVlanStackingEntry));
		if (K_VlanStackingGetTblEntry(stVlanStackingEntry.usIndex, &stVlanStackingEntry.usVlanId, &stVlanStackingEntry.usSvid) != KRN_RET_OK) {
			return -KRN_RET_ERR_VLAN_STACKING_GET_TBL_ENTRY;
		}
		copy_to_user(user, &stVlanStackingEntry, sizeof(TstVlanStackingEntry));
		break;
	case CCLDRIVER_MOD_GET_TYPE:
		copy_from_user(&stModUByte, user, sizeof(TstModUByte));
		K_ErrOut(K_ModGetType(stModUByte.ucModId, &stModUByte.ucUByte));
		copy_to_user(user, &stModUByte, sizeof(TstModUByte));
		break;
	case CCLDRIVER_MOD_GET_DEFAULT_EBL:
		copy_from_user(&stModBool, user, sizeof(TstModBool));
		K_ErrOut(K_ModGetDefaultEbl(stModBool.ucModId, &stModBool.bBool));
		copy_to_user(user, &stModBool, sizeof(TstModBool));
		break;
	case CCLDRIVER_MOD_GET_DEFAULT_NEGO:
		copy_from_user(&stModUByte, user, sizeof(TstModUByte));
		K_ErrOut(K_ModGetDefaultNego(stModUByte.ucModId, &stModUByte.ucUByte));
		copy_to_user(user, &stModUByte, sizeof(TstModUByte));
		break;
	case CCLDRIVER_MOD_GET_DEFAULT_SPEED_DUPLEX:
		copy_from_user(&stModSpeedDuplex, user, sizeof(TstModSpeedDuplex));
		K_ErrOut(K_ModGetDefaultSpeedDuplex(stModSpeedDuplex.ucModId, &stModSpeedDuplex.ucSpeed, &stModSpeedDuplex.ucDuplex));
		copy_to_user(user, &stModSpeedDuplex, sizeof(TstModSpeedDuplex));
		break;
	case CCLDRIVER_MOD_GET_DEFAULT_FLOW_CTRL:
		copy_from_user(&stModUByte, user, sizeof(TstModUByte));
		K_ErrOut(K_ModGetDefaultFlowCtrl(stModUByte.ucModId, &stModUByte.ucUByte));
		copy_to_user(user, &stModUByte, sizeof(TstModUByte));
		break;
	case CCLDRIVER_MOD_GET_DEFAULT_SECURITY:
		copy_from_user(&stModBool, user, sizeof(TstModBool));
		K_ErrOut(K_ModGetDefaultSecurity(stModBool.ucModId, &stModBool.bBool));
		copy_to_user(user, &stModBool, sizeof(TstModBool));
		break;
	case CCLDRIVER_MIB_GET_STATS_ALIGNMENT_ERRORS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsAlignmentErrors);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_FCS_ERRORS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsFCSErrors);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_SINGLE_COLLISION_FRAMES:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsSingleCollisionFrames);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_MULTIPLE_COLLISION_FRAMES:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsMultipleCollisionFrames);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_SQE_TEST_ERRORS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsSQETestErrors);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_DEFERRED_TRANSMISSIONS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsDeferredTransmissions);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_LATE_COLLISIONS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsLateCollisions);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_EXCESSIVE_COLLISIONS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsExcessiveCollisions);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_INTERNAL_MAC_TRANSMIT_ERRORS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsInternalMacTransmitErrors);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_CARRIER_SENSE_ERRORS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsCarrierSenseErrors);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_FRAME_TOO_LONGS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsFrameTooLongs);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_INTERNAL_MAC_RECEIVE_ERRORS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsInternalMacReceiveErrors);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_STATS_ETHER_CHIP_SET:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetStatsEtherChipSet);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_DROP_EVENTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsDropEvents);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsOctets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_PKTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsPkts);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_BROADCAST_PKTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsBroadcastPkts);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_MULTICAST_PKTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsMulticastPkts);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_CRC_ALIGN_ERRORS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsCRCAlignErrors);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_UNDER_SIZE_PKTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsUnderSizePkts);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_OVER_SIZE_PKTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsOverSizePkts);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_FRAGMENTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsFragments);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_JABBERS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsJabbers);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_COLLISIONS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsCollisions);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_64_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsPkts64Octets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_65_TO_127_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsPkts65to127Octets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_128_TO_255_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsPkts128to255Octets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_256_TO_511_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsPkts256to511Octets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_512_TO_1023_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsPkts512to1023Octets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_PKTS_1024_TO_1518_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsPkts1024to1518Octets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_TX_UCAST_PKTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsTxUcastPkts);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_TX_NUCAST_PKTS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsTxNUcastPkts);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_TX_OCTETS:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsTxOctets);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_DROP_FWD_LKUP:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsDropFwdLkup);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_DROP_IN_OVERRUN:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsDropInOverrun);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_TX_UNDERRUN:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsTxUnderrun);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_DROP_OUT_QUE_LIFE:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsDropOutQueLife);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_MIB_GET_ETHER_STATS_OUT_QUE_LEN:
		copy_from_user(&stMibCntr, user, sizeof(TstMibCntr));
		MibGetCnt(stMibCntr.ucPortId, &stMibCntr.ulResult, K_MibGetEtherStatsOutQueLen);
		copy_to_user(user, &stMibCntr, sizeof(TstMibCntr));
		break;
	case CCLDRIVER_GMRP_GET_PROTOCOL_EBL:
		K_ErrOut(K_GmrpGetEbl(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_GVRP_GET_PROTOCOL_EBL:
		K_ErrOut(K_GvrpGetEbl(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_IGMP_GET_PROTOCOL_EBL:
		K_ErrOut(K_IgmpGetEbl(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_LACP_GET_PROTOCOL_EBL:
		K_ErrOut(K_LacpGetEbl(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	case CCLDRIVER_STP_GET_PROTOCOL_EBL:
		K_ErrOut(K_StpGetEbl(&bBool));
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;
	default:
		break;
	}

	return 0;
}

struct nf_sockopt_ops ccldriver_sockopts = {
	{ NULL, NULL }, PF_INET,
	CCLDRIVER_BASE_CTL, CCLDRIVER_SET_MAX+1, do_ccl_driver_set_ctl, NULL,
	CCLDRIVER_BASE_CTL, CCLDRIVER_GET_MAX+1, do_ccl_driver_get_ctl, NULL
};

