/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

#include <linux/netfilter.h>

#include "krnsys.h"

extern struct nf_sockopt_ops ccldriver_sockopts;

/* register netfilter socket option */
static int __init ccldriver_init(void)
{
	/* Driver APIs initialization */
	K_SysInit();

	/* register netfilter socket option */
	if(nf_register_sockopt(&ccldriver_sockopts)) {
		printk("ccl_driver: nf_register_sockopt failed.\n");
		return 0;
	}

	return 0;
}

static void __exit ccldriver_exit(void)
{
	nf_unregister_sockopt(&ccldriver_sockopts);
}

module_init(ccldriver_init);
module_exit(ccldriver_exit);

