/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_common.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.


#ifndef P8021x_TYPE_H
#define P8021x_TYPE_H

typedef enum {
  apsm_Initialize,
  apsm_Disconnected,
  apsm_Connecting,
  apsm_Authenticating,
  apsm_Authenticated,
  apsm_Aborting,
  apsm_Held,
  apsm_Force_Auth,
  apsm_Force_Unauth
} AUTH_PAE_STATE;

typedef enum {
  pmt_ForceUnauthorized,
  pmt_ForceAuthorized,
  pmt_Auto,
  pmt_None
} PORT_MODE_TYPE;

typedef enum {
  pst_Unauthorized,
  pst_Authorized
} PORT_STATUS_TYPE;

typedef enum {
  basm_Request,
  basm_Response, 
  basm_Success,
  basm_Fail, 
  basm_Timeout,
  basm_Idle,
  basm_Initialize 
} BAUTH_SM_STATE;

typedef	enum {
  resm_Initialize, 
  resm_Reauthenticate
} REAUTH_SM_STATE;

#endif 
