/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_sys.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/03
// Note   : OS dependent system call
// ********************************************

#ifndef P8021x_SYS_H__
#define P8021x_SYS_H__

/******************************************************************************
SYS : SYSTEM SUPPLIED MEMORY ALLOCATION ROUTINES
*******************************************************************************/
extern Tbool p8021x_malloc(Tuint32 size, void **allocated);
extern void  p8021x_free(void *allocated);
/******************************************************************************
* SYSPDU : SYSTEM SUPPLIED PDU ACCESS PRIMITIVES
*******************************************************************************/
typedef struct sk_buff Pdu;
extern Tbool p8021x_pdu_alloc(Pdu **pdu);
extern void  p8021x_pdu_free( Pdu *pdu);
extern Tbool p8021x_pdu_tx( Pdu *pdu, int port_no);

/******************************************************************************
* UDP : UDP RELATED FUNCTION
*******************************************************************************/
extern Tbool radius_serv_socket_create(void);
extern Tbool radius_acc_socket_create(void);
extern Tbool udp_socket_release(void);
extern Tbool udp_send(Tuint16 usUdpPort,Tuint8 *paucRadPkt, Tuint16 usRadPktLen);
extern int   udp_check_rx(Pdu *rcv_pdu);

#endif

