/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_sys.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/03
// Note   : OS dependent system call
// ********************************************

#include "krnportmask.h"

#include "8021x.h"

static struct socket *serv_sock=NULL,*acc_sock=NULL;
static struct sockaddr_in serv,acc;
extern Radius_srv_info *radsrv_info;

/******************************************************************************
* SYS : SYSTEM SUPPLIED MEMORY ALLOCATION ROUTINES
*******************************************************************************/
Tbool p8021x_malloc(Tuint32 size, void **allocated)
{
 *allocated=(void *)kmalloc(size, GFP_ATOMIC);
 
 if(*allocated==NULL)
   return(False);
 else{
   memset(*allocated,0,size);
   return(True);
 }
}


void p8021x_free(void *allocated)
{
 kfree(allocated);
}

/******************************************************************************
* SYSPDU : SYSTEM SUPPLIED SOCKET BUFFER ALLOCATION ROUTINES
*******************************************************************************/
Tbool p8021x_pdu_alloc(Pdu **pdu)
{

 *pdu=dev_alloc_skb(1518);
	
 if (*pdu == NULL) 
    return(False);
 
 return(True);
}

void p8021x_pdu_free( Pdu *pdu)
{
#ifdef __LINUX_2_6_19__
#else
  skb_unlink(pdu);
#endif
  kfree_skb(pdu);
}


/******************************************************************************
* SYSPDU : SYSTEM SUPPLIED PDU READ/WRITE
*******************************************************************************/
Tbool p8021x_pdu_tx(Pdu *tx_pdu,int port_no)
{
  if( (cclmx_PortGetStpState(port_no)!=STP_PORT_FORWARDING)
    ||(cclmx_PortGetLink(port_no)==CCLMX_PORT_LINKDOWN)) {
     p8021x_pdu_free(tx_pdu);
     //printk("p8021x_pdu_tx False\n");
     return False;
   }
  
  tx_pdu->nh.raw=tx_pdu->data;
  //CCL_LP(tx_pdu)->dwDstPortMsk.ulMask[port_no/32]= 0x01<< (port_no%32);
  K_LPortMaskClrAll(&CCL_LP(tx_pdu)->dwDstPortMsk);
  K_LPortMaskSetPort(&CCL_LP(tx_pdu)->dwDstPortMsk, port_no);
  cclmx_TxPkt(tx_pdu);
  //printk("p8021x_pdu_tx True\n");

  return True; 
}



//--------------------------------------------------
// udp_check_rx:
//   UDP RX handle function.
//--------------------------------------------------
int udp_check_rx(Pdu *rcv_pdu)
{
   Tuint16 	src_port=0,eth_type=0 ;        
   Tuint8  	ip_proto;
   struct iphdr *iph=rcv_pdu->nh.iph;

#if __LINUX_2_6_19__
   eth_type = get_unaligned((unsigned short *)&(eth_hdr(rcv_pdu)->h_proto));
#else
   eth_type = get_unaligned((unsigned short *)&(rcv_pdu->mac.ethernet->h_proto));
#endif

   if(eth_type != htons(0x0800)){
      return CCL_MX_NONE;
   }

   ip_proto = get_unaligned((unsigned char *)(rcv_pdu->data+9));
   if(ip_proto != 17){
      return CCL_MX_NONE;
   }

   src_port = get_unaligned((unsigned short *)(rcv_pdu->data+ (iph->ihl*4)));
   if(src_port== htons(radsrv_info[0].usServerPort)) {//we have to handle radius pkt from radius server    
      radius_pkt_rx(rcv_pdu,NULL);
      return CCL_MX_DROP;
   }
   else if(src_port==htons(radsrv_info[0].usAuthPort)) {//we don't need to handle account response
     return CCL_MX_DROP; 
   }  
   else{
     return CCL_MX_NONE;//pass to upper layer
   }
}


int udp_msg_send(struct socket *sock,struct sockaddr_in *sockaddr, Tuint8* buf,Tuint32 len)
{
	struct msghdr msg;
	struct iovec iov;
	mm_segment_t oldfs;
	Tuint32 size = 0, space=0;

	space = sock_wspace(sock->sk);

	if(space < len){
           return size;
	}

	msg.msg_iov	 = &iov;
	msg.msg_iovlen   = 1;
	msg.msg_control  = NULL;
	msg.msg_controllen = 0;
	msg.msg_flags    = MSG_DONTWAIT | MSG_NOSIGNAL;
	msg.msg_name     = (void *)sockaddr;
	msg.msg_namelen  = sizeof(struct sockaddr_in);
	msg.msg_iov->iov_len = (__kernel_size_t)len;
	msg.msg_iov->iov_base = (char *)buf;

	oldfs = get_fs();
	set_fs(KERNEL_DS);
	size = sock_sendmsg(sock,&msg,len);
	set_fs(oldfs);
	
	return size;
}

//create kernel socket for sending udp pkt
Tbool radius_serv_socket_create(void)
{
 int    error;
 struct ifreq interface;
 mm_segment_t oldfs;

 error = sock_create(PF_INET, SOCK_DGRAM, IPPROTO_UDP, &serv_sock);

 if(error<0) {
   return False;
 }
 
 /* Now connect to the destination server */
 memset(&serv,0,sizeof(serv));
 serv.sin_family       = AF_INET;
 serv.sin_addr.s_addr  = htonl(radsrv_info[0].ipRadServer);
 serv.sin_port         = htons(radsrv_info[0].usServerPort);

 //avoid "alloc_skb called nonatomically from interrupt error"
#ifdef __LINUX_2_6_19__
 serv_sock->sk->sk_reuse = 1;
 serv_sock->sk->sk_allocation = GFP_ATOMIC;
 serv_sock->sk->sk_priority = GFP_ATOMIC;
#else
 serv_sock->sk->reuse = 1;
 serv_sock->sk->allocation = GFP_ATOMIC;
 serv_sock->sk->priority = GFP_ATOMIC;
#endif

 strncpy(interface.ifr_ifrn.ifrn_name, "eth0", IFNAMSIZ);

 oldfs = get_fs();
 set_fs(KERNEL_DS); 
 error = sock_setsockopt(serv_sock, SOL_SOCKET, SO_BINDTODEVICE, (char *) &interface, sizeof(interface));
 set_fs(oldfs);

 if(error<0) {
    return False;
 }

 error = serv_sock->ops->connect(serv_sock, (struct sockaddr*)&serv, sizeof(serv), 0);

 if(error<0) {
    return False;
 }

 return True;
}

Tbool radius_acc_socket_create(void)
{
 int    error;
 struct ifreq interface;
 mm_segment_t oldfs;

 error = sock_create(PF_INET, SOCK_DGRAM, IPPROTO_UDP, &acc_sock);

 if(error<0) {
   return False;
 }
 
 /* Now connect to the destination server */
 memset(&acc,0,sizeof(acc));
 acc.sin_family       = AF_INET;
 acc.sin_addr.s_addr  = htonl(radsrv_info[0].ipRadServer);
 acc.sin_port         = htons(radsrv_info[0].usAuthPort);

 //avoid "alloc_skb called nonatomically from interrupt error"
#ifdef __LINUX_2_6_19__
 acc_sock->sk->sk_reuse = 1;
 acc_sock->sk->sk_allocation = GFP_ATOMIC;
 acc_sock->sk->sk_priority = GFP_ATOMIC;
#else
 acc_sock->sk->reuse = 1;
 acc_sock->sk->allocation = GFP_ATOMIC;
 acc_sock->sk->priority = GFP_ATOMIC;
#endif

 strncpy(interface.ifr_ifrn.ifrn_name, "eth0", IFNAMSIZ);

 oldfs = get_fs();
 set_fs(KERNEL_DS); 
 error = sock_setsockopt(acc_sock, SOL_SOCKET, SO_BINDTODEVICE, (char *) &interface, sizeof(interface));
 set_fs(oldfs);

 if(error<0) {
    return False;
 }

 error = acc_sock->ops->connect(acc_sock, (struct sockaddr*)&acc, sizeof(acc), 0);

 if(error<0) {
    return False;
 }

 return True;
}
Tbool udp_socket_release(void)
{
 if(serv_sock!=NULL){
    sock_release(serv_sock);
    serv_sock=NULL;
 }

 if(acc_sock!=NULL){
    sock_release(acc_sock);
    acc_sock=NULL;
 }
 return True;
}


//sending udp pkt
Tbool udp_send(Tuint16 usUdpPort, Tuint8 *paucRadPkt, Tuint16 usRadPktLen)
{
 if(usUdpPort==radsrv_info[0].usServerPort){
    if(udp_msg_send(serv_sock, &serv, paucRadPkt, usRadPktLen)!=0){
	return True;
    }
 }
 else {
    if(udp_msg_send(acc_sock, &acc, paucRadPkt, usRadPktLen)!=0){
	return True;
    }
 }

 return False;
}

