/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_reauth_sm.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : 802.1x ReAuthentication State Machine
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.


#include "8021x.h"

//--------------------------------------------------
//   init function. 
//--------------------------------------------------
void rauthsm_init(Reauth_SM *reauth_sm)
{
  reauth_sm->state         = resm_Initialize;        // Not sure if I should start in the initialize state.
  reauth_sm->reAuthEnabled = True;                   // This should be set from outside later.
  reauth_sm->reAuthPeriod  = 0;     
}

//--------------------------------------------------
//   One transition and state specific inits.
//--------------------------------------------------
void trans_rauthsm(Global_Params * global)
{
  Auth_Pae  *auth_pae  = global->Auth;
  Reauth_SM *reauth_sm = global->Auth->reauth_sm;

  // Global Transitions first :
  if( (global->portControl != pmt_Auto) || global->initialize ||
		  (global->portStatus == pst_Unauthorized) || !reauth_sm->reAuthEnabled )
  {
	  reauth_sm->state = resm_Initialize;
	  auth_pae->port_timers->reAuthWhen = reauth_sm->reAuthPeriod;
	  return;
  }

  // Specific Transitions:
  if(reauth_sm->state == resm_Initialize)
  {
	  if(auth_pae->port_timers->reAuthWhen == 0)
	  {
		  reauth_sm->state = resm_Reauthenticate;
		  global->reAuthenticate = True;
		  return;
	  }

	  return;
  }

  if(reauth_sm->state == resm_Reauthenticate)
  {
	  reauth_sm->state = resm_Initialize;
	  auth_pae->port_timers->reAuthWhen = reauth_sm->reAuthPeriod;
	  return;
  }
}


