/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_radius.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : 802.1x radius related structure/function
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.

#ifndef P8021X_RADIUS_H
#define P8021X_RADIUS_H

#include "../cclmx/ccl.h"
#include "8021x_common.h"
#include "8021x_auth_pae.h"

// Radius Packet Header
struct rad_header {
    Tuint8   ucCode;
    Tuint8   ucIdentifier;
    Tuint16  usLength;
    Tuint8   aucAuthenticator[RADPKT_AUTHENTICATOR_LEN];
} ;

struct rad_attr_header {
    Tuint8   ucType;
    Tuint8   ucLength;
} ;

// radius packet info
struct rad_pkt_info {
    Tuint8   *pPkt;
    Tuint16  usPktLength;
    Tuint8   *pMessageAuthenticator;
    Tuint32  *pulNASPortType;
    struct   rad_header *prad_header;
} ;

struct rad_port_info {
    Tbool    bStatus;
    Tuint8   ucIdentifier;
    Tuint8   aucReqAuthenticator[RADPKT_AUTHENTICATOR_LEN];
    Tuint8   aucMessAuthenticator[RADPKT_AUTHENTICATOR_LEN];
    Tuint8   aucEAPMessFromSupp[RADPKT_MAX_PKT_LEN];
    Tuint8   aucEAPMessTypeFromSupp;
    Tuint16  usEAPMessLenFromSupp;
    Tuint8   aucEAPMessFromServer[RADPKT_MAX_PKT_LEN];
    Tuint8   aucEAPMessTypeFromServer;
    Tuint16  usEAPMessLenFromServer;
    Tuint8   aucUDPSendToServer[RADPKT_MAX_PKT_LEN];
    Tuint16  usUPDLenToServer;
    Tuint8   aucEAPSendToSupp[RADPKT_MAX_PKT_LEN];
    Tuint16  usEAPLenToSupp;
    Tuint8   aucUserName[RADPKT_MAX_USERNAME_LEN] ;    
    Tuint8   ucUserNameLen; 
    Tuint8   aucStateAttr[RADPKT_MAX_STATE_ATTR_LEN];
    Tbool    bStateAvailable;
    Tuint16  usStateLen;
    Tuint8   aucClassAttr[RADPKT_MAX_CLASS_ATTR_LEN];
    Tbool    bClassAvailable;
    Tuint16  usClassLen;    
    Tuint8   aucConnectInfo[RADPKT_MAX_CONNECT_INFO_LEN]; 
} ;
    
typedef struct Radius_srv_info_t {
    Tuint32  ipNas;
    Tuint32  ipRadServer;
    Tuint16  usServerPort;
    Tuint16  usAuthPort;
    Tuint8   ucIdentifier;
    Tuint8   aucShareKey[RADPKT_MAX_SHARE_KEY_LEN]; 
    Tuint8   aucNASIdentifier[RADPKT_MAX_NAS_IDENTIFIER_LEN]; 
    Tuint8   aucCalledStationID[20];
    struct   rad_port_info aucSWPort;
}Radius_srv_info ;    


// define EAP Pkt Header
struct EAPHeader_T {
    Tuint8   ucCode;		    // Identifies the type of EAP packet.
    Tuint8   ucIdentifier;	// Aids in matching responses with requests.
    Tuint16  usLen; 	    // Length of EAP packet including code, id, len
};        

// define EAP reqquest/response data header
struct EAPCodeType_T {
    Tuint8   ucType;
};


// User Accounting Structure
typedef struct Radius_acc_info_t {
    Tuint8   ucIdentifier;
    Tuint8   aucUserName[RADPKT_MAX_USERNAME_LEN] ;    
    Tuint8   ucUserNameLen;
    Tuint8   aucReqAuthenticator[RADPKT_AUTHENTICATOR_LEN];
    Tuint8   aucClass[RADPKT_MAX_CLASS_ATTR_LEN];
    Tuint8   ucClassLen;
}Radius_acc_info;


typedef struct {
    Tuint8   ucPortNo;              // which port user login in ..
    Tuint32  ulSessionId;
    Tuint32  ulSessionTime;         // the active time since authentication until link down or logoff
    Tuint32  ulStatusType;          // a lot of reasions, pls refer to radius.h
    Tuint32  ulTerminateCause;      // a lot of reasions, pls refer to radius.h
    Tuint32  ulInputOctets; 	    /* use octets as unit to record how many octets 
    				       has been received from this specified port.*/
    Tuint32  ulOutputOctets;        /* use octets as unit to record how many octets 
    				       has been transmited from this specified port.*/
    Tuint32  ulInputPkts;           /* to record how many packets has been received 
    				       from this specified port.*/
    Tuint32  ulOutputPkts;          /* to record how many packets has been transmited
    				       from this specified port.*/
}  RadAccInfo_T  ;


//int radius_info_init(int iState);
Tuint32 radius_info_init(void);
Tuint32 radius_port_info_init(Tuint8 ucPort);
Tuint32 radius_pkt_rx(Pdu *pkt, void * data);
Tuint32 radius_acc_pkt_tx(Tuint8 ucPort, RadAccInfo_T *pRadAccInfo);
Tuint32 radius_rx2eap_tx(Tuint8 *pkt);
Tuint32 eap_rx2radius_tx( Tuint8 ucPort, Auth_Pae *pAuthPae, Tuint8 *pkt);

int  p8021x_send_radius_pkt(Tuint8 *paucRadPkt, Tuint16 usRadPktLen,Tuint16 port);
void create_reqauth(Tuint8 *aucReqAuthenticator, Tbool );

struct rad_pkt_info *create_radius_common_hdr( Tuint8 *pucpkt, Tuint8 ucCode,
			Tuint8 ucIdentifier, Tuint8 *pReqAuthenticator);

void radconst_addattr( struct rad_pkt_info * pRadPkt, Tuint8 ucAttrType, 
			Tuint8 ucAttrLen, Tuint8 *pucAttrData);

void radconst_addEAPMessAttr( struct rad_pkt_info * pRadPkt, Tint16  usAttrLen, Tuint8 *pucAttrData);
void radconst_calradlength( struct rad_pkt_info * pRadPkt);
void create_messauth( struct rad_pkt_info *pRadConst, Tuint8 *pucMessAuth );
Tuint8 auth_radius_handle(Global_Params *global,Tuint8 id, Tuint8 code, Tuint16 len, Tbyte*pkt);
Tbool rad_send_acc_info(Global_Params *global,Tuint8 nType,Tuint32 nStopCause);

#endif
