/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_netfilter.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.


#ifndef P8021x_NETFILTER_H
#define P8021x_NETFILTER_H

#include "krntype.h"
#include "krndef.h"

#define P8021X_BASE_CTL		     	    64+1024+64+64+900

#define SET_8021X_ENABLE	            P8021X_BASE_CTL+1
#define SET_8021X_PORT_ENABLE		    P8021X_BASE_CTL+2
#define SET_8021X_PORT_DISABLE		    P8021X_BASE_CTL+3
#define SET_8021X_RAD_INFO                  P8021X_BASE_CTL+4
#define SET_8021X_PORT_MODE                 P8021X_BASE_CTL+5
#define SET_8021X_VAR_PORT_ENABLE           P8021X_BASE_CTL+6
#define SET_8021X_MISC_CONF                 P8021X_BASE_CTL+7
#define SET_8021X_RAD_INIT                  P8021X_BASE_CTL+8
#define P8021X_SET_MAX    	            P8021X_BASE_CTL+15


#define GET_8021X_ENABLE	            P8021X_BASE_CTL+1
#define GET_8021X_RAD_INFO                  P8021X_BASE_CTL+2
#define GET_8021X_MISC_CONF                 P8021X_BASE_CTL+3
#define GET_8021X_PORT_MODE                 P8021X_BASE_CTL+5
#define GET_8021X_PORT_TRAN_STATE           P8021X_BASE_CTL+6
#define P8021X_GET_MAX    	            P8021X_BASE_CTL+15

typedef struct {
  Tuint16 usQuietPeriod;
  Tuint16 usTxPeriod;
  Tuint16 usSuppTimeout;
  Tuint16 usServerTimeout;
  Tuint8  ucReAuthMax;
  Tuint32 ulReAuthPeriod;
} TstDot1xTimerParm;


typedef struct {
  Tuint8 ucPortId;
  PORT_MODE_TYPE ucPortMode;
} TstDot1xPortModeInfo;

typedef struct {
  Tuint8 ucPortId;
  Tuint8 ucPortState;
} TstDot1xPortStateInfo;

typedef struct {
  Tuint8 ucPortId;
  Tbool  bEnable;
} TstDot1xPortEnable;

typedef struct {
  Tuint32 ulIpNas;
  Tuint32 ulIpRadServer;
  Tuint16 usServerPort;
  Tuint16 usAuthPort;
  Tuint8  aucShareKey[RADPKT_MAX_SHARE_KEY_LEN]; 
  Tuint8  aucNASIdentifier[RADPKT_MAX_NAS_IDENTIFIER_LEN]; 
} TstDot1xRadiusInfo;

#endif
