/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/


// ********************************************
// Name   : 8021x_netfilter.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : communicate with user land program(CLI/Web)
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.

#include "krnerr.h"
#include "krndot1x.h"
#include "krnport.h"
#include "krntype.h"

#include "8021x.h"

TstDot1xPortModeInfo    init_parm;
TstDot1xRadiusInfo      rad_info;
TstDot1xTimerParm       timer_cfg={60,15,30,30,2,3600}; 
Tbool                   bDot1xEbl=0;

extern Tbyte 		dot1x_my_mac[MAC_ADDR_LEN];
extern Radius_srv_info  *radsrv_info;
extern Global_Params 	*port_sm[MAX_PORT];
extern Tbool 		bDot1xInit;

/* This function is called whenever a process tries to do setsockopt */
int do_8021x_set_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
{
 Tuint8			ucPortId = 0;
 TstDot1xPortModeInfo   pm_info;
 TstDot1xPortEnable     ve_info;
 Tuint8 		ucPhyPortId;

 switch (cmd)
 {
  // enable 802.1x protocol      
  case SET_8021X_ENABLE:
       copy_from_user(&bDot1xEbl,user,sizeof(Tbool)); 
       K_Dot1xSetEbl(bDot1xEbl);
       break;

  //set radius info
  case SET_8021X_RAD_INFO:
       copy_from_user(&rad_info,user,sizeof(rad_info));
     
       radsrv_info[0].ipRadServer = rad_info.ulIpRadServer;
       radsrv_info[0].usServerPort = rad_info.usServerPort ; 
       radsrv_info[0].usAuthPort=rad_info.usAuthPort;   
       radsrv_info[0].ipNas = htonl(rad_info.ulIpNas); //NAS IP ADDRESS
    
       snprintf(radsrv_info[0].aucCalledStationID,20,"%x%x-%x%x-%x%x-%x%x-%x%x-%x%x",dot1x_my_mac[0]>>4,dot1x_my_mac[0]&0x0F, dot1x_my_mac[1]>>4,dot1x_my_mac[1]&0x0F,dot1x_my_mac[2]>>4,dot1x_my_mac[2]&0x0F,dot1x_my_mac[3]>>4, dot1x_my_mac[3]&0x0F,dot1x_my_mac[4]>>4,dot1x_my_mac[4]&0x0F,dot1x_my_mac[5]>>4,dot1x_my_mac[5]&0x0F );     
    
       memset(radsrv_info[0].aucNASIdentifier,0x0,sizeof(radsrv_info->aucNASIdentifier));
       memcpy(radsrv_info[0].aucNASIdentifier ,rad_info.aucNASIdentifier ,strlen(rad_info.aucNASIdentifier)); 
       memset(radsrv_info[0].aucShareKey,0x0,sizeof(radsrv_info->aucShareKey));
       memcpy(radsrv_info[0].aucShareKey,rad_info.aucShareKey ,strlen(rad_info.aucShareKey)); 
       
       udp_socket_release();
       radius_serv_socket_create();
       radius_acc_socket_create();

       break;
 
  case SET_8021X_PORT_MODE:
       copy_from_user(&pm_info,user,sizeof(pm_info));  
   
       if( pm_info.ucPortId >= MAX_PORT ) {
	   break;
       }
       
       if (pm_info.ucPortMode != pmt_None) {
  	   p8021x_enable(&pm_info); 
	   port_sm[pm_info.ucPortId]->portControl = pm_info.ucPortMode;

	   ucPhyPortId = cclmx_LId2PId(pm_info.ucPortId); 
	   //printk("do_8021x_set_ctl -> K_PortSetSecurity(%d,%d)\n", ucPhyPortId, True);
	   K_PortSetSecurity(ucPhyPortId, True);
       }
       else {
           p8021x_disable(pm_info.ucPortId);
	   ucPhyPortId = cclmx_LId2PId(pm_info.ucPortId); 
	   //printk("do_8021x_set_ctl -> K_PortSetSecurity(%d,%d)\n", ucPhyPortId, False);
	   K_PortSetSecurity(ucPhyPortId, False);
       }

       break;

  case SET_8021X_VAR_PORT_ENABLE:
       copy_from_user(&ve_info,user,sizeof(ve_info));  

       if( ve_info.ucPortId >= MAX_PORT ) {
	   break;
       }

       if(port_sm[ve_info.ucPortId]!=NULL){
  	  port_sm[ve_info.ucPortId]->portEnabled = ve_info.bEnable;
       }

       break;

  case SET_8021X_MISC_CONF:
       copy_from_user(&timer_cfg,user,sizeof(timer_cfg)); 

       for(ucPortId=0; ucPortId<MAX_PORT; ucPortId++)
       {
        if(port_sm[ucPortId]!=NULL)
	{
	 // Set Variable Value : time unit = 500ms
	 port_sm[ucPortId]->Auth->quietPeriod 		   = timer_cfg.usQuietPeriod << 1;
	 port_sm[ucPortId]->Auth->txPeriod 		   = timer_cfg.usTxPeriod << 1;
	 port_sm[ucPortId]->Auth->bauth_sm->suppTimeout    = timer_cfg.usSuppTimeout << 1;
	 port_sm[ucPortId]->Auth->bauth_sm->serverTimeout  = timer_cfg.usServerTimeout << 1;
	 port_sm[ucPortId]->Auth->reAuthMax 		   = timer_cfg.ucReAuthMax << 1;
	 port_sm[ucPortId]->Auth->reauth_sm->reAuthPeriod  = timer_cfg.ulReAuthPeriod << 1;

	 // reinitial state machine
	 port_sm[ucPortId]->initialize = True; 
	}
       }
       break;
   
   
  case SET_8021X_RAD_INIT:
       radius_info_init();
       break;

 }//switch
 return KRN_RET_OK;
}


/* This function is called whenever a process tries to do getsockopt */
int do_8021x_get_ctl(struct sock *sk, int cmd, void *user, int *len)
{
 TstDot1xPortModeInfo 	 pm_info;
 TstDot1xPortStateInfo   ps_info;
 
 switch (cmd)
 {
  case GET_8021X_ENABLE:
       copy_to_user(user,&bDot1xEbl,sizeof(Tbool));    
       break;
  
  case GET_8021X_RAD_INFO:
       copy_to_user(user,&rad_info,sizeof(rad_info));    
       break;
  
  case GET_8021X_MISC_CONF:
       copy_to_user(user,&timer_cfg,sizeof(timer_cfg));
       break;
       
  case GET_8021X_PORT_MODE:
       copy_from_user(&pm_info,user,sizeof(pm_info));  
    
       if( pm_info.ucPortId >= MAX_PORT ) {
	   pm_info.ucPortMode = pmt_None;
       }
       else if(port_sm[pm_info.ucPortId]!=NULL) {
         pm_info.ucPortMode = port_sm[pm_info.ucPortId]->portControl;
       }else {
         pm_info.ucPortMode = pmt_None;
       }

       copy_to_user(user,&pm_info,sizeof(pm_info));
       break;
       
  case GET_8021X_PORT_TRAN_STATE:
       copy_from_user(&ps_info,user,sizeof(ps_info));  
       
       if( ps_info.ucPortId >= MAX_PORT ) {
	   ps_info.ucPortState = apsm_Initialize;
       }
       else if(port_sm[ps_info.ucPortId]==NULL){
          ps_info.ucPortState = apsm_Initialize;
       }else { 
          ps_info.ucPortState = port_sm[ps_info.ucPortId]->Auth->state;
       }

       copy_to_user(user,&ps_info,sizeof(ps_info));    
       break;

  default:
	break;
 }
 return KRN_RET_OK;
}


// Do anything you want before system reboot... 
int dot1x_reboot_notifier(struct notifier_block *nb, unsigned long val, void *v) 
{ 
 Tuint8 ucPortId=0;

 for(ucPortId=0;ucPortId<MAX_PORT;ucPortId++)
  {
   if(port_sm[ucPortId]!=NULL)
   {
    //for reboot, Send Account Stop
    if( port_sm[ucPortId]->Auth->portMode == pmt_Auto &&
       port_sm[ucPortId]->portStatus == pst_Authorized) {
	    rad_send_acc_info(port_sm[ucPortId],RADPKT_ACC_STATUS_STOP,RADPKT_ACC_TERM_NASREBOOT);
    }//if
   
    p8021x_disable(ucPortId);
   
   }//if
  }//for
  
 return NOTIFY_OK; 
} 
 
struct notifier_block dot1x_notifier_block = { 
	dot1x_reboot_notifier, NULL, 0 
}; 

struct nf_sockopt_ops p8021x_sockopts = {
	{ NULL, NULL }, PF_INET,
	P8021X_BASE_CTL, P8021X_SET_MAX+1, do_8021x_set_ctl, NULL,
	P8021X_BASE_CTL, P8021X_GET_MAX+1, do_8021x_get_ctl, NULL
};
