/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_module.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/03
// Note   : 802.1x  module init function
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.

#include "krnmac.h"
#include "krnsys.h"
#include "krntype.h"

#include "8021x.h"

Tbyte dot1x_my_mac[MAC_ADDR_LEN];
Tbyte eap_mac[MAC_ADDR_LEN]={0x01,0x80,0xc2,0x00,0x00,0x03};
Tbyte mask[MAC_ADDR_LEN]={0xff,0xff,0xff,0xff,0xff,0xff};
Radius_srv_info *radsrv_info;
Radius_acc_info *radacc_info;

extern struct nf_sockopt_ops p8021x_sockopts;
extern struct notifier_block dot1x_notifier_block;
extern Global_Params *port_sm[MAX_PORT];


static int __init p8021x_init(void)
{
  Tuint8 ucPortId=0;
    
  K_SysGetMac(dot1x_my_mac);

  if(!p8021x_malloc(sizeof(Radius_srv_info)*MAX_PORT,(void **)&radsrv_info)){
    printk(" 802.1x : init fail\n");
    return (False);
  }
 
  if(!p8021x_malloc(sizeof(Radius_acc_info)*MAX_PORT,(void **)&radacc_info)){
    printk(" 802.1x : init fail\n");
    return (False);
  }
 
  for(ucPortId=0;ucPortId<MAX_PORT;ucPortId++)
  {
    port_sm[ucPortId]=NULL;
  }

  if(nf_register_sockopt(&p8021x_sockopts))
  {
    printk(" 802.1x: nf_register_sockopt...fail \n");
    return (False);
  }
  
  if(register_reboot_notifier(&dot1x_notifier_block))
  {
   printk(" 802.1x: register_reboot_notifier error ");
   return (False);
  } 

  ccl_mx_register(eap_mac,mask,eapol_rx_handler);

  return 0;

}

static void __exit p8021x_exit(void)
{
 printk("Leaving 802.1x Protocol... \n");

 nf_unregister_sockopt(&p8021x_sockopts);
 unregister_reboot_notifier(&dot1x_notifier_block); 
 ccl_mx_unregister(eap_mac,mask);
}

module_init(p8021x_init);
module_exit(p8021x_exit);
