/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_eapol.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : 802.1x eapol related structure/function
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.


#ifndef P8021X_EAPOL__H
#define P8021X_EAPOL__H

struct eapol_pkt
{
  Tuint8   protocol_version; 
  Tuint8   packet_type;		// This makes it odd in number ! 
  Tuint16  packet_body_length; 

  Tuint8   code;	// Identifies the type of EAP packet. 
  Tuint8   identifier;	// Aids in matching responses with requests. 
  Tuint16  length; 	// Length of EAP packet including code, id, len, data fields 
  Tuint8   type; 
};


extern int   eapol_rx_handler(Pdu *rcv_pdu);
extern Tbool eapol_tx_handler(Tuint8 nPortId, Tbyte *buf, Tuint16 size);

#endif
