/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_eapol.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : 802.1x eapol related function
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.


#include "8021x.h"

extern Tbyte dot1x_my_mac[MAC_ADDR_LEN];
extern Tbyte eap_mac[MAC_ADDR_LEN];
extern Global_Params *port_sm[MAX_PORT];
extern Radius_srv_info *radsrv_info;


// processing eapol pkt
Tuint8 auth_eapol_handle(Global_Params *global,Pdu *rcv_pdu)
{
	Auth_Pae         *auth_pae = global->Auth;
	Tbyte            *pkt_buf  = (Tbyte*) rcv_pdu->data;
	Tuint32           pkt_len  = rcv_pdu->tail - rcv_pdu->data;
	struct eapol_pkt *eapol    = NULL;

	eapol = (struct eapol_pkt*) pkt_buf;

	if(pkt_len <= (X_EAPOL_HDRLEN)) 
	{
		return KRN_RET_ERR_DOT1X_SMALL_PKT;
	}
	
	switch(eapol->packet_type)
	{
	case X_EAPOL_LOGOFF:
		auth_pae->eapLogoff = True;
		break;

	case X_EAPOL_START:

		auth_pae->eapStart = True;
            
	        //when switch receive EAP-START, clear username for the port
		//and don't send state attr in the next access-request message

                memset( radsrv_info[global->nPortId].aucSWPort.aucUserName, 0x0, RADPKT_MAX_USERNAME_LEN );
                radsrv_info[global->nPortId].aucSWPort.ucUserNameLen = 0;
                break;

	case X_EAPOL_EAPPKT:

		//check identify
		if(global->currentId != eapol->identifier )
		{
 		  return KRN_RET_ERR_DOT1X_IDENTITY_NOTMATCH;
		}

		//check eap packet code
		if(eapol->code == X_EAP_RESPONSE) 
		{						
			Tuint16 eap_len = ntohs(eapol->packet_body_length);

                        if(eap_len > ETHER_MAXSIZE)
			{
                          return KRN_RET_ERR_DOT1X_VALUE_INVALID;
			}
			   
			//check eap packet type
			if(eapol->type == X_EAP_RRIDENTITY)
			{
		  	 // Response/Identify 
			 auth_pae->rxRespId = True;								
			}
			else if(eapol->type == X_EAP_RRMD5)
			{
			 // Response/MD5-Challenge
			 auth_pae->bauth_sm->rxResp = True;				
			}

                      
			else if(eapol->type == X_EAP_RRTLS)
			{
			 // Response/Client Hello
			 auth_pae->bauth_sm->rxResp = True;				
			}


			else if(eapol->type == X_EAP_RRPEAP)
			{
			 auth_pae->bauth_sm->rxResp = True;				
			}

			else if(eapol->type == X_EAP_RRTTLS)
			{
		 	 auth_pae->bauth_sm->rxResp = True;				
			}
			
			else if(eapol->type == X_EAP_RRNAK)
			{
			 // Response/Client Nak
			 auth_pae->bauth_sm->rxResp = True;				
			}

			else {
		  	 break;
                        }
			 
			//update length for different size
                        memcpy(auth_pae->fromsupp.pkt,pkt_buf+X_EAPOL_HDRLEN,eap_len); 
			auth_pae->fromsupp.length = eap_len;
			auth_pae->fromsupp.valid = 1;
		}
		break;						
	}
	return KRN_RET_OK;
}

//--------------------------------------------------
//   EAP: EAPOL message rx handler 
//--------------------------------------------------
int eapol_rx_handler(Pdu *rcv_pdu)
{
  Tuint8  index = CCL_LP(rcv_pdu)->bySrcPortId;
#if __LINUX_2_6_19__
  Tuint16 ether_type=ntohs(eth_hdr(rcv_pdu)->h_proto);
#else
  Tuint16 ether_type=ntohs(rcv_pdu->mac.ethernet->h_proto);
#endif
  Tbyte   supplicant_mac[MAC_ADDR_LEN];  
      
#if __LINUX_2_6_19__
  memcpy( supplicant_mac, eth_hdr(rcv_pdu)->h_source, MAC_ADDR_LEN);
#else 
  memcpy( supplicant_mac, rcv_pdu->mac.ethernet->h_source, MAC_ADDR_LEN);   
#endif

  //eapol packet will not be received from trunk port  
  if(index >= MAX_PORT) {
     return CCL_MX_DROP;
  }

  if( port_sm[index] != NULL)
    {
     if( ether_type == ETHER_EAPOL_TYPE) //EAPOL : eth_type=0x888E					
       {
	 //update calling id attribute	
	 sprintf( (port_sm[index]->Auth)->calling_id,"%x%x-%x%x-%x%x-%x%x-%x%x-%x%x",supplicant_mac[0]>>4,
		 supplicant_mac[0]&0x0F, supplicant_mac[1]>>4,supplicant_mac[1]&0x0F,supplicant_mac[2]>>4,
		 supplicant_mac[2]&0x0F,supplicant_mac[3]>>4, supplicant_mac[3]&0x0F, supplicant_mac[4]>>4,
		 supplicant_mac[4]&0x0F,supplicant_mac[5]>>4,supplicant_mac[5]&0x0F );
         
        auth_eapol_handle(port_sm[index],rcv_pdu);
       }
   }

return CCL_MX_DROP;
}

//--------------------------------------------------
//   EAP: EAPOL message tx function
//--------------------------------------------------
Tbool eapol_tx_handler(Tuint8 nPortId, Tbyte *buf, Tuint16 size)
{
   Tuint16 eth_type  = htons(ETHER_EAPOL_TYPE);
   Tbool   tx_result = False;
   Pdu     *pdu;

   if (p8021x_pdu_alloc(&pdu))
      {
        memcpy(skb_put(pdu,MAC_ADDR_LEN),eap_mac ,MAC_ADDR_LEN);        //Dest_mac
        memcpy(skb_put(pdu,MAC_ADDR_LEN),dot1x_my_mac, MAC_ADDR_LEN);   //Src_mac
        memcpy(skb_put(pdu,2),&eth_type,2);				//eth_type
        memcpy(skb_put(pdu,size),buf,size);              		//message body
        tx_result =  p8021x_pdu_tx(pdu, nPortId);           
      }

   return tx_result; 
}

