/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
// ********************************************
// Name   : 8021x_def.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// ********************************************

#ifndef P8021X_DEFINE_H
#define P8021X_DEFINE_H

// common macro definition
#define INC(X)	      do { (X) = (X) + 1; if (X > 255) X = 0; }while(0)
#define DEC(X)        do { if(X != 0) X--; } while(0)

// Radius Service Type Attribute
#define RADPKT_ATTR_STYPE_FRAMED       (2)

// Radius Port Type Attribute
#define RADPKT_ATTR_PTYPE_ETHERNET     (15)

// Radius Attribute: Accounting authentication  
#define RADPKT_ACC_AUTH_RADIUS	       (1)
#define RADPKT_MAX_PKT_LEN             (1400)
#define RADPKT_PKT_HEADER_LEN          (20)
#define RADPKT_ATTR_HEAD_LEN           (2)
#define RADPKT_AUTHENTICATOR_LEN       (16)
#define RADPKT_MAX_SHARE_KEY_LEN       (30)
#define RADPKT_MAX_NAS_IDENTIFIER_LEN  (30)
#define RADPKT_MAX_CONNECT_INFO_LEN    (30)
#define RADPKT_MAX_STATE_ATTR_LEN      (100)
#define RADPKT_MAX_CLASS_ATTR_LEN      (100)
#define RADPKT_MAX_EAP_ATTR_LEN        (253)
#define RADPKT_MAX_USERNAME_LEN        (32)
#define RADPKT_MAX_CALLED_ID_LEN       (17)
#define RADPKT_MAX_CALLING_ID_LEN      (17)


/* Packet Type */
#define RADPKT_TYPE_ACCESS_REQUEST     (1)
#define RADPKT_TYPE_ACCESS_ACCEPT      (2)
#define RADPKT_TYPE_ACCESS_REJECT      (3)
#define RADPKT_TYPE_ACC_REQUEST        (4)
#define RADPKT_TYPE_ACC_RESPONSE       (5)
#define RADPKT_TYPE_ACCESS_CHALLENGE   (11)

/* RADIUS attribute : Ref to RFC 2138 */   
#define RADPKT_ATTR_USER_NAME          (1)
#define RADPKT_ATTR_PASSWORD           (2)
#define RADPKT_ATTR_NAS_IP_ADDRESS     (4)
#define RADPKT_ATTR_NAS_PORT           (5)
#define RADPKT_ATTR_SERVICE_TYPE       (6)
#define RADPKT_ATTR_FRAME_PROTOCOL     (7)
#define RADPKT_ATTR_FRAME_MTU          (12)
#define RADPKT_ATTR_REPLY_MESSAGE      (18)
#define RADPKT_ATTR_STATE              (24)
#define RADPKT_ATTR_CLASS              (25)
#define RADPKT_ATTR_SESSION_TIMEOUT    (27)
#define RADPKT_ATTR_IDLE_TIMEOUT       (28)
#define RADPKT_ATTR_TERMINATION_ACTION (29)
#define RADPKT_ATTR_CALLED_STID        (30)
#define RADPKT_ATTR_CALLING_STID       (31)
#define RADPKT_ATTR_NAS_IDENTIFIER     (32)
#define RADPKT_ATTR_NAS_PORT_TYPE      (61)
#define RADPKT_ATTR_CONNECT_INFO       (77)
#define RADPKT_ATTR_EAP_MESSAGE        (79) 
#define RADPKT_ATTR_MESSAGE_AUTH       (80)
#define RADPKT_ATTR_INTERVAL	       (85)

/* RADIUS Account Attribute */
#define RADPKT_ACC_ATTR_STATUS_TYPE	(40)
#define RADPKT_ACC_ATTR_DELAY_TIME	(41)
#define RADPKT_ACC_ATTR_INPUT_OCTETS	(42)
#define RADPKT_ACC_ATTR_OUTPUT_OCTETS	(43)
#define RADPKT_ACC_ATTR_SESSION_ID	(44)
#define RADPKT_ACC_ATTR_AUTHENTIC	(45)
#define RADPKT_ACC_ATTR_SESSION_TIME	(46)
#define RADPKT_ACC_ATTR_INPUT_PKTS	(47)
#define RADPKT_ACC_ATTR_OUTPUT_PKTS	(48)
#define RADPKT_ACC_ATTR_TM_COUSE	(49)
#define RADPKT_ACC_ATTR_MSESSION_ID	(50)

// Raidus Accounting status type Attribute
#define RADPKT_ACC_STATUS_START        (1)
#define RADPKT_ACC_STATUS_STOP	       (2)
#define RADPKT_ACC_STATUS_UPDATE       (3)
#define RADPKT_ACC_STATUS_ACCONT       (4)
#define RADPKT_ACC_STATUS_ACCOFF       (5)
 
// Radius Attribute: Accounting Terminate Reason
#define RADPKT_ACC_TERM_USERREQ		(1)
#define RADPKT_ACC_TERM_LOSTCARRIER	(2)
#define RADPKT_ACC_TERM_LOSTSERVICE	(3)
#define RADPKT_ACC_TERM_IDLEOUT		(4)
#define RADPKT_ACC_TERM_SESSIONOUT	(5)
#define RADPKT_ACC_TERM_ADMINRESET	(6)
#define RADPKT_ACC_TERM_ADMINREBOOT	(7)
#define RADPKT_ACC_TERM_PORTERROR	(8)
#define RADPKT_ACC_TERM_NASERROR	(9)
#define RADPKT_ACC_TERM_NASREQ		(10)
#define RADPKT_ACC_TERM_NASREBOOT	(11)
#define RADPKT_ACC_TERM_PTUNNEEDED	(12)
#define RADPKT_ACC_TERM_PTPREEMPTED	(13)
#define RADPKT_ACC_TERM_PTSUSPENDED	(14)
#define RADPKT_ACC_TERM_SERVICEUNAV	(15)
#define RADPKT_ACC_TERM_CALLBACK	(16)
#define RADPKT_ACC_TERM_USERERROR	(17)
#define RADPKT_ACC_TERM_HOSTREQ		(18)


#define ETHER_MINSIZE        64 
#define ETHER_MAXSIZE        1496 //1518-L2_HDR(18)-EAP_Ver(1)-EAP_Type(1)-EAP_Len(2)
#define ETHER_HDRLEN         14 
#define ETHER_EAPOL_TYPE     0x888E 
 
#define X_EAPOL_VER          1
#define X_EAPOL_HDRLEN       4

#define X_EAP_RRLEN	     1 
#define	X_EAP_HDRLEN	     4 
 
#define X_EAPOL_EAPPKT	     0 
#define X_EAPOL_START	     1 
#define	X_EAPOL_LOGOFF	     2 
 
#define	X_EAP_REQUEST	     1 
#define X_EAP_RESPONSE	     2 
#define X_EAP_SUCCESS	     3 
#define X_EAP_FAILURE	     4 
 
#define X_EAP_RRIDENTITY     1 
#define X_EAP_RRNAK	     3 
#define X_EAP_RRMD5	     4 
#define X_EAP_RRTLS	    13
#define X_EAP_RRTTLS        21
#define X_EAP_RRPEAP        25

 

// define EAP Pkt Type     
#define EAP_CODE_REQUEST            (1)
#define EAP_CODE_RESPONSE           (2)
#define EAP_CODE_SUCCESS            (3)
#define EAP_CODE_FAILURE            (4)

// define EAP Request/Response Type
#define EAP_RR_TYPE_IDENTITY        (1)
#define EAP_RR_TYPE_NOTIFICATION    (2)
#define EAP_RR_TYPE_NAK             (3)
#define EAP_RR_TYPE_MD5_CHALLENGE   (4)
#define EAP_RR_TYPE_OTP             (5)
#define EAP_RR_TYPE_TOKEN_CARD      (6)
#define EAP_RR_TYPE_TLS             (13)
#define EAP_RR_TYPE_TTLS            (21)
#define EAP_RR_TYPE_PEAP            (25)

#endif
