/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : 8021x_bauth_sm.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : 802.1x Bauth State Machine
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.


#ifndef  P8021X_BAUTH_SM_H
#define  P8021X_BAUTH_SM_H 

#include "8021x_common.h" 


typedef struct Bauth_SM_tag
{
  BAUTH_SM_STATE	state;

  Tbool	   rxResp;       // if a EAPOL PDU of type EAP packet rcvd from supp 
  			 // carrying a Request

  Tbool	   aSuccess; 	 // if Accept pkt recvd from Auth Server
  Tbool    aFail;	 // true if reject pkt rcvd from auth svr.
  Tbool	   aReq;	 // true if eap req pkt rcvd frm auth svr.
  
  int	   reqCount;     // A counter used to determine how many EAP Request 
  			 // packets have been sent to the Supplicant without 
  		 	 // receiving a response.
			 
  int	   idFromServer; // most recent EAP success, failure or req pkt rcvd 
 			 // frm auth svr.

  int      suppTimeout;
  int	   serverTimeout;
  int	   maxReq; 

} Bauth_SM;

// The functions exported.
void bauthsm_init(Bauth_SM *bauth_sm);
Tbool trans_bauthsm(Global_Params *global); 

// Some funtion prototype decls
void bauthsm_initialize(Global_Params *global);
void bauthsm_request(Global_Params *global);
void bauthsm_response(Global_Params *global);
void bauthsm_success(Global_Params *global);
void bauthsm_fail(Global_Params *global);
void bauthsm_timeout(Global_Params *global);
void bauthsm_idle(Global_Params *global);

// Protocol Procedures
Tuint8 bauthsm_txReq(Global_Params *global);
Tuint8 bauthsm_sendRespToServer(Global_Params *global);
void  bauthsm_abortAuth(Global_Params *global);
 
#endif 
