/***************************************************************************
*
*  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
*
*  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
*  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
*  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
*  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
*
*  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
*  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
*  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
*  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
*
***************************************************************************/

// ********************************************
// Name   : 8021x_auth_pae.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : 802.1x Port Access Entity 
// ********************************************
// Programmer   : Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.


#ifndef P8021X_AUTH_PAE_H
#define P8021X_AUTH_PAE_H

#include "8021x_sys.h"
#include "8021x_bauth_sm.h"
#include "8021x_reauth_sm.h"


struct pktbuf
{
	Tuint8     pkt[2000];
	Tbool	   valid;       //pktbuf have packet content?
	Tuint16    length;	//len of received pkt 
	Tuint8     eap_code;
	Tuint8     eap_id;
	Tuint8     eaprr_type;   // = 255 if not valid i.e. the EAP packet is not a request/response pkt
};


typedef struct pt_sm
{ 
	int aWhile;
		// timer used by backend auth state machine. 
	int quietWhile;
		// timer used by auth sm during which it does not acquire a supp.
	int reAuthWhen;
		// reauthentication timer state machine = reAuthPeriod.
	int txWhen;
		// used by auth sm 
} PT_SM; 

typedef struct Auth_Pae_tag
{
	// The machine state
	AUTH_PAE_STATE	state;
  
	// The Variables.
	Tbool		eapLogoff;
	Tbool		eapStart;
	Tuint8		reAuthCount;
	Tbool		rxRespId;
        Tuint8          calling_id[20];

	// The constants
	Tuint16		quietPeriod; // 0-65535
	Tuint8		reAuthMax;   
	Tuint16		txPeriod;    // 1-65535
	 

	// A listing of the other state machines we are going to use.
	// TODO something about the port timers machine.
	PT_SM		*port_timers;

	// Reauthentication Timer State Machine
	Reauth_SM 	*  reauth_sm;

	// Backend Authentication State Machine
	Bauth_SM	*  bauth_sm;

	PORT_MODE_TYPE  portMode;
	
	struct pktbuf fromsupp; // buffers of length one to store latest packet from
	struct pktbuf fromsvr; 	// supplicant / server
 
} Auth_Pae;



// Now the function declarations follow: 

// State Process Function
Tuint8 auth_init(Global_Params *global);
void  auth_timer_check(Global_Params *global);
void  auth_state_check(Global_Params *global);

Tbool trans_authsm(Global_Params *global);
void authsm_initialize(Global_Params *global);
void authsm_force_auth(Global_Params *global);
void authsm_force_unauth(Global_Params *global);
void authsm_disconnected(Global_Params *global);
void authsm_connecting(Global_Params * global);
void authsm_authenticated(Global_Params * global);
void authsm_authenticating(Global_Params * global);
void authsm_aborting(Global_Params * global);
void authsm_held(Global_Params * global);


// packet xmit routines.
int auth_txCannedSuccess(Global_Params *global); 
int auth_txCannedFail(Global_Params *global); 
void auth_txReqId(Global_Params *global); 

#endif 
