/***************************************************************************
*
*  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
*
*  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
*  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
*  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
*  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
*
*  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
*  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
*  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
*  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
*
***************************************************************************/

// ********************************************
// Name   : 8021x_auth.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/12/04
// Note   : 802.1x port enable/disable
// ********************************************
// Programmer	: Arunesh Mishra
// Copyright (c) Arunesh Mishra 2002
// All rights reserved.
// Maryland Information and Systems Security Lab
// University of Maryland, College Park.

#include "krnerr.h"
#include "krnport.h"

#include "8021x.h"

Global_Params 		  *port_sm[MAX_PORT];
struct timer_list 	  tEntry;
Tbool 			  bDot1xInit = False;

extern Tbyte 		  dot1x_my_mac[MAC_ADDR_LEN];
extern Tbyte 		  mask[MAC_ADDR_LEN];
extern TstDot1xTimerParm  timer_cfg;

void reset_to_init_state( Global_Params *global)
{

   global->Auth->state = apsm_Initialize;
  
   // Init global variable
   global->authAbort      = False;
   global->authStart      = False;
   global->authTimeout    = False;
   global->authSuccess    = False;
   global->authFail       = False;
   global->initialize     = False;
   global->currentId      = 0;
   global->portEnabled    = True;
   global->reAuthenticate = False;
   global->portStatus     = pst_Unauthorized;
   global->suppStatus	  = pst_Unauthorized;

   //for 802.1x account msg
   global->dwSessId    = 0;
   global->dwSessTime  = 0;
   global->dwSessRxOct = 0;
   global->dwSessRxPkt = 0;
   global->dwSessTxOct = 0;
   global->dwSessTxPkt = 0;

}


//--------------------------------------------------
//   Port x enable 802.1x
//--------------------------------------------------
Tuint8 p8021x_enable( TstDot1xPortModeInfo *parm )
{

   Global_Params *global;
   static char	 mask[MAC_ADDR_LEN]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

   if(port_sm[parm->ucPortId]==NULL) {
   
   if(!p8021x_malloc(sizeof(Global_Params),(void **)&global))
      return KRN_RET_ERR_DOT1X_AUTH_INIT;

   port_sm[parm->ucPortId] = global;
   global->nPortId  = parm->ucPortId;
	
   // Init global variable
   global->authAbort      = False;
   global->authStart      = False;
   global->authTimeout    = False;
   global->authSuccess    = False;
   global->authFail       = False;
   global->initialize     = False;
   global->currentId      = 0;
   global->portControl    = parm->ucPortMode;
   global->portEnabled    = True;
   global->reAuthenticate = False;
   global->portStatus     = pst_Unauthorized;
   global->suppStatus	  = pst_Unauthorized;

   // Init Authenticator
   if(auth_init(global)!=KRN_RET_OK)
     {
	p8021x_free(port_sm[parm->ucPortId]);
        port_sm[parm->ucPortId]=NULL;
        return KRN_RET_ERR_DOT1X_AUTH_INIT;
     }

   if(!bDot1xInit)
     {
      bDot1xInit = True;
		
      init_timer(&tEntry);
      tEntry.expires = jiffies + HZ/2;
      tEntry.data=0;
      tEntry.function = sm_timer_check;
      add_timer(&tEntry);
  
      ccl_mx_register(dot1x_my_mac,mask, udp_check_rx);
     }

     //Set 802.1x configure parameter
     global->Auth->quietPeriod             = timer_cfg.usQuietPeriod << 1;
     global->Auth->txPeriod                = timer_cfg.usTxPeriod << 1;
     global->Auth->reAuthMax               = timer_cfg.ucReAuthMax << 1;
     global->Auth->reauth_sm->reAuthPeriod = timer_cfg.ulReAuthPeriod << 1;
     global->Auth->bauth_sm->suppTimeout   = timer_cfg.usSuppTimeout << 1;
     global->Auth->bauth_sm->serverTimeout = timer_cfg.usServerTimeout << 1;

     //for 802.1x account msg
     global->dwSessId 	 = 0;
     global->dwSessTime  = 0;
     global->dwSessRxOct = 0;
     global->dwSessRxPkt = 0;
     global->dwSessTxOct = 0;
     global->dwSessTxPkt = 0;
     global->bReady	 = True;

   }
   
   return KRN_RET_OK;
}

//--------------------------------------------------
//   port x disable 802.1x
//--------------------------------------------------
Tuint8 p8021x_disable(Tuint8 ucPortId)
{
  if(port_sm[ucPortId]!=NULL)
    {
	port_sm[ucPortId]->bReady = False;

        p8021x_free(port_sm[ucPortId]->Auth->bauth_sm);
	p8021x_free(port_sm[ucPortId]->Auth->port_timers);
	p8021x_free(port_sm[ucPortId]->Auth->reauth_sm);

	p8021x_free(port_sm[ucPortId]->Auth);
	p8021x_free(port_sm[ucPortId]);
        port_sm[ucPortId]=NULL;
    }
    
   return KRN_RET_OK;
}

//--------------------------------------------------
//  Timer function for 802.1x protocol State Machine.
//--------------------------------------------------
int sm_timer_check(Tuint32 unused)
{
  Tuint8 port_no=0,port_count=0, phy_port=0;
  static Tuint8 acc_pkt_sent[MAX_PORT];

  for(port_no=0,port_count=0;port_no<MAX_PORT;port_no++)
     {
      if(port_sm[port_no]!=NULL && port_sm[port_no]->bReady)
        {
	  if (cclmx_PortGetLink(port_no)==CCLMX_PORT_LINKUP) {
	      auth_timer_check(port_sm[port_no]);
	      auth_state_check(port_sm[port_no]);
	      acc_pkt_sent[port_no]=0;
	  }
	  else { //link down
	     // Send Account Stop
	     if( port_sm[port_no]->Auth->portMode == pmt_Auto &&
		 port_sm[port_no]->portStatus == pst_Authorized && acc_pkt_sent[port_no]==0) {
	
	         phy_port = cclmx_LId2PId(port_no);
		 //printk("sm_timer_check -> ");
		 K_PortSetSecurity(phy_port, True);

		 rad_send_acc_info(port_sm[port_no],RADPKT_ACC_STATUS_STOP,RADPKT_ACC_TERM_LOSTCARRIER);
		 acc_pkt_sent[port_no]=1;           
	     }

	     //when link become down, back to initial state
	     reset_to_init_state(port_sm[port_no]);
	  }
	}  
      else //port x disable 802.1x
      {
	 port_count++;
      }
     }//for

  //all ports not enable 802.1x
  if(port_count==MAX_PORT)
  {
    bDot1xInit = False;
    ccl_mx_unregister(dot1x_my_mac,mask); //un-register udp rx handler
  }
  else
  {
    init_timer(&tEntry);
    tEntry.expires = jiffies + HZ/2;
    add_timer(&tEntry);
  }
  return 0;

}

