#include <linux/init.h>
#include <asm/system.h>
#include <linux/sched.h>
#include <linux/socket.h>
#include <linux/net.h>
#include <linux/un.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/config.h>
#include <linux/ctype.h>
#include <linux/module.h>
#include <linux/netfilter.h>
#include <linux/ip.h>
#include <net/ip.h>
#include <net/tcp.h>
#include <net/route.h>
#include <linux/netfilter_ipv4/ip_conntrack_helper.h>
#include <linux/netfilter_ipv4/ip_conntrack_core.h>
#include <linux/skbuff.h>
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/if.h>
#include <linux/spinlock.h>
#include <linux/inetdevice.h>
#ifdef CONFIG_BRIDGE_NETFILTER
#include <linux/netfilter_bridge.h>
#endif

#if 0
#include "../../bridge/br_private.h"  //for br_get_all_addr
#endif

/*
	notice: if you want change the redirect or Mac information , 
		you must turn off enableForce, after you set, you 
		can tuen on the enableForce, or race may be happen
*/

MODULE_LICENSE("GPL");
MODULE_AUTHOR("huanghongbo <huanghongbo@twsz.com>");
MODULE_DESCRIPTION("foce portal module");
#if 0
#define DEBUGP printk
#define DUMP_CONTENT(dptr, length) \
	{\
	  int i;\
	  DEBUGP("\n*************************DUMP***********************\n");\
	  for (i=0;i<length;i++)\
	    DEBUGP("%c",dptr[i]);\
	  DEBUGP("*************************DUMP OVER******************\n");\
	}
#define DUMP_TUPLE_TCP(tp) \
	DEBUGP("tuple(tcp) %p: %u %u.%u.%u.%u:%u -> %u.%u.%u.%u:%u\n",	\
	       (tp), (tp)->dst.protonum,				\
	       NIPQUAD((tp)->src.ip), ntohs((tp)->src.u.tcp.port),		\
	       NIPQUAD((tp)->dst.ip), ntohs((tp)->dst.u.tcp.port))
#else
#define DEBUGP(format, args...)
#define DUMP_CONTENT(dptr, length) 
#define DUMP_TUPLE_TCP(tp) 
#endif

#define HTTP_PORT 80
/* This is slow, but it's simple. --RR */
static char http_buffer[16384];

static char LanIP[50] ;

char* pszHttpRedirectHead = 
	"HTTP/1.1 302 Object Moved\r\n"
	"Location: http://%s/landingpage.asp\r\n"
	"Server: adsl-router-gateway\r\n"
	"Content-Type: text/html\r\n"
	"Content-Length: %d\r\n"
	"\r\n"
	"%s";
char* pszHttpRedirectContent = 
	"<html><head><title>Object Moved</title></head>"
	"<body><h1>Object Moved</h1>This Object may be found in "
	"<a HREF=\"http://%s/landingpage.asp\">here</a>.</body><html>";
	
DEFINE_SPINLOCK(guest_dev_list_lock);
#define LOCK_BH(l) spin_lock_bh(l)
#define UNLOCK_BH(l) spin_unlock_bh(l)


//static ushort http_port_array[MAX_LIST_SIZE] = { [0 ... (MAX_LIST_SIZE -1)] = 0 };


static inline struct rtable *route_reverse(struct sk_buff *skb, int hook)
{
        struct iphdr *iph = skb->nh.iph;
        struct dst_entry *odst;
        struct flowi fl = {};
        struct rtable *rt;

        /* We don't require ip forwarding to be enabled to be able to
         * send a RST reply for bridged traffic. */
        if (hook != NF_IP_FORWARD
#ifdef CONFIG_BRIDGE_NETFILTER
            || (skb->nf_bridge && skb->nf_bridge->mask & BRNF_BRIDGED)
#endif
           ) {
                fl.nl_u.ip4_u.daddr = iph->saddr;
                if (hook == NF_IP_LOCAL_IN)
                        fl.nl_u.ip4_u.saddr = iph->daddr;
                fl.nl_u.ip4_u.tos = RT_TOS(iph->tos);

                if (ip_route_output_key(&rt, &fl) != 0)
                        return NULL;
        } else {
                /* non-local src, find valid iif to satisfy
                 * rp-filter when calling ip_route_input. */
                fl.nl_u.ip4_u.daddr = iph->daddr;
                if (ip_route_output_key(&rt, &fl) != 0)
                        return NULL; 

                odst = skb->dst;
                if (ip_route_input(skb, iph->saddr, iph->daddr,
                                   RT_TOS(iph->tos), rt->u.dst.dev) != 0) {
                        dst_release(&rt->u.dst);
                        return NULL;
                }
                dst_release(&rt->u.dst);
                rt = (struct rtable *)skb->dst;
                skb->dst = odst;
        }
 
      if (rt->u.dst.error) {
                dst_release(&rt->u.dst);
                rt = NULL;
        }

        return rt;
}


static int line_str_len(const char *line, const char *limit)
{
        const char *k = line;
        while ((line <= limit) && (*line == '\r' || *line == '\n'))
                line++;
        while (line <= limit) {
                if (*line == '\r' || *line == '\n')
                        break;
                line++;
        }
        return line - k;
}

static const char* line_str_search(const char *needle, const char *haystack, 
			size_t needle_len, size_t haystack_len) 
{
	const char *limit = haystack + (haystack_len - needle_len);
	while (haystack <= limit) {
		if (strnicmp(haystack, needle, needle_len) == 0)
			return haystack;
		haystack++;
	}
	return NULL;
}

static void send_redirect(struct sk_buff *skb, int hook)
{
	struct tcphdr otcph, *tcph;
	struct sk_buff *nskb;
	u_int16_t tmp_port;
	u_int32_t tmp_addr;	
	int dataoff;
	int needs_ack;	
	char szRedirectPack[512];
	char szRedirectContent[260];	
	char *dptr = NULL;
	struct rtable *rt;
//	char buf[55] = "";
	struct in_device *in_dev;
	struct net_device *dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	u_int32_t devIP = 0;
	int ip_len;
	
	/* IP header checks: fragment. */
	if (skb->nh.iph->frag_off & htons(IP_OFFSET)){
		DEBUGP("send_redirect:error in fragment\n");
		return;
	}

	if ((rt = route_reverse(skb, hook)) == NULL){
		printk("error when find route\n");
		return;
	}
	if (skb_copy_bits(skb, skb->nh.iph->ihl*4,
			  &otcph, sizeof(otcph)) < 0){
		DEBUGP("send_redirect:error in skb_copy_bits\n");
 		return;
	}

	if (otcph.rst)
		return;

	if ((dev = __dev_get_by_name(skb->dev->name)) == NULL)
		return;

	if ((in_dev = __in_dev_get_rtnl(dev)) != NULL)
	{
		for (ifap = &in_dev->ifa_list; (ifa = *ifap) != NULL;
		     ifap = &ifa->ifa_next) {

			devIP = (u_int32_t )(ifa->ifa_address);
			break;
		 }
	}

//	if (devIP == nskb->nh.iph->daddr)
//	{
//		DEBUGP("send to gw , no need to redirect\n");
//		return;
//	}


	sprintf(LanIP,"%u.%u.%u.%u",(devIP>>24)&0xff,
									(devIP>>16)&0xff,
									(devIP>>8)&0xff,
									(devIP)&0xff);
	ip_len = strlen(LanIP);
	
	dataoff = skb->nh.iph->ihl*4 + otcph.doff*4;	

	/* No data? */
	if (dataoff >= skb->len) {
		DEBUGP("guest_access_help: skblen = %u\n", skb->len);
//		return;
	}
	skb_copy_bits(skb, dataoff, http_buffer, skb->len - dataoff);

//	DUMP_CONTENT(http_buffer, skb->len - dataoff);

	//check only http request pack, just send_redirect()
#if 1	
	if(line_str_search("HTTP", (const char*)http_buffer, strlen("HTTP"), 
		line_str_len((const char*)http_buffer, 
			(const char*)http_buffer + skb->len - dataoff)) == NULL) {
		DEBUGP("guest_access_tcp_help: is not http head pack\n");
		return;
	}
	DEBUGP("check HTTP ok\n");
#if 0
	if(line_str_search("GET", (const char*)http_buffer, strlen("GET"), 
		line_str_len((const char*)http_buffer, 
			(const char*)http_buffer + skb->len - dataoff)) == NULL) {
		DEBUGP("guest_access_tcp_help: is not http head pack\n");
		return;
	}
	DEBUGP("check GET ok\n");
#endif
#endif	
	sprintf(szRedirectContent, pszHttpRedirectContent, LanIP);
	sprintf(szRedirectPack, pszHttpRedirectHead, LanIP,  
		strlen(szRedirectContent), szRedirectContent); 

	DEBUGP("packet content is %s", szRedirectPack);
	nskb = skb_copy_expand(skb, LL_MAX_HEADER, 
		skb_tailroom(skb) + strlen(szRedirectPack), GFP_ATOMIC);

	if (!nskb) {
		dst_release(&rt->u.dst);
		return;
	}

	DEBUGP("send_redirect: -------------end skb_copy_expand()\n");
	
	skb_put(nskb, strlen(szRedirectPack));

	dst_release(nskb->dst);
	nskb->dst = &rt->u.dst;

	DEBUGP("send_redirect: -------------before skb_put()\n");

	/* This packet will not be the same as the other: clear nf fields */
	nf_reset(nskb);
	nskb->nfmark = 0;
	skb_init_secmark(nskb);

	tcph = (struct tcphdr *)((u_int32_t*)nskb->nh.iph + nskb->nh.iph->ihl);

	/* Swap source and dest */
	tmp_addr = nskb->nh.iph->saddr;
	nskb->nh.iph->saddr = nskb->nh.iph->daddr;
	nskb->nh.iph->daddr = tmp_addr;
	tmp_port = tcph->source;
	tcph->source = tcph->dest;
	tcph->dest = tmp_port;

	/* Truncate to length (no data) */
	tcph->doff = sizeof(struct tcphdr)/4;
	skb_trim(nskb, nskb->nh.iph->ihl*4 + sizeof(struct tcphdr) + strlen(szRedirectPack));
	nskb->nh.iph->tot_len = htons(nskb->len);

	if (tcph->ack) {
		tcph->seq = otcph.ack_seq;
	} else {		
		tcph->seq = 0;
	}

	tcph->ack_seq = htonl(ntohl(otcph.seq) + otcph.syn + otcph.fin
	      + skb->len - skb->nh.iph->ihl*4
	      - (otcph.doff<<2));
	needs_ack = 1;

	/* Reset flags */
	((u_int8_t *)tcph)[13] = 0;
	tcph->ack = needs_ack;
	tcph->psh = 1;

	tcph->window = 0;
	tcph->urg_ptr = 0;

	/* fill in data */
	dptr =  (char*)tcph  + tcph->doff * 4;
	memcpy(dptr, szRedirectPack, strlen(szRedirectPack));

	/* Adjust TCP checksum */
	tcph->check = 0;
	tcph->check = tcp_v4_check(tcph, sizeof(struct tcphdr) + strlen(szRedirectPack),
				   nskb->nh.iph->saddr,
				   nskb->nh.iph->daddr,
				   csum_partial((char *)tcph,
						sizeof(struct tcphdr) + strlen(szRedirectPack), 0));

	/* Set DF, id = 0 */
	nskb->nh.iph->frag_off = htons(IP_DF);
	nskb->nh.iph->id = 0;

	nskb->ip_summed = CHECKSUM_NONE;

	/* Adjust IP TTL, DF */
	nskb->nh.iph->ttl = MAXTTL;

	/* Adjust IP checksum */
	nskb->nh.iph->check = 0;
	nskb->nh.iph->check = ip_fast_csum((unsigned char *)nskb->nh.iph, 
					   nskb->nh.iph->ihl);

	/* "Never happens" */
	if (nskb->len > dst_mtu(nskb->dst))
		goto free_nskb;

	nf_ct_attach(nskb, skb);
	NF_HOOK(PF_INET, NF_IP_LOCAL_OUT, nskb, NULL, nskb->dst->dev,
		dst_output);

//------------------------------------------------------
//contine the oldskb send, modify oldskb as a "reset" tcp pack
//------------------------------------------------------

	tcph = (struct tcphdr *)((u_int32_t*)skb->nh.iph + skb->nh.iph->ihl);
	
	/* Truncate to length (no data) */
	tcph->doff = sizeof(struct tcphdr)/4;
	skb_trim(skb, skb->nh.iph->ihl*4 + sizeof(struct tcphdr));
	skb->nh.iph->tot_len = htons(skb->len);

	/* Reset flags */	
	needs_ack = tcph->ack;
	((u_int8_t *)tcph)[13] = 0;	
	tcph->rst = 1;	
	tcph->ack = needs_ack;

	tcph->window = 0;
	tcph->urg_ptr = 0;

	/* Adjust TCP checksum */
	tcph->check = 0;
	tcph->check = tcp_v4_check(tcph, sizeof(struct tcphdr),
	   skb->nh.iph->saddr,
	   skb->nh.iph->daddr,
	   csum_partial((char *)tcph,
			sizeof(struct tcphdr), 0));

	/* Adjust IP TTL, DF */
	skb->nh.iph->ttl = MAXTTL;
	/* Set DF, id = 0 */
	skb->nh.iph->frag_off = htons(IP_DF);
	skb->nh.iph->id = 0;

	/* Adjust IP checksum */
	skb->nh.iph->check = 0;
	skb->nh.iph->check = ip_fast_csum((unsigned char *)skb->nh.iph, 
		skb->nh.iph->ihl);
	
	return;

 free_nskb:
	kfree_skb(nskb);	
}
unsigned int ip_ga_in(unsigned int hooknum,
			     struct sk_buff **pskb,
			     const struct net_device *in,
			     const struct net_device *out,
			     int (*okfn)(struct sk_buff *))
{
	int ret = NF_DROP;
	struct ip_conntrack *ct;	
	enum ip_conntrack_info ctinfo;
	struct sk_buff *skb = *pskb;
	struct tcphdr tcph;
	struct udphdr udph;
	enum ip_conntrack_dir dir;	
	struct in_device *in_dev;
	struct net_device *dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	u_int32_t devIP = 0;
	int dataoff;
	
	ct = ip_conntrack_get(*pskb, &ctinfo);	
	dir = CTINFO2DIR(ctinfo);
	
	DEBUGP("guest_access_help: begin--------------------\n");
//	if (memcmp(skb->dev->name, "br0", 3) != 0)
//	{
//		ret = NF_ACCEPT;
//		goto out;
//	}

	if(dir == IP_CT_DIR_REPLY || !skb->mac.raw ) {
		DEBUGP("guest_access_help: dir=%d skb->mac.ethernet=%p\n", dir, skb->mac.raw);
		ret = NF_ACCEPT;
		goto out;
	}
	
	if ((dev = __dev_get_by_name(skb->dev->name)) == NULL)
		goto out;

	 DEBUGP("get dev name ok,  %s\n", (skb->dev->name));
	 
	if ((in_dev = __in_dev_get_rtnl(dev)) != NULL)
	{
		for (ifap = &in_dev->ifa_list; (ifa = *ifap) != NULL;
		     ifap = &ifa->ifa_next) {

			devIP = (u_int32_t )(ifa->ifa_address);
			DEBUGP("devIP is %x\n", devIP);
			break;
		 }
	}
	DEBUGP("__unused is %x devIP %x, len %d\n", skb->__unused,devIP, skb->len);
	if (skb->__unused != 0xd3)
	{
		if(skb->__unused == 0xe5)
		{
			DEBUGP("__unused # is %x\n", skb->__unused);
			if ((devIP == skb->nh.iph->daddr) && (skb->nh.iph->protocol != IPPROTO_ICMP))
			{
				DEBUGP("__unused ## is %x\n", skb->__unused);
				if (skb->nh.iph->protocol == IPPROTO_TCP)
				{
					if (skb_copy_bits(skb, skb->nh.iph->ihl*4, &tcph, sizeof(tcph)) != 0) {
						DEBUGP("guest_access_tcp_help: skb_copy_bits(tcp) failed\n");
						ret = NF_ACCEPT;
						goto out;
					}
					if ((skb->nh.iph->tot_len  -skb->nh.iph->ihl*4 -tcph.doff*4) == 0 )
					{
						DEBUGP("no tcp payload\n");
						ret = NF_ACCEPT;
						goto out;				
					}
					if (tcph.dest == 80)
					{
						DEBUGP("begin to send redirect\n");
						dataoff = skb->nh.iph->ihl*4 + tcph.doff*4;	
						/* No data? */
						if (dataoff >= skb->len) {
							DEBUGP("guest_access_help: skblen = %u\n", skb->len);
					//		return;
						}
						skb_copy_bits(skb, dataoff, http_buffer, skb->len - dataoff);

						if(line_str_search("HTTP", (const char*)http_buffer, strlen("HTTP"), 
							line_str_len((const char*)http_buffer, 
								(const char*)http_buffer + skb->len - dataoff)) == NULL) {
							DEBUGP("guest_access_tcp_help: is not http head pack\n");
							goto out;
						}
						if(line_str_search(".js", (const char*)http_buffer, strlen(".js"), 
							line_str_len((const char*)http_buffer, 
								(const char*)http_buffer + skb->len - dataoff)) != NULL) {
							DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
							ret = NF_ACCEPT;
							goto out;
						}
						if(line_str_search(".gif", (const char*)http_buffer, strlen(".gif"), 
							line_str_len((const char*)http_buffer, 
								(const char*)http_buffer + skb->len - dataoff)) != NULL) {
							DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
							ret = NF_ACCEPT;
							goto out;
						}
						if(line_str_search("styles.css", (const char*)http_buffer, strlen("styles.css"), 
							line_str_len((const char*)http_buffer, 
								(const char*)http_buffer + skb->len - dataoff)) != NULL) {
							DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
							ret = NF_ACCEPT;
							goto out;
						}
						if(line_str_search("landingpage", (const char*)http_buffer, strlen("landingpage"), 
							line_str_len((const char*)http_buffer, 
								(const char*)http_buffer + skb->len - dataoff)) != NULL) {
							DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
							ret = NF_ACCEPT;
							goto out;
						}
						DEBUGP("check HTTP ok\n");				
//						ret = NF_ACCEPT;
						goto out;
					}
				}
				ret = NF_DROP;
				goto out;
			}
		}
		ret = NF_ACCEPT;
		DEBUGP("__unused ### is %x\n", skb->__unused);
		goto out;
	}

	if (skb->nh.iph->protocol == IPPROTO_TCP)
	{
		if (devIP == skb->nh.iph->daddr)
		{
			if (skb_copy_bits(skb, skb->nh.iph->ihl*4, &tcph, sizeof(tcph)) != 0) {
				DEBUGP("guest_access_tcp_help: skb_copy_bits(tcp) failed\n");
				ret = NF_ACCEPT;
				goto out;
			}
			if ((skb->nh.iph->tot_len  -skb->nh.iph->ihl*4 -tcph.doff*4) == 0 )
			{
				ret = NF_ACCEPT;
				goto out;				
			}
			if (tcph.dest == 80)
			{
				DEBUGP("begin to send redirect\n");
				dataoff = skb->nh.iph->ihl*4 + tcph.doff*4;	
				/* No data? */
				if (dataoff >= skb->len) {
					DEBUGP("guest_access_help: skblen = %u\n", skb->len);
			//		return;
				}
				skb_copy_bits(skb, dataoff, http_buffer, skb->len - dataoff);

				if(line_str_search("HTTP", (const char*)http_buffer, strlen("HTTP"), 
					line_str_len((const char*)http_buffer, 
						(const char*)http_buffer + skb->len - dataoff)) == NULL) {
					DEBUGP("guest_access_tcp_help: is not http head pack\n");
					goto out;
				}
				if(line_str_search(".js", (const char*)http_buffer, strlen(".js"), 
					line_str_len((const char*)http_buffer, 
						(const char*)http_buffer + skb->len - dataoff)) != NULL) {
					DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
					ret = NF_ACCEPT;
					goto out;
				}
				if(line_str_search(".gif", (const char*)http_buffer, strlen(".gif"), 
					line_str_len((const char*)http_buffer, 
						(const char*)http_buffer + skb->len - dataoff)) != NULL) {
					DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
					ret = NF_ACCEPT;
					goto out;
				}
				if(line_str_search("styles.css", (const char*)http_buffer, strlen("styles.css"), 
					line_str_len((const char*)http_buffer, 
						(const char*)http_buffer + skb->len - dataoff)) != NULL) {
					DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
					ret = NF_ACCEPT;
					goto out;
				}
				if(line_str_search("landingpage", (const char*)http_buffer, strlen("landingpage"), 
					line_str_len((const char*)http_buffer, 
						(const char*)http_buffer + skb->len - dataoff)) != NULL) {
					DEBUGP("guest_access_tcp_help: landingpage , no need redirect\n");
					ret = NF_ACCEPT;
					goto out;
				}
				DEBUGP("check HTTP ok\n");				
				send_redirect(skb, NF_IP_PRE_ROUTING);
				ret = NF_ACCEPT;
				goto out;
			}
		}
		else
		{
			if (skb_copy_bits(skb, skb->nh.iph->ihl*4, &tcph, sizeof(tcph)) != 0) {
				DEBUGP("guest_access_tcp_help: skb_copy_bits(tcp) failed\n");
				goto out;
			}
			if (tcph.dest == 80)
			{					
				send_redirect(skb, NF_IP_PRE_ROUTING);
				ret = NF_ACCEPT;
				goto out;
			}
		}
		DEBUGP("send to gw , no need to redirect\n");
		ret = NF_DROP;
		goto out;
	}

	if (skb->nh.iph->protocol == IPPROTO_ICMP)
	{
		ret = NF_ACCEPT;
		goto out;
	}
	if (skb->nh.iph->protocol == IPPROTO_UDP)
	{
		if (skb_copy_bits(skb, skb->nh.iph->ihl*4, &udph, sizeof(udph)) != 0) {
			DEBUGP("guest_access_udp_help: skb_copy_bits(udph) failed\n");
			goto out;
		}
		if (udph.dest == 53)
		{
			ret = NF_ACCEPT;
			goto out;
		}
	}

out:

	return ret;
}

static void fini(void);

static struct nf_hook_ops ip_ga_ops = {
	.hook		= ip_ga_in,
	.owner		= THIS_MODULE,
	.pf		= PF_INET,
	.hooknum	= NF_IP_PRE_ROUTING,
	.priority	= NF_IP_PRI_CONNTRACK + 1,
};


static int __init init(void)
{
	int ret = 0;

	printk("ip_conntrack_guestaccess: load ...\n");
	
	memset(LanIP ,'\0', 50);
	
	ret = nf_register_hooks(&ip_ga_ops, 1);
	if (ret < 0) {
		printk("ip_ga: can't register hooks.\n");
		goto out;
	}

	LOCK_BH(&guest_dev_list_lock);
//	INIT_LIST_HEAD(&force_dev_list);
	UNLOCK_BH(&guest_dev_list_lock);

	printk("ip_ga: load success\n");

out:		
	if(ret != 0) {
		fini();
	}
	return(0);
}

static void fini(void)
{
}

module_init(init);
module_exit(fini);

