/*
 *	Generic parts
 *	Linux ethernet bridge
 *
 *	Authors:
 *	Lennert Buytenhek		<buytenh@gnu.org>
 *
 *	$Id: br.c,v 1.1.1.1 2009/02/17 09:44:45 anderson Exp $
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/init.h>
#include <linux/llc.h>
#include <net/llc.h>
#include <linux/proc_fs.h>
#include "br_private.h"

#ifdef CONFIG_BRIDGE_IGMPV3_SNOOPING
#include "../../drivers/net/re865x/igmpsnooping/rtl865x_igmpsnooping_glue.h"
#include "../../drivers/net/re865x/igmpsnooping/rtl865x_igmpsnooping.h"
#endif
int (*br_should_route_hook) (struct sk_buff **pskb) = NULL;

static struct llc_sap *br_stp_sap;

#if 1
/*2008-01-15*/
struct proc_dir_entry *resFDB=NULL;
//unsigned int fdb_max=1024;
unsigned int fdb_max=2048;
unsigned char fdb_count[8];

static int fdb_read_proc(char *page, char **start, off_t off,
		                     int count, int *eof, void *data)
{

      int len;
      len = sprintf(page, "%s\n", fdb_count);

      if (len <= off+count) *eof = 1;
	*start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int fdb_write_proc(struct file *file, const char *buffer,
		                      unsigned long count, void *data)
{
        char tmpbuf[8];
	if (count < 2)
   	   return -EFAULT;
	if (buffer && !copy_from_user(&fdb_count, buffer,8)) 
	{
	  fdb_max=simple_strtol(buffer,NULL,0);
	  return count;
   	}
   	return -EFAULT;
}
#endif

#ifdef IGMP_SNOOPING

/*2008-01-15,for porting igmp snooping to linux kernel 2.6*/
struct proc_dir_entry *procigmp=NULL;
int igmpsnoopenabled=0;

#ifdef CONFIG_BRIDGE_IGMPV3_SNOOPING
unsigned int brIgmpModuleIndex=0xFFFFFFFF;
#endif

static int br_igmpread_proc(char *page, char **start, off_t off, 
		int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "%c\n", igmpsnoopenabled + '0');


      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int br_igmpwrite_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      unsigned char br_tmp; 
      if (count < 2) 
	    return -EFAULT;
      
      if (buffer && !copy_from_user(&br_tmp, buffer, 1)) {
	    igmpsnoopenabled = br_tmp - '0';
	    return count;
      }
      return -EFAULT;
}

#endif
#ifdef MCAST_TO_UNICAST

struct proc_dir_entry *procIgmpProxy = NULL;

int IGMPProxyOpened = 0;

//#define IGMP_Proxy_DBG

static int br_igmpProxyRead_proc(char *page, char **start, off_t off, 
		int count, int *eof, void *data)
{
#ifdef	IGMP_Proxy_DBG
	  printk("br_igmpProxyRead_proc()\n");	
#endif	  
      int len;
      len = sprintf(page, "%c\n", IGMPProxyOpened + '0');

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int br_igmpProxyWrite_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	#ifdef	IGMP_Proxy_DBG
	printk("\nbr_igmpProxyWrite_proc()\n");	
	printk("count=%d\n",count);
	printk("buffer=%s\n",buffer);	  	  
	#endif	
    unsigned char chartmp; 
	  
    if (count > 1) {	//call from shell
      	if (buffer && !copy_from_user(&chartmp, buffer, 1)) {
	    	IGMPProxyOpened = chartmp - '0';
			#ifdef	IGMP_Proxy_DBG			
			printk("IGMPProxyOpened=%d\n",IGMPProxyOpened);
			#endif
			
	    }
	}else if(count==1){//call from demon(demon direct call br's ioctl)
			//memcpy(&chartmp,buffer,1);
			if(buffer){
				get_user(chartmp,buffer);	
		    	IGMPProxyOpened = chartmp - '0';
			}else
				return -EFAULT;
			#ifdef	IGMP_Proxy_DBG			
			printk("IGMPProxyOpened=%d\n",IGMPProxyOpened);
			#endif			

	}else{
		#ifdef	IGMP_Proxy_DBG			
		printk("br_igmpProxyWrite_proc fail\n");
		#endif			
		return -EFAULT;
	}
	return count;
}
#endif
static int __init br_init(void)
{
	int err;

	br_stp_sap = llc_sap_open(LLC_SAP_BSPAN, br_stp_rcv);
	if (!br_stp_sap) {
		printk(KERN_ERR "bridge: can't register sap for STP\n");
		return -EADDRINUSE;
	}

	br_fdb_init();
	#if 1
	/*2008-01-15*/
	resFDB=create_proc_entry("fdb_max",0,NULL);
	if (resFDB) 
	{
	          resFDB->read_proc=fdb_read_proc;
	          resFDB->write_proc=fdb_write_proc;
	}
	#endif	 
#ifdef IGMP_SNOOPING	
/*2008-01-15,for porting igmp snooping to linux kernel 2.6*/
		procigmp = create_proc_entry("br_igmpsnoop", 0, NULL);
		if (procigmp) {
		    procigmp->read_proc = br_igmpread_proc;
		    procigmp->write_proc = br_igmpwrite_proc;
		}
		
		#ifdef CONFIG_BRIDGE_IGMPV3_SNOOPING
		#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
		/*if enable ip multicast hardware accelerate, the bridge igmp snooping module won't be registered here*/
		#else
		rtl_registerIgmpSnoopingModule(&brIgmpModuleIndex);
		#endif
		#endif
#endif

#ifdef MCAST_TO_UNICAST	
		procIgmpProxy = create_proc_entry("br_igmpProxy", 0, NULL);
		if (procIgmpProxy) {
		    procIgmpProxy->read_proc = br_igmpProxyRead_proc;
		    procIgmpProxy->write_proc = br_igmpProxyWrite_proc;
		}
#endif
	err = br_netfilter_init();
	if (err)
		goto err_out1;

	err = register_netdevice_notifier(&br_device_notifier);
	if (err)
		goto err_out2;

	br_netlink_init();
	brioctl_set(br_ioctl_deviceless_stub);
	br_handle_frame_hook = br_handle_frame;

	br_fdb_get_hook = br_fdb_get;
	br_fdb_put_hook = br_fdb_put;

	return 0;

err_out2:
	br_netfilter_fini();
err_out1:
	llc_sap_put(br_stp_sap);
	return err;
}

static void __exit br_deinit(void)
{
	rcu_assign_pointer(br_stp_sap->rcv_func, NULL);
	#if 1
	/*2008-01-15*/
	if (resFDB) {
	          remove_proc_entry("fdb_max", resFDB);
	          resFDB = NULL;
	          }
	#endif
#ifdef IGMP_SNOOPING
/*2008-01-15,for porting igmp snooping to linux kernel 2.6*/
	if (procigmp) {
		remove_proc_entry("br_igmpsnoop", procigmp);		
		procigmp = NULL;
	}

	#ifdef CONFIG_BRIDGE_IGMPV3_SNOOPING

	#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
	/*if enable ip multicast hardware accelerate, the bridge igmp snooping module won't be unregistered here*/
	#else
	rtl_unregisterIgmpSnoopingModule(brIgmpModuleIndex);
	#endif
	
	#endif
#endif		

	br_netlink_fini();
	br_netfilter_fini();
	unregister_netdevice_notifier(&br_device_notifier);
	brioctl_set(NULL);

	br_cleanup_bridges();

	synchronize_net();

	llc_sap_put(br_stp_sap);
	br_fdb_get_hook = NULL;
	br_fdb_put_hook = NULL;

	br_handle_frame_hook = NULL;
	br_fdb_fini();
}

EXPORT_SYMBOL(br_should_route_hook);

module_init(br_init)
module_exit(br_deinit)
MODULE_LICENSE("GPL");
MODULE_VERSION(BR_VERSION);
