#include <asm/asm.h>
#include <asm/asm-offsets.h>
#include <asm/regdef.h>
        .text
        .set    noreorder
        .set    noat
        .align  5
	.section .iram-gen,"a";
LEAF(__L1)
	li	t1, 2
	negu	t2, t1
	srlv	t3, a0, t2
	sllv	t2, a0, t1
	or	t3, t2, t3
	xor	t0, t3, a0

	li	t1, 10
	negu	t2, t1
	srlv	t3, a0, t2
	sllv	t2, a0, t1
	or	t3, t2, t3
	xor	t0, t3, t0

	li	t1, 18
	negu	t2, t1
	srlv	t3, a0, t2
	sllv	t2, a0, t1
	or	t3, t2, t3
	xor	t0, t3, t0

	li	t1, 24
	negu	t2, t1
	srlv	t3, a0, t2
	sllv	t2, a0, t1
	or	t3, t2, t3

	jr	ra
	xor	v0, t3, t0
	END(__L1)

#if 0
	t0, t1, t2, t3
	a0
	v0
#endif
LEAF(__L2)
	li	t1, 13
	negu	t2, t1
	srlv	t3, a0, t2
	sllv	t2, a0, t1
	or	t3, t2, t3
	xor	t0, t3, a0

	li	t1, 23
	negu	t2, t1
	srlv	t3, a0, t2
	sllv	t2, a0, t1
	or	t3, t2, t3

	jr	ra
	xor	v0, t3, t0
	END(__L2)

LEAF(__xor_block)
	lw	t0, 0(a1)
	lw	t1, 0(a2)
	lw	t3, 4(a1)
	xor	t4, t0, t1
	lw	t0, 4(a2)
	sw	t4, 0(a0)
	
	lw	t1, 8(a1)
	xor	t4, t3, t0
	lw	t0, 8(a2)
	sw	t4, 4(a0)
	
	lw	t2, 12(a1)
	xor	t4, t1, t0
	lw	t0, 12(a2)
	sw	t4, 8(a0)
	xor	t3, t0, t2
	jr	ra
	sw	t3, 12(a0);
	
	END(__xor_block)

#if 0
	t0, t1, t2, t3
	a0
	v0
#endif
LEAF(__ByteSub)
	la	t0, Sbox
	li	t1, 24
	srl	t2, a0, t1
	andi	t2, t2, 0x00ff
	add	t2, t2, t0
	lbu	t3, 0(t2)
	li	t2, 16
	sll	v0, t3, t1

	srlv	t1, a0, t2
	andi	t1, t1, 0x00ff
	add	t1, t1, t0
	lbu	t3, 0(t1)
	li	t1, 8
	sllv	t3, t3, t2
	xor	v0, v0, t3

	srlv	t2, a0, t1
	andi	t2, t2, 0x00ff
	add	t2, t2, t0
	lbu	t3, 0(t2)
	andi	t2, a0, 0x00ff
	sllv	t3, t3, t1
	xor	v0, v0, t3

	add	t2, t2, t0
	lbu	t3, 0(t2)
	jr	ra
	xor	v0, v0, t3
	
	END(__ByteSub)

LEAF(__SMS4Crypt)
	
	move	t4, ra
	lw	t5, 0(a0)
	lw	t6, 4(a0)
	lw	t7, 8(a0)
	lw	t8, 12(a0)

	move	t9, zero
	move	a3, a2
	li	v1, 128
1:
	lw	t1, 0(a3)
	xor	a0, t6, t7
	xor	a0, a0,	t8
	jal	__ByteSub
	xor	a0, a0, t1
	jal	__L1
	move	a0, v0
	xor	t5, t5, v0
	
	lw	t1, 4(a3)
	xor	a0, t7, t8
	xor	a0, a0, t5
	jal	__ByteSub
	xor	a0, a0, t1
	jal	__L1
	move	a0, v0
	xor	t6, t6, v0

	lw	t1, 8(a3)
	xor	a0, t8, t5
	xor	a0, a0, t6
	jal	__ByteSub
	xor	a0, a0, t1
	jal	__L1
	move	a0, v0
	xor	t7, t7, v0
	
	lw	t1, 12(a3)
	xor	a0, t5, t6
	xor	a0, a0, t7
	jal	__ByteSub
	xor	a0, a0, t1
	jal	__L1
	move	a0, v0
	xor	t8, t8, v0
	
	addiu	t9, t9, 16
	slt	t1, t9, v1
	bne	t1, zero, 1b
	addu	a3, t9, a2

	sw	t8, 0(a1)
	sw	t7, 4(a1)
	sw	t6, 8(a1)

	jr	t4
	sw	t5, 12(a1)
	
	END(__SMS4Crypt)

#if 0
	used register:
	a0, a1, a2, a3
	t0, t4, t5, t6, t7, t8, t9
	v0, v1
#endif
LEAF (__SMS4KeyExt)
	la	t9, CK
	lw	t4, 0(a0)
	li	t5, 0xa3b1bac6
	xor	t4, t4, t5
	lw	t5, 4(a0)
	li	t6, 0x56aa3350
	xor	t5, t5, t6
	lw	t6, 8(a0)
	li	t7, 0x677d9197
	xor	t6, t6, t7
	lw	t7, 12(a0)
	li	t8, 0xb27022dc
	xor	t7, t7, t8
	move	a2, ra

	li	v1, 128
	move	t8, zero
1:
	lw	t0, 0(t9)
	xor	a0, t5, t6
	xor	a0, a0, t7
	jal	__ByteSub
	xor	a0, a0, t0
	jal	__L2
	move	a0, v0
	xor	t4, v0, t4
	sw	t4, 0(a1)

	lw	t0, 4(t9)
	xor	a0, t6, t7
	xor	a0, a0, t4
	jal	__ByteSub
	xor	a0, a0, t0
	jal	__L2
	move	a0, v0
	xor	t5, v0, t5
	sw	t5, 4(a1)

	lw	t0, 8(t9)
	xor	a0, t7, t4
	xor	a0, a0, t5
	jal	__ByteSub
	xor	a0, a0, t0
	jal	__L2
	move	a0, v0
	xor	t6, v0, t6
	sw	t6, 8(a1)

	lw	t0, 12(t9)
	xor	a0, t4, t5
	xor	a0, a0, t6
	jal	__ByteSub
	xor	a0, a0, t0
	jal	__L2
	move	a0, v0
	xor	t7, v0, t7
	sw	t7, 12(a1)

	addiu	t8, t8, 16
	addiu	t9, t9, 16
	slt	t0, t8, v1
	bne	t0, zero, 1b
	addiu	a1, a1, 16

	jr	a2
	nop

	END(__SMS4KeyExt)


LEAF (__WapiSMS4Cryption)
	addiu	sp, -208
	sw	s0, 4(sp)
	sw	s1, 8(sp)
	sw	s2, 12(sp)
	sw	s3, 16(sp)
	sw	s4, 20(sp)
	sw	s5, 24(sp)
	sw	s6, 28(sp)
	sw	s7, 32(sp)
	sw	ra, 36(sp)
	sw	a1, 40(sp)

	addiu	s3, sp, 48	/* blockIn	*/
	addiu	s4, sp, 64	/* blockOut	*/
	lw	s5, 0(a3)	/* Input	*/
	lw	s6, 4(a3)	/* Output	*/
	lw	s1, 8(a3)	/* OutputLength */
	addiu	s7, sp, 80	/* rk		*/
	sw	s1, 44(sp)	/* restore OutputLength	*/
	addu	s0, zero, a2	/* inputLength	*/
	srl	s2, a2, 4	/* blockNum	*/

	addiu	t0, zero, 1
	addiu	t1, zero, 16
	addiu	t2, a1, 15
	addiu	t3, s3, 0
1:
	lb	t4, 0(t2)
	addiu	t2, t2, -1
	sb	t4, 0(t3)
	addiu	t3, t3, 1
	slt	t5, t0, t1
	bne	t5, zero, 1b
	addiu	t0, t0, 1

	jal	__SMS4KeyExt
	addiu	a1, sp, 80

	addiu	s1, zero, 1
1:
	move	a0, s3
	move	a1, s4
	jal	__SMS4Crypt
	move	a2, s7

	move	a0, s6
	move	a1, s5
	move	a2, s4
	addiu	s5, 16
	jal	__xor_block
	addiu	s6, 16

	move	t0, s3
	move	s3, s4
	move	s4, t0

	slt	t0, s1, s2
	bne	t0, zero, 1b
	addiu	s1, s1, 1

	li	t0, 4
	sll	s1, s2, t0

	andi	t1, s0, 0xf
	beq	t1, zero, 1f
	nop
	addu	s1, s1, t1
	
	move	a0, s3
	move	a1, s4
	jal	__SMS4Crypt
	move	a2, s7
	
	andi	t0, s0, 0xc
	beq	t0, zero, 3f
	nop

	addiu	t3, zero, 4
2:
	lw	t1, 0(s5)
	lw	t2, 0(s4)
	nop
	xor	t2, t2, t1
	sw	t2, 0(s6)
	
	addiu	s5, s5, 4
	addiu	s6, s6, 4
	addiu	s4, s4, 4
	slt	t4, t3, t0
	bne	t4, zero, 2b
	addiu	t3, t3, 4

3:
	andi	t0, s0, 0x3
	beq	t0, zero, 1f
	nop
	
	addiu	t3, zero, 1
2:	
	lb	t1, 0(s5)
	lb	t2, 0(s4)
	nop
	xor	t2, t2, t1
	sb	t2, 0(s6)

	addiu	s5, s5, 1
	addiu	s6, s6, 1
	addiu	s4, s4, 1
	slt	t4, t3, t0
	bne	t4, zero, 2b
	addiu	t3, t3, 1
1:
	lw	t0, 44(sp)
	andi	s1, s1, 0xffff
	sh	s1, 0(t0)
	move	v0, t0
	move	v1, s1
	
	lw	ra, 36(sp)
	lw	s7, 32(sp)
	lw	s6, 28(sp)
	lw	s5, 24(sp)
	lw	s4, 20(sp)
	lw	s3, 16(sp)
	lw	s2, 12(sp)
	lw	s1, 8(sp)
	lw	s0, 4(sp)

	jr	ra
	addiu	sp, 208

	END (__WapiSMS4Cryption)

#if 0
LEAF (__WapiSMS4CalculateMic)
	addiu	sp, sp, -192

	addiu	s0, sp, 16	/*	blockIn		*/
	addiu	s1, sp, 32	/*	rk		*/
	lw	s2, 8(a0)	/*	input1		*/
	addiu	s3, a1, 0	/*	parameter1	*/
	sll	s4, a2, 16	/*	inputlength1	*/
	or	s4, s4, a3	/*	inputlength2	*/
	lw	s5, 4(a1)	/*	output		*/
	
	
	addiu	t0, zero, 1
	addiu	t1, zero, 16
	lw	t2, 4(a0)	/*	iv		*/
	addiu	t2, t2, 15
	move	t3, s0
1:
	lb	t4, 0(t2)
	addiu	t2, t2, -1
	sb	t4, 0(t3)
	addiu	t3, t3, 1
	slt	t5, t0, t1
	bne	t5, zero, 1b
	addiu	t0, t0, 1

	lw	a0, 0(a0)	/*	key		*/
	jal	__SMS4KeyExt
	move	a1, s1

	move	a0, s0
	move	a1, s5
	jal	__SMS4Crypt
	move	a2, s1

	srl	s6, s4, 20
	bne	s6, zero, 1f
	move	s7, zero
	b	3f
1:
	addiu	s6, s6, -1
2:
	move	a0, s0
	sll	t0, s7, 4
	addu	a1, s2, t0
	jal	xor_block
	move	a2, s5
	move	a0, s0
	move	a1, s5
	jal	__SMS4Crypt
	move	a2, s1

	slt	t0, s7, s6
	bne	t0, zero, 2b
	addiu	s7, s7, 1
3:
	srl	s6, s4, 16
	andi	s6, s6, 0xf
	


	jr	ra
	addiu	sp, sp, 192
	END (__WapiSMS4CalculateMic)
#endif
	.previous
