#ifndef	RTL_NIC_H
#define	RTL_NIC_H

#include "common/rtl_types.h"

#ifdef CONFIG_RTL8196_RTL8366
#define	RTL_WANPORT_MASK		0x1C1
#define	RTL_LANPORT_MASK		0x1C1
#define RTL8366RB_GMIIPORT		0x20
#define RTL8366RB_LANPORT		0xef
#define RTL8366RB_WANPORT		0x10
#else
#ifdef CONFIG_RTL8186_KB_N
#define	RTL_WANPORT_MASK		0x10
#define	RTL_LANPORT_MASK		0x1cf
#else
#define	RTL_WANPORT_MASK		0x01
#define	RTL_LANPORT_MASK		0x1de
#endif
#endif
#define	RTL_WANVLANID			8
#define	RTL_LANVLANID			9
#define	RTL_PPTPL2TP_VLANID	999

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#include "common/rtl865x_netif.h"

struct rtl865x_vlanConfig {
	uint8 			ifname[IFNAMSIZ];
	uint8			isWan;
	uint16			if_type;
	uint16			vid;
	uint16			fid;
	uint32			memPort;
	uint32			untagSet;
	uint32			mtu;
	ether_addr_t		mac;
	uint8			is_slave;
};
#define RTL865X_CONFIG_END					{ "", 0, 0, 0, 0, 0, 0, 0, {{0}}, 0 }

#define GATEWAY_MODE				0
#define BRIDGE_MODE				1
#define WISP_MODE					2
#define MULTIPLE_VLAN_BRIDGE_MODE 3
#define MULTIPLE_VLAN_WISP_MODE 4
#define CONFIG_CHECK(expr) do {\
	if(((int32)expr)!=SUCCESS){\
		rtlglue_printf("Error >>> %s:%d failed !\n", __FUNCTION__,__LINE__);\
			return FAILED;\
	}\
}while(0)

#define INIT_CHECK(expr) do {\
	if(((int32)expr)!=SUCCESS){\
		rtlglue_printf("Error >>> %s:%d failed !\n", __FUNCTION__,__LINE__);\
			return FAILED;\
	}\
}while(0)
#endif

#ifdef CONFIG_RTL8186_GR
extern int __init rtl8651_customPassthru_init(void);
int32 rtl8651_initStormCtrl(void);
#endif

#endif
