/*
* ----------------------------------------------------------------
* Copyright c                  Realtek Semiconductor Corporation, 2002  
* All rights reserved.
* 
* $Header: /cvsroot/Realtek/RTL8196B/kernels/linux-2.6.x/drivers/net/re865x/rtl865xc_swNic.h,v 1.1 2010/05/19 11:14:36 jackey Exp $
*
* Abstract: Switch core polling mode NIC header file.
*
* $Author: jackey $
*
* $Log: rtl865xc_swNic.h,v $
* Revision 1.1  2010/05/19 11:14:36  jackey
* *** empty log message ***
*
* Revision 1.3  2008/04/11 10:12:38  bo_zhao
* *: swap nic drive to 8186 style
*
* Revision 1.2  2007/11/11 02:51:27  davidhsu
* Fix the bug that do not fre rx skb in rx descriptor when driver is shutdown
*
* Revision 1.1.1.1  2007/08/06 10:04:52  root
* Initial import source to CVS
*
* Revision 1.4  2006/09/15 03:53:39  ghhuang
* +: Add TFTP download support for RTL8652 FPGA
*
* Revision 1.3  2005/09/22 05:22:31  bo_zhao
* *** empty log message ***
*
* Revision 1.1.1.1  2005/09/05 12:38:24  alva
* initial import for add TFTP server
*
* Revision 1.2  2004/03/31 01:49:20  yjlou
* *: all text files are converted to UNIX format.
*
* Revision 1.1  2004/03/16 06:36:13  yjlou
* *** empty log message ***
*
* Revision 1.1.1.1  2003/09/25 08:16:56  tony
*  initial loader tree 
*
* Revision 1.1.1.1  2003/05/07 08:16:07  danwu
* no message
*
* ---------------------------------------------------------------
*/


#ifndef RTL865XC_SWNIC_H
#define RTL865XC_SWNIC_H

/* refer to rtl865xc_swNic.c & rtl865xc_swNic.h
 */
#define RTL865X_SWNIC_RXRING_MAX_PKTDESC    6
#define RTL865X_SWNIC_TXRING_MAX_PKTDESC    2

#define UNCACHE_MASK   0x20000000

/* rxPreProcess */
#define RTL8651_CPU_PORT                0x07 /* in rtl8651_tblDrv.h */
#define _RTL865XB_EXTPORTMASKS   7

#ifdef CONFIG_RTL8196B
	#ifdef CONFIG_RTL865X_ETH_PRIV_SKB
	
	#ifdef RTL865X_MULTIPLE_RX_RING
	#undef DELAY_REFILL_ETH_RX_BUF
	#endif
	
	#endif
#endif

typedef struct {
	uint16		vid;
	uint16		portlist;
	uint16		srcExtPort;
	uint16		flags;
}	rtl_nicTx_info;


#define CONFIG_RTL865XC 1
#ifdef CONFIG_RTL865XC
/* --------------------------------------------------------------------
 * ROUTINE NAME - swNic_init
 * --------------------------------------------------------------------
 * FUNCTION: This service initializes the switch NIC.
 * INPUT   : 
        userNeedRxPkthdrRingCnt[RTL865X_SWNIC_RXRING_MAX_PKTDESC]: Number of Rx pkthdr descriptors. of each ring
        userNeedRxMbufRingCnt: Number of Rx mbuf descriptors.
        userNeedTxPkthdrRingCnt[RTL865X_SWNIC_TXRING_MAX_PKTDESC]: Number of Tx pkthdr descriptors. of each ring
        clusterSize: Size of a mbuf cluster.
 * OUTPUT  : None.
 * RETURN  : Upon successful completion, the function returns ENOERR. 
        Otherwise, 
		EINVAL: Invalid argument.
 * NOTE    : None.
 * -------------------------------------------------------------------*/
int32 swNic_init(uint32 userNeedRxPkthdrRingCnt[],
                 uint32 userNeedRxMbufRingCnt,
                 uint32 userNeedTxPkthdrRingCnt[],
                 uint32 clusterSize);
#endif /* CONFIG_RTL865XC */



/* --------------------------------------------------------------------
 * ROUTINE NAME - swNic_intHandler
 * --------------------------------------------------------------------
 * FUNCTION: This function is the NIC interrupt handler.
 * INPUT   :
		intPending: Pending interrupts.
 * OUTPUT  : None.
 * RETURN  : None.
 * NOTE    : None.
 * -------------------------------------------------------------------*/
void swNic_intHandler(uint32 intPending);

//int32 swNic_receive(void** input, uint32* pLen);
int32 swNic_receive(void** input, uint32* pLen, unsigned int *vid, unsigned int *pid);
//int32 swNic_send(void * output, uint32 len);
int32 swNic_send(void *skb, void * output, uint32 len, rtl_nicTx_info *nicTx);
int32 swNic_txDone(void);
void swNic_freeRxBuf(void);

#if 0
int32 arpTableDump(void);
int32 arpTableDelete(void);
#endif


//exported function by eth8186.c
extern void *UNCACHED_MALLOC(int size);
extern unsigned char *alloc_rx_buf(void **skb, int buflen);
extern void free_rx_buf(void *skb);
extern void tx_done_callback(void *skb);
extern void eth_save_and_cli(unsigned long *flags);
extern void eth_restore_flags(unsigned long flags);

#define	RTL8651_IOCTL_GETWANLINKSTATUS			2000
#define	RTL8651_IOCTL_GETLANLINKSTATUS			2001
#define	RTL8651_IOCTL_GETWANTHROUGHPUT			2002
#define	RTL8651_IOCTL_GETLANPORTLINKSTATUS		2003
#define	RTL8651_IOCTL_GETWANPORTLINKSTATUS		2004
#define 	RTL8651_IOCTL_GETWANLINKSPEED 			2100
//#define 	RTL8651_IOCTL_SETWANLINKSPEED 			2101

#define	RTL8651_IOCTL_SETWANLINKSTATUS			2200

#endif /* _SWNIC_H */
