/*
* ----------------------------------------------------------------
* Copyright c                  Realtek Semiconductor Corporation, 2002  
* All rights reserved.
* 
* $Header: /cvsroot/Realtek/RTL8196B/kernels/linux-2.6.x/drivers/net/re865x/rtl865xc_swNic.c,v 1.1 2010/05/19 11:14:36 jackey Exp $
*
* Abstract: Switch core polling mode NIC driver source code.
*
* $Author: jackey $
*
* $Log: rtl865xc_swNic.c,v $
* Revision 1.1  2010/05/19 11:14:36  jackey
* *** empty log message ***
*
* Revision 1.11  2008/04/11 10:49:14  bo_zhao
* * restore the original cache flush
*
* Revision 1.10  2008/04/11 10:12:38  bo_zhao
* *: swap nic drive to 8186 style
*
* Revision 1.6  2008/02/22 05:31:52  joeylin
* set one VLAN group for Bridge/WISP mode, and fix the issue:
* WAN port PC can not ping br0 (192.168.1.254) in Bridge/WISP mode
*
* Revision 1.5  2008/02/15 09:52:46  forrest
* 1. Add hardware accelerated PPTP processing. 2. Fine tune some hardware NAT to be compatible to hardware accelerated PPTP.
*
* Revision 1.4  2007/12/08 08:24:26  davidhsu
* Adjust tx desc size. Hide error message
*
* Revision 1.3  2007/12/04 12:00:18  joeylin
* add hardware NAT feature
*
* Revision 1.2  2007/11/11 02:51:24  davidhsu
* Fix the bug that do not fre rx skb in rx descriptor when driver is shutdown
*
* Revision 1.1.1.1  2007/08/06 10:04:52  root
* Initial import source to CVS
*
* Revision 1.11  2007/03/27 12:51:07  michaelhuang
* +: add function swNic_send_portmbr for FT2
*
*
*
* ---------------------------------------------------------------
*/

#include "rtl_types.h"
#include "common/rtl_glue.h"
#include "rtl_errno.h"
#include "asicRegs.h"
#include "rtl865xc_swNic.h"
#include "common/mbuf.h"
//#include "common/rtl865x_common.h"
#ifdef CONFIG_RTL865X_LAYERED_ASIC_DRIVER
#include "AsicDriver/rtl865x_asicCom.h"
#include "AsicDriver/rtl865x_asicL2.h"
#else
#include "common/rtl8651_aclLocal.h"
#include "AsicDriver/rtl865xC_tblAsicDrv.h"
#endif

#if defined(CONFIG_RTL865X_HW_PPTPL2TP) || defined(DELAY_REFILL_ETH_RX_BUF)
#include <linux/skbuff.h>
#endif
#include "AsicDriver/rtl865xC_hs.h"

extern void (*_dma_cache_wback_inv)(unsigned long start, unsigned long size);
extern void tx_done_callback(void *skb);

/* RX Ring */
__DRAM_FWD static uint32*  rxPkthdrRing[RTL865X_SWNIC_RXRING_MAX_PKTDESC];                 /* Point to the starting address of RX pkt Hdr Ring */
__DRAM_FWD static uint32   rxPkthdrRingCnt[RTL865X_SWNIC_RXRING_MAX_PKTDESC];              /* Total pkt count for each Rx descriptor Ring */
//static uint32 rxPkthdrRingIndex[RTL865X_SWNIC_RXRING_MAX_PKTDESC];            /* Current Index for each Rx descriptor Ring */

/* TX Ring */
__DRAM_FWD static uint32*  txPkthdrRing[RTL865X_SWNIC_TXRING_MAX_PKTDESC];             /* Point to the starting address of TX pkt Hdr Ring */
__DRAM_FWD static uint32   txPkthdrRingCnt[RTL865X_SWNIC_TXRING_MAX_PKTDESC];          /* Total pkt count for each Tx descriptor Ring */
//static uint32 txPkthdrRingFreeIndex[RTL865X_SWNIC_TXRING_MAX_PKTDESC];    /* Point to the entry can be set to SEND packet */

#define txPktHdrRingFull(idx)   (((txPkthdrRingFreeIndex[idx] + 1) & (txPkthdrRingMaxIndex[idx])) == (txPkthdrRingDoneIndex[idx]))

/* Mbuf */
uint32* rxMbufRing;                                                     /* Point to the starting address of MBUF Ring */
__DRAM_FWD uint32  rxMbufRingCnt;                                                  /* Total MBUF count */

static uint32  size_of_cluster;

/* descriptor ring tracing pointers */
__DRAM_FWD static int32   currRxPkthdrDescIndex;      /* Rx pkthdr descriptor to be handled by CPU */
__DRAM_FWD static int32   currRxMbufDescIndex;        /* Rx mbuf descriptor to be handled by CPU */
__DRAM_FWD static int32   currTxPkthdrDescIndex;      /* Tx pkthdr descriptor to be handled by CPU */

__DRAM_FWD static int32 txPktDoneDescIndex;

/* debug counters */
__DRAM_FWD static int32   rxPktCounter;
__DRAM_FWD static int32   txPktCounter;

#ifdef DELAY_REFILL_ETH_RX_BUF
__DRAM_FWD static int32   rxDescReadyForHwIndex;
#endif

const static uint8 extPortMaskToPortNum[_RTL865XB_EXTPORTMASKS+1] =
{
	0, 1, 2, 0, 3, 0, 0, 0
};


//--------------------------------------------------------------------------
/* mbuf header associated with each cluster 
*/
//--------------------------------------------------------------------------


/* LOCAL SUBPROGRAM SPECIFICATIONS
 */
//static void arpInput(uint8*,uint32);
//static int32 arpResolve(uint8*,uint8*);


//#pragma ghs section text=".iram"
/*************************************************************************
*   FUNCTION                                                              
*       swNic_intHandler                                         
*                                                                         
*   DESCRIPTION                                                           
*       This function is the handler of NIC interrupts
*                                                                         
*   INPUTS                                                                
*       intPending      Pending interrupt sources.
*                                                                         
*   OUTPUTS                                                               
*       None
*************************************************************************/
void swNic_intHandler(uint32 intPending) {return;}

__MIPS16
__IRAM_FWD inline int32 rtl8651_rxPktPreprocess(void *pkt, unsigned int *vid)
{
	struct rtl_pktHdr *m_pkthdr = (struct rtl_pktHdr *)pkt;
	uint32 srcPortNum;
	//printk("%s:%d, m_pkthdr->ph_reason is 0x%x\n",__FUNCTION__,__LINE__,m_pkthdr->ph_reason);
       srcPortNum = m_pkthdr->ph_portlist;

#if	defined(CONFIG_RTL865X_EXTPORT) || defined(CONFIG_RTL865X_HW_PPTPL2TP) || defined(CONFIG_RTL865X_HARDWARE_MULTICAST)
	*vid = m_pkthdr->ph_vlanId;
#endif

	if (srcPortNum >= RTL8651_CPU_PORT)
	{        
		if (m_pkthdr->ph_extPortList == 0)
		{
			/* No any destination ( extension port or CPU) : ASIC's BUG */
			return FAILED;
		}else if ((m_pkthdr->ph_extPortList & PKTHDR_EXTPORTMASK_CPU) == 0)
		{
			/*
				if dest Ext port 0x1 => to dst ext port 1 => from src port 1+5=6
				if dest Ext port 0x2 => to dst ext port 2 => from src port 2+5=7
				if dest Ext port 0x4 => to dst ext port 3 => from src port 3+5=8
			*/
			srcPortNum = extPortMaskToPortNum[m_pkthdr->ph_extPortList]+RTL8651_PORT_NUMBER-1;
			m_pkthdr->ph_portlist = srcPortNum;
#if	defined(CONFIG_RTL865X_EXTPORT) || defined(CONFIG_RTL865X_HW_PPTPL2TP) || defined(CONFIG_RTL865X_HARDWARE_MULTICAST)
			*vid = PKTHDR_EXTPORT_MAGIC;
#endif
		}else
		{
//			printk("Rx from extension port %d\n", m_pkthdr->ph_srcExtPortNum);
//			printk("reason bit 0x%x\n", m_pkthdr->ph_reason);
			/* has CPU bit, pkt is original pkt from port 6~8 */
			srcPortNum = m_pkthdr->ph_srcExtPortNum + RTL8651_PORT_NUMBER - 1;
			m_pkthdr->ph_portlist = srcPortNum;
		}        
	}
       else
	{
		/* otherwise, pkt is rcvd from PHY */
		m_pkthdr->ph_srcExtPortNum = 0;
		if((m_pkthdr->ph_extPortList & PKTHDR_EXTPORTMASK_CPU) == 0)
		{	/* No CPU bit, only dest ext mbr port... */
			/*
				if dest Ext port 0x1 => to dst ext port 1 => from src port 1+5=6
				if dest Ext port 0x2 => to dst ext port 2 => from src port 2+5=7
				if dest Ext port 0x4 => to dst ext port 3 => from src port 3+5=8
			*/
			if(m_pkthdr->ph_extPortList)
			{
				/* redefine src port number */
				srcPortNum = extPortMaskToPortNum[m_pkthdr->ph_extPortList] + RTL8651_PORT_NUMBER - 1;
				m_pkthdr->ph_portlist = srcPortNum;
#if	defined(CONFIG_RTL865X_EXTPORT) || defined(CONFIG_RTL865X_HW_PPTPL2TP) || defined(CONFIG_RTL865X_HARDWARE_MULTICAST)
				*vid = PKTHDR_EXTPORT_MAGIC;
#endif
			}
		}
	}		

	return SUCCESS;
}

#ifdef DELAY_REFILL_ETH_RX_BUF
inline int buffer_reuse(int index1, int index2) 
{
	int gap = (index2 > index1) ? (index2 - index1) : (index2 + rxPkthdrRingCnt[0] - index1);
	
	if ((rxPkthdrRingCnt[0] - gap) < ETH_REFILL_THRESHOLD)
		return 1;
	else
		return 0;
}

inline void set_RxPkthdrRing_OwnBit(void) 
{
	rxPkthdrRing[0][rxDescReadyForHwIndex] |= DESC_SWCORE_OWNED;
	
	if ( ++rxDescReadyForHwIndex == rxPkthdrRingCnt[0] )
		rxDescReadyForHwIndex = 0;
}

#if defined(RTL_SKB_IN_MBUF)
__IRAM_FWD static  void release_pkthdr(struct sk_buff  *skb)
{
	struct rtl_pktHdr *pReadyForHw;
	uint32 mbufIndex;

	pReadyForHw = (struct rtl_pktHdr *)(rxPkthdrRing[0][rxDescReadyForHwIndex] & 
						~(DESC_OWNED_BIT | DESC_WRAP));
	mbufIndex = ((uint32)(pReadyForHw->ph_mbuf) - (rxMbufRing[0] & ~(DESC_OWNED_BIT | DESC_WRAP))) /
					(sizeof(struct rtl_mBuf));
	
	pReadyForHw->ph_mbuf->m_data = skb->data;
	pReadyForHw->ph_mbuf->m_extbuf = skb->data;
	pReadyForHw->ph_mbuf->skb = skb;

	rxMbufRing[mbufIndex] |= DESC_SWCORE_OWNED;
	set_RxPkthdrRing_OwnBit();
}
#endif

/*
	return value: 1 ==> success, returned to rx pkt hdr desc
	return value: 0 ==> failed, no return ==> release to priv skb buf pool
 */	
extern struct sk_buff *dev_alloc_8190_skb(unsigned char *data, int size);
int return_to_rx_pkthdr_ring(unsigned char *head) 
{
	unsigned long flags;
	struct sk_buff *skb;
#if !defined(RTL_SKB_IN_MBUF)
	struct rtl_pktHdr *pReadyForHw, *alignWithMbuf;
	uint32 mbufIndex;
#endif
	int ret=0;

	
	local_irq_save(flags);
	
	if (rxDescReadyForHwIndex != currRxPkthdrDescIndex) {

		skb = dev_alloc_8190_skb(head, CROSS_LAN_MBUF_LEN);
		if (skb == NULL)
			goto _ret1;

		skb_reserve(skb, RX_OFFSET);

		#ifdef RTL865X_RX_RUNOUT_BUG
		/* store the skb pointer in a DW in front of  new_skb->data, it will be used in swNic_receive() */
		*(uint32 *)(skb->data-6) = (uint32)(skb);
		#endif

#if defined(RTL_SKB_IN_MBUF)
		release_pkthdr(skb);
#else
		pReadyForHw = (struct rtl_pktHdr *)(rxPkthdrRing[0][rxDescReadyForHwIndex] & 
						~(DESC_OWNED_BIT | DESC_WRAP));    
		mbufIndex = ((uint32)(pReadyForHw->ph_mbuf) - (rxMbufRing[0] & ~(DESC_OWNED_BIT | DESC_WRAP))) /
					(sizeof(struct rtl_mBuf));

		pReadyForHw->ph_mbuf->m_data = skb->data;
		pReadyForHw->ph_mbuf->m_extbuf = skb->data;
		alignWithMbuf = (struct rtl_pktHdr *)(rxPkthdrRing[0][mbufIndex] & ~(DESC_OWNED_BIT | DESC_WRAP));    
#if defined(RTL_SKB_IN_MBUF)
		alignWithMbuf->ph_mbuf->skb = skb;
#else
		alignWithMbuf->skb = skb;
#endif
		
		rxMbufRing[mbufIndex] |= DESC_SWCORE_OWNED;
		set_RxPkthdrRing_OwnBit();
#endif
		ret = 1;
	}

_ret1:
	local_irq_restore(flags);
	return ret;
}
#endif

/*************************************************************************
*   FUNCTION                                                              
*       swNic_receive                                         
*                                                                         
*   DESCRIPTION                                                           
*       This function reads one packet from rx descriptors, and return the 
*       previous read one to the switch core. This mechanism is based on 
*       the assumption that packets are read only when the handling 
*       previous read one is done.
*                                                                         
*   INPUTS                                                                
*       None
*                                                                         
*   OUTPUTS                                                               
*       None
*************************************************************************/
__MIPS16
__IRAM_FWD
int32 swNic_receive(void** input, uint32* pLen, unsigned int *vid, unsigned int *pid)
{
    struct rtl_pktHdr * pPkthdr;
	unsigned char *buf;
	void *skb;
	#ifdef RTL865X_RX_RUNOUT_BUG
	uint32 rxMbufDescIndex;
	#endif

#ifdef DELAY_REFILL_ETH_RX_BUF
	struct rtl_pktHdr *pReadyForHw, *alignWithMbuf;
	uint32 mbufIndex;	
#endif

get_next:
    /* Check OWN bit of descriptors */
    if ((rxPkthdrRing[0][currRxPkthdrDescIndex] & DESC_OWNED_BIT) == DESC_RISC_OWNED ) {   
		/* Fetch pkthdr */
		pPkthdr = (struct rtl_pktHdr *) (rxPkthdrRing[0][currRxPkthdrDescIndex] & 
                                            ~(DESC_OWNED_BIT | DESC_WRAP));    
		/* Increment counter */
       rxPktCounter++;

	#ifdef RTL865X_RX_RUNOUT_BUG		
	rxMbufDescIndex = ((uint32)(pPkthdr->ph_mbuf) - (rxMbufRing[0] & ~(DESC_OWNED_BIT | DESC_WRAP))) /
				(sizeof(struct rtl_mBuf));
	#endif
	/*	checksum error drop it	*/
	if ((pPkthdr->ph_flags & (CSUM_TCPUDP_OK | CSUM_IP_OK)) != (CSUM_TCPUDP_OK | CSUM_IP_OK))
	{
		buf = NULL;
		#ifdef DELAY_REFILL_ETH_RX_BUF
		goto release1;
		#else
		goto release;
		#endif
	}
#ifdef CONFIG_RTL865X_HARDWARE_NAT
		if (rtl8651_rxPktPreprocess(pPkthdr, vid) != 0) {
			buf = NULL;
		}
		else {
			buf = alloc_rx_buf(&skb, size_of_cluster);
		}
#else		
		buf = alloc_rx_buf(&skb, size_of_cluster);
#endif
		if (buf) {
			#ifdef RTL865X_RX_RUNOUT_BUG 
			/*
			 * Note: fix the error when rx descriptor runout occurred.
			 *
			 * these two uncached pointer pPkthdr and pPkthdr->ph_mbuf are updated by hardware
			 * when a packet is received.
			 * if no any rx descriptor runout occurred, pPkthdr and pPkthdr->ph_mbuf will pointer to 
			 * next struct accordingly.
			 * but when rx descriptor runout occurred, pPkthdr->ph_mbuf is not pointed to next mbuf
			 * struct (I still do not know why?). it may point to next 5 or 6 mbuf struct pointer.
			 * the old code "*input = pPkthdr->skb" will return the wrong skb pointer to caller, so I store the skb 
			 * pointer in front of m_data (done in alloc_rx_buf()) and retrieve it here to send it to the caller.
			 */
			*input = (void *)(*(uint32 *)(pPkthdr->ph_mbuf->m_data - 6));
			#else
#if defined(RTL_SKB_IN_MBUF)
			*input = pPkthdr->ph_mbuf->skb;
#else
			*input = pPkthdr->skb;
#endif
			#endif
			*pLen = pPkthdr->ph_len - 4;				
			_dma_cache_wback_inv((unsigned long)pPkthdr->ph_mbuf->m_data, *pLen); 

			/*
			 * vid is assigned in rtl8651_rxPktPreprocess() 
			 * do not update it when CONFIG_RTL865X_HARDWARE_NAT is defined
			 */
#if	!defined(CONFIG_RTL865X_EXTPORT)&&!defined(CONFIG_RTL865X_HARDWARE_NAT)&&!defined(CONFIG_RTL865X_HW_PPTPL2TP)
			*vid=pPkthdr->ph_vlanId;
#endif
			*pid=pPkthdr->ph_portlist;

			#ifdef DELAY_REFILL_ETH_RX_BUF
				#if defined(RTL_SKB_IN_MBUF)
				release_pkthdr(skb);
				#else
				pReadyForHw = (struct rtl_pktHdr*)(rxPkthdrRing[0][rxDescReadyForHwIndex] & ~(DESC_OWNED_BIT | DESC_WRAP));    
				mbufIndex = ((uint32)(pReadyForHw->ph_mbuf) - (rxMbufRing[0] & ~(DESC_OWNED_BIT | DESC_WRAP))) /(sizeof(struct rtl_mBuf));

				pReadyForHw->ph_mbuf->m_data = buf;
				pReadyForHw->ph_mbuf->m_extbuf = buf;
				alignWithMbuf = (struct rtl_pktHdr *)(rxPkthdrRing[0][mbufIndex] & ~(DESC_OWNED_BIT | DESC_WRAP));    
#if defined(RTL_SKB_IN_MBUF)
				alignWithMbuf->ph_mbuf->skb = skb;
#else
				alignWithMbuf->skb = skb;
#endif
				rxMbufRing[mbufIndex] |= DESC_SWCORE_OWNED;	
				set_RxPkthdrRing_OwnBit();
				#endif
			
			#else
			pPkthdr->ph_mbuf->m_data = pPkthdr->ph_mbuf->m_extbuf = buf;
#if defined(RTL_SKB_IN_MBUF)
			pPkthdr->ph_mbuf->skb = skb;
#else
			pPkthdr->skb = skb;
#endif
			#endif

		}
		#ifdef DELAY_REFILL_ETH_RX_BUF
		else if (!buffer_reuse(rxDescReadyForHwIndex, (currRxPkthdrDescIndex+1))) {
			#ifdef RTL865X_RX_RUNOUT_BUG 
			*input = (void *)(*(uint32 *)(pPkthdr->ph_mbuf->m_data - 6));
			#else
#if defined(RTL_SKB_IN_MBUF)
			*input = pPkthdr->ph_mbuf->skb;
#else
			*input = pPkthdr->skb;
#endif
			#endif
			*pLen = pPkthdr->ph_len - 4;				
			_dma_cache_wback_inv((unsigned long)pPkthdr->ph_mbuf->m_data, *pLen); 

#if	!defined(CONFIG_RTL865X_EXTPORT)&&!defined(CONFIG_RTL865X_HARDWARE_NAT)&&!defined(CONFIG_RTL865X_HW_PPTPL2TP) 
			*vid=pPkthdr->ph_vlanId;
#endif
			*pid=pPkthdr->ph_portlist;

			buf = (unsigned char *)*input; // just only for "if (buf == NULL)" below
		}
		else {
release1:
			// re-link skb and buffer pointer to the index "rxDescReadyForHwIndex"
			#ifdef RTL865X_RX_RUNOUT_BUG
			skb = (void *)(*(uint32 *)(pPkthdr->ph_mbuf->m_data - 6));
			#else
#if defined(RTL_SKB_IN_MBUF)
			skb = pPkthdr->ph_mbuf->skb;
#else
			skb = pPkthdr->skb;
#endif
			#endif
				#if defined(RTL_SKB_IN_MBUF)
				release_pkthdr(skb);
				#else
				pReadyForHw = (struct rtl_pktHdr *)(rxPkthdrRing[0][rxDescReadyForHwIndex] & ~(DESC_OWNED_BIT | DESC_WRAP));    
				mbufIndex = ((uint32)(pReadyForHw->ph_mbuf) - (rxMbufRing[0] & ~(DESC_OWNED_BIT | DESC_WRAP))) /(sizeof(struct rtl_mBuf));

				pReadyForHw->ph_mbuf->m_data = ((struct sk_buff *)skb)->data;
				pReadyForHw->ph_mbuf->m_extbuf = ((struct sk_buff *)skb)->data;
				alignWithMbuf = (struct rtl_pktHdr *)(rxPkthdrRing[0][mbufIndex] & ~(DESC_OWNED_BIT | DESC_WRAP));    
#if defined(RTL_SKB_IN_MBUF)
				alignWithMbuf->ph_mbuf->skb = skb;
#else
				alignWithMbuf->skb = skb;
#endif
				rxMbufRing[mbufIndex] |= DESC_SWCORE_OWNED;	
				set_RxPkthdrRing_OwnBit();
				#endif
		}		
		#else
release:
		#ifdef RTL865X_RX_RUNOUT_BUG 
		/* 
		 * inherit the Note above,
		 * if rx descriptor runout occurred, pPkthdr->ph_mbuf is pointed to next 5 or 6 mbuf struct pointer.
		 * these own bits of mbuf ring between currRxMbufDescIndex (previous mbuf index which own bit be set by driver) 
		 * and rxMbufDescIndex (the actual mbuf index of this received packet which calculate through pPkthdr->ph_mbuf) 
		 * must be set to switch-owned.
		 */
		if ((rxMbufDescIndex < rxMbufRingCnt)) {
			int i;
			if (rxMbufDescIndex >= currRxMbufDescIndex) {
				for (i=currRxMbufDescIndex; i<=rxMbufDescIndex; i++)
					rxMbufRing[i] |= DESC_SWCORE_OWNED;
			}
			else {
				for (i=currRxMbufDescIndex; i<rxMbufRingCnt; i++)
					rxMbufRing[i] |= DESC_SWCORE_OWNED;
				for (i=0; i<=rxMbufDescIndex; i++)
					rxMbufRing[i] |= DESC_SWCORE_OWNED;
			}			
			currRxMbufDescIndex = rxMbufDescIndex;
		}
		else {
			rxMbufRing[currRxMbufDescIndex] |= DESC_SWCORE_OWNED;
		}
		rxPkthdrRing[0][currRxPkthdrDescIndex] |= DESC_SWCORE_OWNED;
		#else
		rxPkthdrRing[0][currRxPkthdrDescIndex] |= DESC_SWCORE_OWNED;
		rxMbufRing[currRxMbufDescIndex] |= DESC_SWCORE_OWNED;
		#endif

		if ( ++currRxMbufDescIndex == rxMbufRingCnt )
			currRxMbufDescIndex = 0;

		#endif

        /* Increment index */
        if ( ++currRxPkthdrDescIndex == rxPkthdrRingCnt[0] )
            currRxPkthdrDescIndex = 0;

	if (buf == NULL)
		goto get_next;
		
        return 0;
    }
    else
        return -1;
}

#ifdef CONFIG_RTL865X_HW_PPTPL2TP
#include <linux/netdevice.h>
#include <linux/inetdevice.h>
struct dev_priv {
	u32			id;            /* VLAN id, not vlan index */
	u32			portmask;     /* member port mask */
	u32			portnum;     	/* number of member ports */
	u32			netinit;
	struct net_device	*dev;
	struct net_device   *dev_prev;
	struct net_device   *dev_next;
#ifdef RX_TASKLET
	struct tasklet_struct   rx_dsr_tasklet;
#endif

#ifdef TX_TASKLET
	struct tasklet_struct   tx_dsr_tasklet;
#endif
#ifdef CP_VLAN_TAG_USED
	struct vlan_group	*vlgrp;
#endif
	spinlock_t			lock;
	u32			msg_enable;
	u32 			opened;
	u32			irq_owner; //record which dev request IRQ
	struct net_device_stats net_stats;
#if defined(DYNAMIC_ADJUST_TASKLET) || defined(CONFIG_RTL8186_TR) || defined(BR_SHORTCUT)
    struct timer_list expire_timer; 
#endif

#if 0
	int			ip;
	int			mask;
	int			dns;
	int			pppoe_status;
	int			gateway;
	int			setup;
//	struct mii_if_info	mii_if;
#endif
};

__IRAM_EXTDEV int re865x_pptp_xmit(struct sk_buff *skb, struct net_device *dev, int to_lan)
{
	struct dev_priv		*dp = dev->priv;
	struct rtl_pktHdr 	*pPkthdr;	
	uint32	len, ret, next_index;
	unsigned long flags;

	flags = 0;
	local_irq_save(flags);
	
	len = skb->len;//orlando

	if ((currTxPkthdrDescIndex+1) == txPkthdrRingCnt[0])
		next_index = 0;
	else
		next_index = currTxPkthdrDescIndex+1;
	if (next_index == txPktDoneDescIndex) {
		local_irq_restore(flags);		
		return -1;
	}

	ret = currTxPkthdrDescIndex;
	currTxPkthdrDescIndex = next_index;
	
	/* Fetch packet header from Tx ring */
	pPkthdr = (struct rtl_pktHdr *) ((int32) txPkthdrRing[0][ret] 
		& ~(DESC_OWNED_BIT | DESC_WRAP));
	
	/* Pad small packets and add CRC */
	if ( len < 60 )
		len = 64;
	else
		len += 4;
		
	pPkthdr->ph_mbuf->m_len  = pPkthdr->ph_len = pPkthdr->ph_mbuf->m_extsize = len;

#if defined(RTL_SKB_IN_MBUF)
	pPkthdr->ph_mbuf->skb = skb;
#else
	pPkthdr->skb = skb;
#endif

	/* Set cluster pointer to buffer */		
	pPkthdr->ph_mbuf->m_data    = skb->data;
	pPkthdr->ph_mbuf->m_extbuf = skb->data;
	_dma_cache_wback_inv((unsigned long)skb->data, len);
	/* Give descriptor to switch core */
	txPkthdrRing[0][ret] |= DESC_SWCORE_OWNED;
	local_irq_restore(flags);

	if (to_lan==TRUE)
	{
		pPkthdr->ph_proto = PKTHDR_ETHERNET;
		pPkthdr->ph_vlanId = 999;
		{
			pPkthdr->ph_flags = 0x8820;		/* (PKTHDR_USED|PKT_OUTGOING|PKTHDR_HWLOOKUP) */
			pPkthdr->ph_srcExtPortNum = PKTHDR_EXTPORT_LIST_P2;
			pPkthdr->ph_portlist = RTL8651_CPU_PORT;
		}
	}
	else
	{
		pPkthdr->ph_portlist = rtl865x_wanPortMask;
		pPkthdr->ph_flags = (0x8802);	/* PKTHDR_USED|PKT_OUTGOING|CSUM_IP */
		pPkthdr->ph_proto = PKTHDR_IP;
		pPkthdr->ph_vlanId= (dp->id);
	}

#if 0
	memDump((void*)skb->data, 48, "TX to wan", txPkthdrRing[0][ret]);
	printk("Flags 0x%x proto 0x%x portlist 0x%x vid %d extPort %d srcExtPort %d len %d.\n", 
		pPkthdr->ph_flags, pPkthdr->ph_proto, pPkthdr->ph_portlist, pPkthdr->ph_vlanId, 
		pPkthdr->ph_extPortList, pPkthdr->ph_srcExtPortNum, pPkthdr->ph_len);
#endif
	REG32(CPUICR) |= TXFD;
	
	dev->trans_start = jiffies;
	dp->net_stats.tx_packets++;		
	dp->net_stats.tx_bytes += skb->len;
	
	return 0;				
}

#if 0
__IRAM_FWD int re865x_pptp_lan(struct sk_buff *skb, struct net_device *dev)
{
	struct dev_priv		*dp = dev->priv;
	struct rtl_pktHdr 	*pPkthdr;	
	uint32	len, ret, next_index;
	unsigned long flags;

	local_irq_save(flags);
	len = skb->len;//orlando

	if ((currTxPkthdrDescIndex+1) == txPkthdrRingCnt[0])
		next_index = 0;
	else
		next_index = currTxPkthdrDescIndex+1;
	
	if (next_index == txPktDoneDescIndex) {
		local_irq_restore(flags);		
		return -1;
	}

	ret = currTxPkthdrDescIndex;
	currTxPkthdrDescIndex = next_index;
	
	/* Fetch packet header from Tx ring */
	pPkthdr = (struct rtl_pktHdr *) ((int32) txPkthdrRing[0][ret] 
		& ~(DESC_OWNED_BIT | DESC_WRAP));
	
	/* Pad small packets and add CRC */
	if ( len < 60 )
		len = 64;
	else
		len += 4;

	pPkthdr->ph_mbuf->m_len  = pPkthdr->ph_len = pPkthdr->ph_mbuf->m_extsize = len;
	pPkthdr->skb = skb;

	/* Set cluster pointer to buffer */		
	pPkthdr->ph_mbuf->m_data    = skb->data;
	pPkthdr->ph_mbuf->m_extbuf = skb->data;

	/* Give descriptor to switch core */
	txPkthdrRing[0][ret] |= DESC_SWCORE_OWNED;
	_dma_cache_wback_inv((unsigned long)skb->data, len);
	local_irq_restore(flags);
	
	pPkthdr->ph_proto = PKTHDR_ETHERNET;

	pPkthdr->ph_vlanId = 999;
	{
		pPkthdr->ph_flags = 0x8820;		/* (PKTHDR_USED|PKT_OUTGOING|PKTHDR_HWLOOKUP) */
		pPkthdr->ph_srcExtPortNum = PKTHDR_EXTPORT_LIST_P2;
		pPkthdr->ph_portlist = RTL8651_CPU_PORT;
	}

#if 0
	memDump((void*)skb->data, 48, "TX to lan", txPkthdrRing[0][ret]);
	printk("Flags 0x%x proto 0x%x portlist 0x%x vid %d extPort %d srcExtPort %d len %d.\n", 
		pPkthdr->ph_flags, pPkthdr->ph_proto, pPkthdr->ph_portlist, pPkthdr->ph_vlanId, 
		pPkthdr->ph_extPortList, pPkthdr->ph_srcExtPortNum, pPkthdr->ph_len);
#endif
	/* Set TXFD bit to start send */
	REG32(CPUICR) |= TXFD;
	
	dev->trans_start = jiffies;
	dp->net_stats.tx_packets++;		
	dp->net_stats.tx_bytes += skb->len;
	return 0;				
}
#endif
#endif
/*************************************************************************
*   FUNCTION                                                              
*       swNic_send                                         
*                                                                         
*   DESCRIPTION                                                           
*       This function writes one packet to tx descriptors, and waits until 
*       the packet is successfully sent.
*                                                                         
*   INPUTS                                                                
*       None
*                                                                         
*   OUTPUTS                                                               
*       None
*************************************************************************/
__MIPS16
__IRAM_FWD  static inline int32 _swNic_send(void *skb, void * output, uint32 len,rtl_nicTx_info *nicTx)
{
	struct rtl_pktHdr * pPkthdr;
	int next_index, ret;
	
	if ((currTxPkthdrDescIndex+1) == txPkthdrRingCnt[0])
		next_index = 0;
	else
		next_index = currTxPkthdrDescIndex+1;
	if (next_index == txPktDoneDescIndex) {
		return -1;
	}		

	/* Fetch packet header from Tx ring */
	pPkthdr = (struct rtl_pktHdr *) ((int32) txPkthdrRing[0][currTxPkthdrDescIndex] 
                                                & ~(DESC_OWNED_BIT | DESC_WRAP));

	/* Pad small packets and add CRC */
	if ( len < 60 )
		len = 64;
	else
		len += 4;
		
	pPkthdr->ph_mbuf->m_len  = len;
	pPkthdr->ph_mbuf->m_extsize = len;
#if defined(RTL_SKB_IN_MBUF)
	pPkthdr->ph_mbuf->skb = skb;
#else
	pPkthdr->skb = skb;
#endif
	pPkthdr->ph_len = len;
	
	pPkthdr->ph_vlanId = nicTx->vid;
	pPkthdr->ph_portlist = nicTx->portlist;
	pPkthdr->ph_srcExtPortNum = nicTx->srcExtPort;
	pPkthdr->ph_flags = nicTx->flags;
//	pPkthdr->ph_flags = 0x8800;

    /* Set cluster pointer to buffer */		
	pPkthdr->ph_mbuf->m_data    = (output);
	pPkthdr->ph_mbuf->m_extbuf = (output);
	ret = currTxPkthdrDescIndex;
	currTxPkthdrDescIndex = next_index;
	/* Give descriptor to switch core */
	txPkthdrRing[0][ret] |= DESC_SWCORE_OWNED;
	_dma_cache_wback_inv((unsigned long)output, len);

#if 0
	memDump((void*)output, 12, "TX", txPkthdrRing[0][ret]);
	printk("index %d address 0x%p, 0x%x 0x%p.\n", ret, &txPkthdrRing[0][ret], (*(volatile uint32 *)&txPkthdrRing[0][ret]), pPkthdr);
	printk("Flags 0x%x proto 0x%x portlist 0x%x vid %d extPort %d srcExtPort %d len %d.\n", 
		pPkthdr->ph_flags, pPkthdr->ph_proto, pPkthdr->ph_portlist, pPkthdr->ph_vlanId, 
		pPkthdr->ph_extPortList, pPkthdr->ph_srcExtPortNum, pPkthdr->ph_len);
#endif

	/* Set TXFD bit to start send */
	REG32(CPUICR) |= TXFD;

	return ret;
}
__IRAM_FWD  int32 swNic_send(void *skb, void * output, uint32 len,rtl_nicTx_info *nicTx)
{
	int	ret;
	unsigned long flags;

	flags = 0;
	local_irq_save(flags);
	ret = _swNic_send(skb, output, len, nicTx);
	local_irq_restore(flags);	
	return ret;
}

int32 swNic_txDone(void)
{
	struct rtl_pktHdr * pPkthdr;
	int free_num;
	
	while (txPktDoneDescIndex != currTxPkthdrDescIndex) {		
	    if ( (*(volatile uint32 *)&txPkthdrRing[0][txPktDoneDescIndex] 
                    & DESC_OWNED_BIT) == DESC_RISC_OWNED ) {										
		    pPkthdr = (struct rtl_pktHdr *) ((int32) txPkthdrRing[0][txPktDoneDescIndex] 
                                                & ~(DESC_OWNED_BIT | DESC_WRAP));
#if defined(RTL_SKB_IN_MBUF)
			if (pPkthdr->ph_mbuf->skb)
			{
				tx_done_callback(pPkthdr->ph_mbuf->skb);
				pPkthdr->ph_mbuf->skb = NULL;
			}
#else
			if (pPkthdr->skb)
			{
				tx_done_callback(pPkthdr->skb);
				pPkthdr->skb = NULL;
			}
#endif	

#ifdef CONFIG_RTL865X_HW_PPTPL2TP
			pPkthdr->ph_srcExtPortNum = 0;
			pPkthdr->ph_type = PKTHDR_ETHERNET;
			pPkthdr->ph_flags &= ~PKTHDR_HWLOOKUP;
			pPkthdr->ph_flags &= ~CSUM_IP;
#endif

			if (++txPktDoneDescIndex == txPkthdrRingCnt[0])
				txPktDoneDescIndex = 0;
		}
		else
			break;
	}

	if (currTxPkthdrDescIndex >= txPktDoneDescIndex)
		free_num =  txPkthdrRingCnt[0] - currTxPkthdrDescIndex + txPktDoneDescIndex;
	else
		free_num = txPktDoneDescIndex - currTxPkthdrDescIndex - 1;
	return free_num;	
}


#ifdef  CONFIG_RTL865X_MODEL_TEST_FT2
int32 swNic_send_portmbr(void * output, uint32 len, uint32 portmbr)
{
    struct rtl_pktHdr * pPkthdr;
    uint8 pktbuf[2048];
    uint8* pktbuf_alligned = (uint8*) (( (uint32) pktbuf & 0xfffffffc) | 0xa0000000);

    /* Copy Packet Content */
    memcpy(pktbuf_alligned, output, len);

    ASSERT_CSP( ((int32) txPkthdrRing[0][currTxPkthdrDescIndex] & DESC_OWNED_BIT) == DESC_RISC_OWNED );

    /* Fetch packet header from Tx ring */
    pPkthdr = (struct rtl_pktHdr *) ((int32) txPkthdrRing[0][currTxPkthdrDescIndex] 
                                                & ~(DESC_OWNED_BIT | DESC_WRAP));

    /* Pad small packets and add CRC */
    if ( len < 60 )
        pPkthdr->ph_len = 64;
    else
        pPkthdr->ph_len = len + 4;

    pPkthdr->ph_mbuf->m_len = pPkthdr->ph_len;
    pPkthdr->ph_mbuf->m_extsize = pPkthdr->ph_len;

    /* Set cluster pointer to buffer */
    pPkthdr->ph_mbuf->m_data = pktbuf_alligned;
    pPkthdr->ph_mbuf->m_extbuf = pktbuf_alligned;

    /* Set destination port */
    pPkthdr->ph_portlist = portmbr;

    /* Give descriptor to switch core */
    txPkthdrRing[0][currTxPkthdrDescIndex] |= DESC_SWCORE_OWNED;

    /* Set TXFD bit to start send */
    REG32(CPUICR) |= TXFD;
    
    /* Wait until packet is successfully sent */
#if 1    
    while ( (*(volatile uint32 *)&txPkthdrRing[0][currTxPkthdrDescIndex] 
                    & DESC_OWNED_BIT) == DESC_SWCORE_OWNED );
#endif    
    txPktCounter++;
    
    if ( ++currTxPkthdrDescIndex == txPkthdrRingCnt[0] )
        currTxPkthdrDescIndex = 0;

    return 0;
}
#endif


void swNic_freeRxBuf(void)
{
	int idx;
    struct rtl_pktHdr * pPkthdr;

	for (idx=0; idx<rxPkthdrRingCnt[0]; idx++) {
	    if (!((rxPkthdrRing[0][idx] & DESC_OWNED_BIT) == DESC_RISC_OWNED)) {
			pPkthdr = (struct rtl_pktHdr *) (rxPkthdrRing[0][idx] & 
                                            ~(DESC_OWNED_BIT | DESC_WRAP));    
#if defined(RTL_SKB_IN_MBUF)
			if (pPkthdr->ph_mbuf->skb)
				free_rx_buf(pPkthdr->ph_mbuf->skb);
#else
			if (pPkthdr->skb)
				free_rx_buf(pPkthdr->skb);
#endif
	    }
    }
}

//#pragma ghs section text=default
/*************************************************************************
*   FUNCTION                                                              
*       swNic_init                                         
*                                                                         
*   DESCRIPTION                                                           
*       This function initializes descriptors and data structures.
*                                                                         
*   INPUTS                                                                
*       userNeedRxPkthdrRingCnt[RTL865X_SWNIC_RXRING_MAX_PKTDESC] :
*          Number of Rx pkthdr descriptors of each ring.
*       userNeedRxMbufRingCnt :
*          Number of Tx mbuf descriptors.
*       userNeedTxPkthdrRingCnt[RTL865X_SWNIC_TXRING_MAX_PKTDESC] :
*          Number of Tx pkthdr descriptors of each ring.
*       clusterSize :
*          Size of cluster.
*                                                                         
*   OUTPUTS                                                               
*       Status.
*************************************************************************/

int32 swNic_init(uint32 userNeedRxPkthdrRingCnt[RTL865X_SWNIC_RXRING_MAX_PKTDESC],
                 uint32 userNeedRxMbufRingCnt,
                 uint32 userNeedTxPkthdrRingCnt[RTL865X_SWNIC_TXRING_MAX_PKTDESC],
                 uint32 clusterSize)
{
    uint32 i, j, k;
    static uint32 totalRxPkthdrRingCnt = 0, totalTxPkthdrRingCnt = 0;
    static struct rtl_pktHdr *pPkthdrList_start;
	static struct rtl_mBuf *pMbufList_start;		
    struct rtl_pktHdr *pPkthdrList;
    struct rtl_mBuf *pMbufList;
//    uint8 * pClusterList;
    struct rtl_pktHdr * pPkthdr;
    struct rtl_mBuf * pMbuf;

	if (rxMbufRing == NULL)
	{ 
		size_of_cluster = clusterSize;

		/* Allocate Rx descriptors of rings */
		for (i = 0; i < RTL865X_SWNIC_RXRING_MAX_PKTDESC; i++) {   
			rxPkthdrRingCnt[i] = userNeedRxPkthdrRingCnt[i];
			if (rxPkthdrRingCnt[i] == 0)
			{
				rxPkthdrRing[i] = NULL;
 				continue;
			}

			rxPkthdrRing[i] = (uint32 *) UNCACHED_MALLOC(rxPkthdrRingCnt[i] * sizeof(uint32));
			ASSERT_CSP( (uint32) rxPkthdrRing[i] & 0x0fffffff );

			totalRxPkthdrRingCnt += rxPkthdrRingCnt[i];
		}
    
		if (totalRxPkthdrRingCnt == 0)
			return EINVAL;

		/* Allocate Tx descriptors of rings */
		for (i = 0; i < RTL865X_SWNIC_TXRING_MAX_PKTDESC; i++) {    
			txPkthdrRingCnt[i] = userNeedTxPkthdrRingCnt[i];

			if (txPkthdrRingCnt[i] == 0)
			{
				txPkthdrRing[i] = NULL;
				continue;
			}

			txPkthdrRing[i] = (uint32 *) UNCACHED_MALLOC(txPkthdrRingCnt[i] * sizeof(uint32));
			ASSERT_CSP( (uint32) txPkthdrRing[i] & 0x0fffffff );

			totalTxPkthdrRingCnt += txPkthdrRingCnt[i];
		}

		if (totalTxPkthdrRingCnt == 0)
			return EINVAL;

		/* Allocate MBuf descriptors of rings */
		rxMbufRingCnt = userNeedRxMbufRingCnt;

		if (userNeedRxMbufRingCnt == 0)
			return EINVAL;

		rxMbufRing = (uint32 *) UNCACHED_MALLOC(rxMbufRingCnt * sizeof(uint32));
		ASSERT_CSP( (uint32) rxMbufRing & 0x0fffffff );

		/* Allocate pkthdr */
		pPkthdrList_start = (struct rtl_pktHdr *) UNCACHED_MALLOC(
			(totalRxPkthdrRingCnt + totalTxPkthdrRingCnt) * sizeof(struct rtl_pktHdr));
		ASSERT_CSP( (uint32) pPkthdrList_start & 0x0fffffff );
                    
		/* Allocate mbufs */
		pMbufList_start = (struct rtl_mBuf *) UNCACHED_MALLOC(
			(rxMbufRingCnt + totalTxPkthdrRingCnt) * sizeof(struct rtl_mBuf));
		ASSERT_CSP( (uint32) pMbufList_start & 0x0fffffff );

#if 0										
		 /* Allocate clusters */
		pClusterList = (uint8 *) UNCACHED_MALLOC(rxMbufRingCnt * size_of_cluster + 8 - 1);
		ASSERT_CSP( (uint32) pClusterList & 0x0fffffff );
		pClusterList = (uint8*)(((uint32) pClusterList + 8 - 1) & ~(8 - 1));
#endif
	}

	/* Initialize interrupt statistics counter */
	rxPktCounter = txPktCounter = 0;

    /* Initialize index of Tx pkthdr descriptor */
    currTxPkthdrDescIndex = 0;
    txPktDoneDescIndex=0;

	pPkthdrList = pPkthdrList_start;
	pMbufList = pMbufList_start;
	
    /* Initialize Tx packet header descriptors */
    for (i = 0; i < RTL865X_SWNIC_TXRING_MAX_PKTDESC; i++)
    {
        for (j = 0; j < txPkthdrRingCnt[i]; j++)
        {
            /* Dequeue pkthdr and mbuf */
            pPkthdr = pPkthdrList++;
            pMbuf = pMbufList++;

            bzero((void *) pPkthdr, sizeof(struct rtl_pktHdr));
            bzero((void *) pMbuf, sizeof(struct rtl_mBuf));

            pPkthdr->ph_mbuf = pMbuf;
            pPkthdr->ph_len = 0;
            pPkthdr->ph_flags = PKTHDR_USED | PKT_OUTGOING;
            pPkthdr->ph_type = PKTHDR_ETHERNET;
            pPkthdr->ph_portlist = 0;

            pMbuf->m_next = NULL;
            pMbuf->m_pkthdr = pPkthdr;
            pMbuf->m_flags = MBUF_USED | MBUF_EXT | MBUF_PKTHDR | MBUF_EOR;
            pMbuf->m_data = NULL;
            pMbuf->m_extbuf = NULL;
            pMbuf->m_extsize = 0;

            txPkthdrRing[i][j] = (int32) pPkthdr | DESC_RISC_OWNED;
        }

        /* Set wrap bit of the last descriptor */
        txPkthdrRing[i][txPkthdrRingCnt[i] - 1] |= DESC_WRAP;
    }

    /* Fill Tx packet header FDP */
    REG32(CPUTPDCR0) = (uint32) txPkthdrRing[0];
    REG32(CPUTPDCR1) = (uint32) txPkthdrRing[1];

    /* Initialize index of current Rx pkthdr descriptor */
    currRxPkthdrDescIndex = 0;

    /* Initialize index of current Rx Mbuf descriptor */
    currRxMbufDescIndex = 0;

#ifdef DELAY_REFILL_ETH_RX_BUF
	rxDescReadyForHwIndex = 0;
#endif

    /* Initialize Rx packet header descriptors */
    k = 0;

    for (i = 0; i < RTL865X_SWNIC_RXRING_MAX_PKTDESC; i++)
    {
        for (j = 0; j < rxPkthdrRingCnt[i]; j++)
        {
            /* Dequeue pkthdr and mbuf */
            pPkthdr = pPkthdrList++;
            pMbuf = pMbufList++;

            bzero((void *) pPkthdr, sizeof(struct rtl_pktHdr));
            bzero((void *) pMbuf, sizeof(struct rtl_mBuf));

            /* Setup pkthdr and mbuf */
            pPkthdr->ph_mbuf = pMbuf;
            pPkthdr->ph_len = 0;
            pPkthdr->ph_flags = PKTHDR_USED | PKT_INCOMING;
            pPkthdr->ph_type = PKTHDR_ETHERNET;
            pPkthdr->ph_portlist = 0;
            pMbuf->m_next = NULL;
            pMbuf->m_pkthdr = pPkthdr;
            pMbuf->m_len = 0;
            pMbuf->m_flags = MBUF_USED | MBUF_EXT | MBUF_PKTHDR | MBUF_EOR;
			pMbuf->m_extsize = size_of_cluster;
#if defined(RTL_SKB_IN_MBUF)
			pMbuf->m_data = pMbuf->m_extbuf = alloc_rx_buf(&pPkthdr->ph_mbuf->skb, size_of_cluster);
#else
			pMbuf->m_data = pMbuf->m_extbuf = alloc_rx_buf(&pPkthdr->skb, size_of_cluster);
#endif

            
            /* Setup descriptors */
            rxPkthdrRing[i][j] = (int32) pPkthdr | DESC_SWCORE_OWNED;
            rxMbufRing[k++] = (int32) pMbuf | DESC_SWCORE_OWNED;
        }

        /* Set wrap bit of the last descriptor */
        rxPkthdrRing[i][rxPkthdrRingCnt[i] - 1] |= DESC_WRAP;
    }

    rxMbufRing[rxMbufRingCnt - 1] |= DESC_WRAP;

    /* Fill Rx packet header FDP */
    REG32(CPURPDCR0) = (uint32) rxPkthdrRing[0];
    REG32(CPURPDCR1) = (uint32) rxPkthdrRing[1];
    REG32(CPURPDCR2) = (uint32) rxPkthdrRing[2];
    REG32(CPURPDCR3) = (uint32) rxPkthdrRing[3];
    REG32(CPURPDCR4) = (uint32) rxPkthdrRing[4];
    REG32(CPURPDCR5) = (uint32) rxPkthdrRing[5];

    REG32(CPURMDCR0) = (uint32) rxMbufRing;

#if 0
    /* Initialize ARP table */
    bzero((void *) arptab, ARPTAB_SIZ * sizeof(struct arptab_s));
    arptab_next_available = 0;
#endif

    //printkf("addr=%x, val=%x\r\n",(CPUIIMR),REG32(CPUIIMR));
    /* Enable runout interrupts */
    //REG32(CPUIIMR) |= RX_ERR_IE_ALL | TX_ERR_IE_ALL | PKTHDR_DESC_RUNOUT_IE_ALL;  //8651c
    //REG32(CPUIIMR) = 0xffffffff; //RX_DONE_IE_ALL;  //   0xffffffff;  //wei test irq
    
    //*(volatile unsigned int*)(0xb8010028)=0xffffffff; 
    //printkf("eth0 CPUIIMR status=%x\r\n", *(volatile unsigned int*)(0xb8010028));   //ISR 
       
    /* Enable Rx & Tx. Config bus burst size and mbuf size. */
    //REG32(CPUICR) = TXCMD | RXCMD | BUSBURST_256WORDS | icr_mbufsize;
    //REG32(CPUICR) = TXCMD | RXCMD | BUSBURST_32WORDS | MBUF_2048BYTES;    //8651c
    //REG32(CPUICR) = TXCMD | RXCMD | BUSBURST_32WORDS | MBUF_2048BYTES; //wei test irq
    //REG32(CPUIIMR) = RX_DONE_IE_ALL | TX_ALL_DONE_IE_ALL | LINK_CHANGE_IE;// | TX_DONE_IE_ALL; 

    //printkf("eth0 CPUIIMR status=%x\r\n", *(volatile unsigned int*)(0xb8010028));   //ISR
    
    return SUCCESS;
}


#ifdef FAT_CODE
/*************************************************************************
*   FUNCTION                                                              
*       swNic_resetDescriptors                                         
*                                                                         
*   DESCRIPTION                                                           
*       This function resets descriptors.
*                                                                         
*   INPUTS                                                                
*       None.
*                                                                         
*   OUTPUTS                                                               
*       None.
*************************************************************************/
void swNic_resetDescriptors(void)
{
    /* Disable Tx/Rx and reset all descriptors */
    REG32(CPUICR) &= ~(TXCMD | RXCMD);
    return;
}
#endif//FAT_CODE

#if 0
//---------------------------------------------------------------------------------
static void arpInput(uint8* buf, uint32 port_list)
{
    int i;
    
    /* Search the ARP table and update the entry if already exists. 
        If not found, fill into the next available slot */
    for (i=0;i<ARPTAB_SIZ;i++)
        if (arptab[i].valid)
        {
            if (memcmp(arptab[i].arp_mac_addr, &buf[6], 6) == 0)
                break;
        }
        else
            break;
    if (i == ARPTAB_SIZ)
    {
        i = arptab_next_available;
        if (++arptab_next_available == ARPTAB_SIZ)
            arptab_next_available = 0;
    }
        
    memcpy(arptab[i].arp_mac_addr, &buf[6], 6);
    arptab[i].port_list = port_list;
    arptab[i].valid = 1;
//    printk("record mac=%x:%x:%x:%x:%x:%x port=%x\r\n", buf[0],buf[1],buf[2],buf[3],buf[4],buf[5],port_list);    
    
}

//---------------------------------------------------------------------------------
static int32 arpResolve(uint8* buf, uint8* port_list_ptr)
{
    int32 i;

    /* search the ARP table */
    for (i=0;i<ARPTAB_SIZ;i++)
    {
        if (arptab[i].valid)
        {
            if (memcmp(arptab[i].arp_mac_addr, &buf[0], 6) == 0)
            {
                *port_list_ptr = (uint8) arptab[i].port_list;

                return 0;
            }
        }
        else
            break;
    }

    return -1;
}

//---------------------------------------------------------------------------------
int32 arpTableDump()
{
    int32 i;

    /* search the ARP table */
    for (i=0;i<ARPTAB_SIZ;i++)
    {
        if (arptab[i].valid)
        {  
                
        printk("MAC=%x:%x:%x:%x:%x:%x, Port=%x\r\n",arptab[i].arp_mac_addr[0],arptab[i].arp_mac_addr[1],
                        arptab[i].arp_mac_addr[2],arptab[i].arp_mac_addr[3],
                        arptab[i].arp_mac_addr[4],arptab[i].arp_mac_addr[5],        
                        arptab[i].port_list);
                        
        }
        else
            break;
    }

    return 0;
}

//---------------------------------------------------------------------------------
int32 arpTableDelete()
{
    int32 i;

    /* search the ARP table */
    for (i=0;i<ARPTAB_SIZ;i++)
    {
        arptab[i].valid=0;                    
    }

    return 0;
}

#endif


