/*
* Copyright c                  Realtek Semiconductor Corporation, 2008  
* All rights reserved.
* 
* Program : napt table driver
* Abstract : 
* Author : hyking (hyking_liu@realsil.com.cn)  
*/

/*      @doc RTL865X_LAYEREDDRV_API

        @module rtl865x_nat.c - RTL865x Home gateway controller Layered driver API documentation       |
        This document explains the API interface of the table driver module. Functions with rtl865x prefix
        are external functions.
        @normal Hyking Liu (Hyking_liu@realsil.com.cn) <date>

        Copyright <cp>2008 Realtek<tm> Semiconductor Cooperation, All Rights Reserved.

        @head3 List of Symbols |
        Here is a list of all functions and variables in this module.
        
        @index | RTL865X_LAYEREDDRV_API
*/

#include "rtl_types.h"
#include "mbuf.h"
#include "assert.h"

#include <rtl865xc_swNic.h>
#include <common/types.h>
#include <common/rtl8651_hwPatch.h>		/* define for chip related spec */
#ifdef CONFIG_RTL865X_LAYERED_ASIC_DRIVER

#include "AsicDriver/rtl865x_asicL4.h"
#else
#include <common/rtl8651_aclLocal.h>
#include "rtl865xC_tblAsicDrv.h"
#endif

#include <common/rtl_errno.h>
#include "rtl_queue.h"
#include "rtl865xc_asicregs.h"
#include <rtl865x_eventMgr.h>
#include <rtl865x_ip.h>

#include "rtl865x_nat.h"
#include "rtl865x_nat_local.h"

#include <l3Driver/rtl865x_ppp.h>
#include <l3Driver/rtl865x_route.h>
#include <rtl865x_outputQueue.h>
#if	defined(CONFIG_RTL865X_HW_QOS_SUPPORT)
#include <l3Driver/rtl865x_arp.h>
#endif

#ifdef CONFIG_RTL865X_PROC_DEBUG
#include <linux/seq_file.h>
#endif

struct nat_table nat_tbl;
static int32 rtl865x_enableNaptFourWay=FALSE;
#if 0
static int32 rtl865x_nat_callbackFn_for_del_ip(void *param);

static int32 rtl865x_nat_register_event(void);

static int32 rtl865x_nat_callbackFn_for_del_ip(void *param)
{
	int i;
	rtl865x_tblAsicDrv_extIntIpParam_t *natip;
	struct nat_entry *nat_out, *nat_in;
	struct nat_tuple nat_tuple;
	natip=(rtl865x_tblAsicDrv_extIntIpParam_t *)param;

	for(i=0; i<RTL8651_TCPUDPTBL_SIZE; i++)
	{
		if((nat_tbl.nat_bucket[i].flags & NAT_OUTBOUND) && (nat_tbl.nat_bucket[i].ext_ip_==natip->extIpAddr))
		{
			memcpy(&nat_tuple, &nat_tbl.nat_bucket[i].tuple_info, sizeof(struct nat_tuple));
			nat_out = &nat_tbl.nat_bucket[i];
			nat_in = &nat_tbl.nat_bucket[nat_out->in];
			rtl8651_delAsicNaptTcpUdpTable(nat_out->in, nat_out->in);
			rtl8651_delAsicNaptTcpUdpTable(nat_out->out, nat_out->out);
			memset(nat_in, 0, sizeof(*nat_in));
			memset(nat_out, 0, sizeof(*nat_out));

			if(nat_tbl.connNum > 0)
			{
				nat_tbl.connNum--;
			}	
		}

	}
	return EVENT_CONTINUE_EXECUTE;
}


static int32 _rtl865x_nat_register_event(void)
{
	rtl865x_event_Param_t eventParam;
	
	eventParam.eventLayerId=DEFAULT_LAYER3_EVENT_LIST_ID;
	eventParam.eventId=EVENT_DEL_IP;
	eventParam.eventPriority=0;
	eventParam.event_action_fn=rtl865x_nat_callbackFn_for_del_ip;
	rtl865x_registerEvent(&eventParam);

	return SUCCESS;
}
#endif

static int32 _rtl865x_nat_init(void)
{
	rtl865x_tblAsicDrv_naptTcpUdpParam_t naptTcpUdp;
	uint32 flowTblIdx;
	
	memset(nat_tbl.nat_bucket, 0, 
		sizeof(struct nat_entry)*RTL8651_TCPUDPTBL_SIZE);

	nat_tbl.connNum = 0;
	nat_tbl.tcp_timeout = TCP_TIMEOUT; //24*60*60;
	nat_tbl.udp_timeout = UDP_TIMEOUT; //60*15;

	/* Set ASIC timeout value */
	rtl8651_setAsicNaptTcpLongTimeout(TCP_TIMEOUT);
	rtl8651_setAsicNaptTcpMediumTimeout(TCP_TIMEOUT);
	rtl8651_setAsicNaptTcpFastTimeout(TCP_TIMEOUT);
	rtl8651_setAsicNaptUdpTimeout(UDP_TIMEOUT);

	/*enable 865xC enhanced hash1*/
	_rtl8651_enableEnhancedHash1();
	
	/* Initial ASIC NAT Table */
	memset( &naptTcpUdp, 0, sizeof(naptTcpUdp) );
	naptTcpUdp.isCollision = 1;
	naptTcpUdp.isCollision2 = 1;
	for(flowTblIdx=0; flowTblIdx<RTL8651_TCPUDPTBL_SIZE; flowTblIdx++)
		rtl8651_setAsicNaptTcpUdpTable(TRUE, flowTblIdx, &naptTcpUdp );

	//rtl865x_nat_register_event();
		
	return SUCCESS;
}



static struct nat_entry * _rtl865x_nat_lookup(struct nat_tuple *nat_tuple)
{
	struct nat_entry *nat_out;
	uint32 i,hash;

	hash = rtl8651_naptTcpUdpTableIndex((uint8)nat_tuple->proto, nat_tuple->int_host.ip, nat_tuple->int_host.port, 
											nat_tuple->rem_host.ip, nat_tuple->rem_host.port);
	if(rtl865x_enableNaptFourWay==TRUE)
	{
		for(i=0; i<4; i++)
		{
			nat_out = &nat_tbl.nat_bucket[hash];
			if (!memcmp(nat_out, nat_tuple, sizeof(*nat_tuple)) &&
				NAT_INUSE(nat_out))
			{
				return nat_out;
			}
			hash=(hash&0xFFFFFFFC)+(hash+1)%4;
			assert(hash<=RTL8651_TCPUDPTBL_SIZE);
		}
	}
	else
	{
		nat_out = &nat_tbl.nat_bucket[hash];
		if (!memcmp(nat_out, nat_tuple, sizeof(*nat_tuple)) &&
			NAT_INUSE(nat_out))
			return nat_out;
	}
	return (struct nat_entry *)0;
}

static int32 _rtl865x_addNaptConnection( uint32 protocol, ipaddr_t intIp, uint32 intPort,
                        ipaddr_t extIp, uint32 extPort,
                        ipaddr_t remIp, uint32 remPort,
                        int32 flags )
{
	int32 retval;
	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat;
	struct nat_entry *nat_in, *nat_out;
	struct nat_tuple nat_tuple;
	uint32 in, out, offset, ipidx, i;
	uint16 very,selEidx_out;
#if	defined(CONFIG_RTL865X_HW_QOS_SUPPORT)
	rtl865x_route_t		rt;
	rtl865x_arpMapping_entry_t	arpInfo;
	ipaddr_t		sip, dip;
	uint16		sport, dport;
	rtl865x_AclRule_t		rule4, rule2;
	int32		priority, defPriority=-1;
#endif
	


	/* Make sure natip */
	retval = rtl865x_getIpIdxByExtIp(extIp, &ipidx);
	if(retval != SUCCESS)
		return RTL_EINVALIDINPUT;
	
	memset(&nat_tuple, 0, sizeof(struct nat_tuple));
	nat_tuple.int_host.ip			= intIp;
	nat_tuple.int_host.port			= intPort;
	nat_tuple.ext_host.ip			= extIp;
	nat_tuple.ext_host.port			= extPort;
	nat_tuple.rem_host.ip			= remIp;
	nat_tuple.rem_host.port		= remPort;
	nat_tuple.proto				= protocol;
	nat_out = _rtl865x_nat_lookup(&nat_tuple);
	if (nat_out)
		return RTL_EENTRYALREADYEXIST;

	offset = (extPort&0x0000ffff)>>10;
	in = extPort&0x3ff;
	very = rtl8651_naptTcpUdpTableIndex(((uint8)protocol) |HASH_FOR_VERI , remIp, remPort, 0, 0);
	
	selEidx_out = extPort&0x3ff;
	in = rtl8651_naptTcpUdpTableIndex((uint8)protocol, remIp, remPort, extIp, extPort);
	out = rtl8651_naptTcpUdpTableIndex((uint8)protocol, intIp, intPort, remIp, remPort);
	/*support outbound 4-way*/
	if(rtl865x_enableNaptFourWay==TRUE)
	{
		uint32 hash=out;
		for(i=0;i<4;i++)
		{
			nat_out = &nat_tbl.nat_bucket[hash];
			if (NAT_INUSE(nat_out))
			{
			
			}
			else
			{
				out=hash;
				break;
			}
			hash=(hash&0xFFFFFFFC)+(hash+1)%4;
			assert(hash<=RTL8651_TCPUDPTBL_SIZE);
				
		}
	}

	if(in==out)
	{
		return RTL_EENTRYALREADYEXIST;
	}	
	
	nat_in = &nat_tbl.nat_bucket[in];
	nat_out = &nat_tbl.nat_bucket[out];
	if (NAT_INUSE(nat_in) || NAT_INUSE(nat_out))
		return RTL_EINVALIDINPUT;

#ifdef CONFIG_HARDWARE_NAT_DEBUG
	rtlglue_printf("LR(%s):  %s (%u.%u.%u.%u:%u -> %u.%u.%u.%u:%u) g:(%u.%u.%u.%u:%u)\n",
			("add_nat"), ((protocol)? "tcp": "udp"), 
			NIPQUAD(intIp), intPort, NIPQUAD(remIp), remPort, NIPQUAD(extIp), extPort);
#endif

	memset(nat_out, 0, sizeof(struct nat_entry));
	memset(nat_in, 0, sizeof(struct nat_entry));
	*((struct nat_tuple *)nat_out)	= *((struct nat_tuple *)nat_in) = nat_tuple;
	nat_out->out					= nat_in->out = out;
	nat_out->in					= nat_in->in = in;
	nat_out->natip_idx			= nat_in->natip_idx = ipidx;
	SET_NAT_FLAGS(nat_out, NAT_OUTBOUND);
	SET_NAT_FLAGS(nat_in, NAT_INBOUND);

#if	defined(CONFIG_RTL865X_HW_QOS_SUPPORT)
	sip = nat_out->int_ip_;
	dip = nat_out->rem_ip_;
	sport = nat_out->rem_port_;
	dport = nat_out->ext_port_;
	priority = 0;
	for(i=0;i<2;i++)
	{
		if (rtl865x_getRouteEntry(sip, &rt)==SUCCESS)
		{
			/*	check ip base rule firstly	*/

			memset(&rule4, 0, sizeof(rtl865x_AclRule_t));
			rule4.ruleType_ = (nat_out->proto_==RTL865X_PROTOCOL_TCP?RTL865X_ACL_TCP:RTL865X_ACL_UDP);
			rule4.srcIpAddr_ = sip;
			rule4.dstIpAddr_ = dip;
			rule4.tcpSrcPortLB_ = sport;
			rule4.tcpDstPortLB_ = dport;
			rule4.netifIdx_ = _rtl865x_getNetifIdxByNameExt(rt.dstNetif->name);
			
			if (rtl865x_qosCheckNaptPriority(&rule4)==SUCCESS)
			{
				priority = rule4.priority_;		/* matched priority	*/
				break;
			}
			else if (i==0)
			{
				sip = nat_in->rem_ip_;
				dip = nat_in->ext_ip_;
				sport = nat_in->rem_port_;
				dport = nat_in->ext_port_;
				continue;
			}
			else
				defPriority = rule4.priority_;
		}
		else
		{
			sip = nat_in->rem_ip_;
			dip = nat_in->ext_ip_;
			sport = nat_in->rem_port_;
			dport = nat_in->ext_port_;
		}
	}

	{
		sip = nat_out->int_ip_;
		for(i=0;i<2;i++)
		{
			if (rtl865x_getArpMapping(sip, &arpInfo)==SUCCESS && rtl865x_getRouteEntry(sip, &rt)==SUCCESS)
			{
				/*	check mac base rule secondly	*/
				memset(&rule2, 0, sizeof(rtl865x_AclRule_t));
				rule2.ruleType_ = RTL865X_ACL_MAC;
				memcpy(rule2.srcMac_.octet, arpInfo.mac.octet, ETHER_ADDR_LEN);
				memset(rule2.srcMacMask_.octet, 0xff, ETHER_ADDR_LEN);
				rule2.netifIdx_ = _rtl865x_getNetifIdxByNameExt(rt.dstNetif->name);

				if (rtl865x_qosCheckNaptPriority(&rule2)==SUCCESS)
				{
					priority = rule2.priority_;		/* matched priority	*/
					break;
				}
				else if(i==0)
				{
					sip = nat_in->rem_ip_;
					continue;
				}
				else
					defPriority = rule2.priority_;
			}
			else
			{
				sip = nat_in->rem_ip_;
			}
		}
	}

	if (rule4.aclIdx&&rule2.aclIdx)
	{
		priority = (rule4.aclIdx<rule2.aclIdx)?rule4.priority_:rule2.priority_;
	}
	else if (rule4.aclIdx)
	{
		priority = rule4.priority_;
	}
	else if (rule2.aclIdx)
	{
		priority = rule2.priority_;
	}
	else if (defPriority>-1)
		priority = defPriority;
#endif
	for(i=0; i<2; i++) {
		memset(&asic_nat, 0, sizeof(asic_nat));
		asic_nat.insideLocalIpAddr	= intIp;
		asic_nat.insideLocalPort		= intPort;
		asic_nat.isCollision			= 0;
		asic_nat.isCollision2		= 0;
		asic_nat.isDedicated		= 0;
		asic_nat.isStatic			= 1;
		asic_nat.isTcp			= (protocol==RTL865X_PROTOCOL_TCP)? 1: 0;
		asic_nat.isValid			= 1;
		asic_nat.offset			= ((i==0)?offset : (extPort & 0x3f));
		asic_nat.selEIdx			= ((i==0)?selEidx_out: very &0x3ff);
		asic_nat.selExtIPIdx		= ((i==0)?ipidx:((extPort & 0x3ff) >> 6));
		asic_nat.tcpFlag			= (((in!=out)? 0x2:0x0) | ((i==0)? 1: 0));
		asic_nat.priValid                  =0;		
		asic_nat.ageSec			= (protocol==RTL865X_PROTOCOL_TCP)? nat_tbl.tcp_timeout:nat_tbl.udp_timeout;
#if	defined(CONFIG_RTL865X_HW_QOS_SUPPORT)
		asic_nat.priority			=	priority;
#endif
		rtl8651_setAsicNaptTcpUdpTable(1, ((i==0)?out: in), &asic_nat);
	}

	nat_tbl.connNum++;
	return SUCCESS;
}


static int32 _rtl865x_delNaptConnection( uint32 protocol, ipaddr_t intIp, uint32 intPort,
                        ipaddr_t extIp, uint32 extPort,
                        ipaddr_t remIp, uint32 remPort )
{
	struct nat_entry *nat_out, *nat_in;
	struct nat_tuple nat_tuple;

	memset(&nat_tuple, 0, sizeof(struct nat_tuple));
	nat_tuple.int_host.ip			= intIp;
	nat_tuple.int_host.port			= intPort;
	nat_tuple.ext_host.ip			= extIp;
	nat_tuple.ext_host.port			= extPort;
	nat_tuple.rem_host.ip			= remIp;
	nat_tuple.rem_host.port		= remPort;
	nat_tuple.proto				= protocol;
	nat_out = _rtl865x_nat_lookup(&nat_tuple);
	if (!nat_out)
		return RTL_EENTRYNOTFOUND;
	
	nat_in = &nat_tbl.nat_bucket[nat_out->in];
	rtl8651_delAsicNaptTcpUdpTable(nat_out->in, nat_out->in);
	rtl8651_delAsicNaptTcpUdpTable(nat_out->out, nat_out->out);
	memset(nat_in, 0, sizeof(*nat_in));
	memset(nat_out, 0, sizeof(*nat_out));

	#ifdef CONFIG_HARDWARE_NAT_DEBUG
	/*2007-12-19*/
	rtlglue_printf("LR(%s):  %s (%u.%u.%u.%u:%u -> %u.%u.%u.%u:%u) g:(%u.%u.%u.%u:%u)\n",
			("del_nat"), ((protocol)? "tcp": "udp"), 
			NIPQUAD(intIp), intPort, NIPQUAD(remIp), remPort, NIPQUAD(extIp), extPort);
	#endif

	if(nat_tbl.connNum>0)
	{
		nat_tbl.connNum--;
	}
	
	return SUCCESS;
}


static int32 _rtl865x_naptSync( uint32 protocol, ipaddr_t intIp, uint32 intPort,
			ipaddr_t extIp, uint32 extPort,
			ipaddr_t remIp, uint32 remPort, uint32 refresh )
{
	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat;
	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat1;
	struct nat_entry *nat_out;
	struct nat_tuple nat_tuple;
	int32 rc;

	memset(&nat_tuple, 0, sizeof(struct nat_tuple));
	nat_tuple.int_host.ip			= intIp;
	nat_tuple.int_host.port			= intPort;
	nat_tuple.ext_host.ip			= extIp;
	nat_tuple.ext_host.port			= extPort;
	nat_tuple.rem_host.ip			= remIp;
	nat_tuple.rem_host.port		= remPort;
	nat_tuple.proto				= protocol;
	nat_out = _rtl865x_nat_lookup(&nat_tuple);
	if (!nat_out)
		return 0;
	rc = rtl8651_getAsicNaptTcpUdpTable(nat_out->out, &asic_nat);
	assert(rc==SUCCESS);
	rc = rtl8651_getAsicNaptTcpUdpTable(nat_out->in, &asic_nat1);
	assert(rc==SUCCESS);
	return (asic_nat.ageSec>asic_nat1.ageSec)? asic_nat.ageSec: asic_nat1.ageSec;
}


/*
@func int32 | rtl865x_addNaptConnection |add a napt entry.
@parm uint32 | protocol | protocol.
@parm ipaddr_t | intIp | internal ip address.
@parm uint32 | intPort | internal port.
@parm ipaddr_t | extIp | external ip address.
@parm uint32 | extPort | external port.
@parm ipaddr_t | remIp | remote ip address.
@parm uint32 | remPort | remote port.
@parm int32 | flags | flags.
@rvalue SUCCESS | success.
@rvalue FAILED | failed.
@rvalue RTL_EINVALIDINPUT | invalid input.
@rvalue RTL_EENTRYALREADYEXIST | route entry is already exist.
@rvalue RTL_ENOFREEBUFFER | not enough memory in system.
@comm
	value of protocol should be RTL865X_PROTOCOL_TCP/RTL865X_PROTOCOL_UDP
*/
int32 rtl865x_addNaptConnection( uint32 protocol, ipaddr_t intIp, uint32 intPort,
                        ipaddr_t extIp, uint32 extPort,
                        ipaddr_t remIp, uint32 remPort,
                        int32 flags )
{
	int32 retval = FAILED;

	retval = _rtl865x_addNaptConnection(protocol,intIp,intPort,extIp,extPort,remIp,remPort, flags);

	return retval;
}

/*
@func int32 | rtl865x_delNaptConnection |delete a napt entry.
@parm uint32 | protocol | protocol.
@parm ipaddr_t | intIp | internal ip address.
@parm uint32 | intPort | internal port.
@parm ipaddr_t | extIp | external ip address.
@parm uint32 | extPort | external port.
@parm ipaddr_t | remIp | remote ip address.
@parm uint32 | remPort | remote port.

@rvalue SUCCESS | success.
@rvalue FAILED | failed.
@rvalue RTL_EENTRYNOTFOUND | not found this entry in system.
@comm
*/
int32 rtl865x_delNaptConnection( uint32 protocol, ipaddr_t intIp, uint32 intPort,
                        ipaddr_t extIp, uint32 extPort,
                        ipaddr_t remIp, uint32 remPort )
{
	int32 retval = FAILED;

	retval = _rtl865x_delNaptConnection(protocol,intIp,intPort,extIp,extPort,remIp,remPort);

	return retval;
}

int32 rtl865x_naptSync( uint32 protocol, ipaddr_t intIp, uint32 intPort,
			ipaddr_t extIp, uint32 extPort,
			ipaddr_t remIp, uint32 remPort, uint32 refresh )
{
	return _rtl865x_naptSync(protocol,intIp,intPort,extIp,extPort,remIp,remPort,refresh);
}

#if	defined(CONFIG_RTL865X_HW_QOS_SUPPORT)
inline static int32 rtl865x_naptSetAsicWithPriority(struct nat_entry *entry, int32 priority)
{
	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat;
	int32		idx;

	idx = (entry->flags&NAT_INBOUND)?entry->in:entry->out;
	
	rtl8651_getAsicNaptTcpUdpTable(idx, &asic_nat);
	asic_nat.priority = priority;
	rtl8651_setAsicNaptTcpUdpTable(1, idx, &asic_nat);

	return SUCCESS;
}

static int32 rtl865x_naptCallbackFn_for_qosChange(void *param)
{
	int num, i;
	struct nat_entry *nat_this, *nat_that;
	ipaddr_t		sip, dip;
	uint16		sport, dport;
	rtl865x_route_t		rt;
	rtl865x_arpMapping_entry_t	arpInfo;
	rtl865x_AclRule_t		rule4, rule2;
	int32		priority=-1, defPriority=-1;

	num = i = 0;

	while(num < nat_tbl.connNum)
	{
		if(NAT_INUSE(&nat_tbl.nat_bucket[i]))
		{
			nat_this = &nat_tbl.nat_bucket[i];
			if (nat_this->flags&NAT_INBOUND)
			{
				nat_that = &nat_tbl.nat_bucket[nat_this->out];
				sip = nat_this->rem_ip_;
				dip = nat_this->ext_ip_;
				sport = nat_this->rem_port_;
				dport = nat_this->ext_port_;
			}
			else
			{
				nat_that = &nat_tbl.nat_bucket[nat_this->in];
				sip = nat_this->int_ip_;
				dip = nat_this->rem_ip_;
				sport = nat_this->int_port_;
				dport = nat_this->rem_port_;
			}
			
			if (nat_this->flags&NAT_PRI_PROCESSED)
			{
				CLR_NAT_FLAGS(nat_this, NAT_PRI_PROCESSED);
				num++;
			}
			else 
			{
				if (rtl865x_getRouteEntry(sip, &rt)==SUCCESS)
				{
					memset(&rule4, 0, sizeof(rtl865x_AclRule_t));
					rule4.ruleType_ = (nat_this->proto_==RTL865X_PROTOCOL_TCP?RTL865X_ACL_TCP:RTL865X_ACL_UDP);
					rule4.srcIpAddr_ = sip;
					rule4.dstIpAddr_ = dip;
					rule4.tcpSrcPortLB_ = sport;
					rule4.tcpDstPortLB_ = dport;
					rule4.netifIdx_ = _rtl865x_getNetifIdxByNameExt(rt.dstNetif->name);
					if (rtl865x_qosCheckNaptPriority(&rule4)!=SUCCESS)
						defPriority = rule4.priority_;
					if (rtl865x_getArpMapping(sip, &arpInfo)==SUCCESS)
					{
						memset(&rule2, 0, sizeof(rtl865x_AclRule_t));
						rule2.ruleType_ = RTL865X_ACL_MAC;
						memcpy(rule2.srcMac_.octet, arpInfo.mac.octet, ETHER_ADDR_LEN);
						memset(rule2.srcMacMask_.octet, 0xff, ETHER_ADDR_LEN);
						rule2.netifIdx_ = _rtl865x_getNetifIdxByNameExt(rt.dstNetif->name);
						if (rtl865x_qosCheckNaptPriority(&rule2)!=SUCCESS)
							defPriority = rule2.priority_;
					}

					if (rule4.aclIdx&& rule2.aclIdx)
					{
						priority = (rule4.aclIdx<rule2.aclIdx)?rule4.priority_:rule2.priority_;
					}
					else if (rule4.aclIdx)
					{
						priority = rule4.priority_;
					}
					else if (rule2.aclIdx)
					{
						priority = rule2.priority_;
					}

					if (priority>-1)
					{
						rtl865x_naptSetAsicWithPriority(nat_this, priority);
						rtl865x_naptSetAsicWithPriority(nat_that, priority);
						if (nat_this->flags&NAT_PRI_HALF_PROCESSED)
						{
							CLR_NAT_FLAGS(nat_this, NAT_PRI_HALF_PROCESSED);
							num++;
						}
						else
							SET_NAT_FLAGS(nat_that, NAT_PRI_PROCESSED);
					}
					else
					{
						if (nat_this->flags&NAT_PRI_HALF_PROCESSED)
						{
							rtl865x_naptSetAsicWithPriority(nat_this, defPriority>-1?defPriority:0);
							rtl865x_naptSetAsicWithPriority(nat_that, defPriority>-1?defPriority:0);
							CLR_NAT_FLAGS(nat_this, NAT_PRI_HALF_PROCESSED);
							num++;
						}
						else
							SET_NAT_FLAGS(nat_that, NAT_PRI_HALF_PROCESSED);
					}
				}
				else
				{
					if (nat_this->flags&NAT_PRI_HALF_PROCESSED)
					{
						CLR_NAT_FLAGS(nat_this, NAT_PRI_HALF_PROCESSED);
						num++;
					}
					else
						SET_NAT_FLAGS(nat_that, NAT_PRI_HALF_PROCESSED);
				}
			}
		}

		i++;
	}
	return EVENT_CONTINUE_EXECUTE;
}


static int32 rtl865x_napt_register_qosEvent(void)
{
	rtl865x_event_Param_t eventParam;
	
	eventParam.eventLayerId=DEFAULT_LAYER2_EVENT_LIST_ID;
	eventParam.eventId=EVENT_CHANGE_QOSRULE;
	eventParam.eventPriority=0;
	eventParam.event_action_fn=rtl865x_naptCallbackFn_for_qosChange;
	rtl865x_registerEvent(&eventParam);

	eventParam.eventId=EVENT_FLUSH_QOSRULE;
	rtl865x_registerEvent(&eventParam);

	eventParam.eventLayerId=DEFAULT_LAYER3_EVENT_LIST_ID;
	eventParam.eventId=EVENT_ADD_ARP;
	rtl865x_registerEvent(&eventParam);

	return SUCCESS;
}
#endif

/*
@func int32 | rtl865x_setNatFourWay |enable 4way hash algorithm.
@parm int32 | enable | enable or disable.
@rvalue SUCCESS | success.
@comm
	default is enable in system.
*/
int32 rtl865x_setNatFourWay(int32 enable)
{
	 _set4WayHash(enable);
	rtl865x_enableNaptFourWay=enable;
	return SUCCESS;
}

/*
@func int32 | rtl865x_nat_init |initialize napt table.
@rvalue SUCCESS | success.
@comm	
*/
int32 rtl865x_nat_init(void)
{
	int32 retval = FAILED;
	retval = _rtl865x_nat_init();
#if	defined(CONFIG_RTL865X_HW_QOS_SUPPORT)
	rtl865x_napt_register_qosEvent();
#endif
	rtl865x_setNatFourWay(TRUE);
	return retval;
}


#ifdef CONFIG_RTL865X_PROC_DEBUG
int32 rtl865x_flushAllNaptConnection(void)
{
	uint32 i,outIndex,inIndex;
	struct nat_entry *nat_out=NULL, *nat_in=NULL, *tmp=NULL;
	for(i=0;i<RTL8651_TCPUDPTBL_SIZE;i++)
	{
		tmp = &nat_tbl.nat_bucket[i];

		if(NAT_INUSE(tmp))
		{
			outIndex=tmp->out;
			inIndex=tmp->in;
			nat_out=&nat_tbl.nat_bucket[outIndex];
			nat_in=&nat_tbl.nat_bucket[inIndex];	
		
			if(nat_in->flags&NAT_INBOUND)		
			{
				rtl8651_delAsicNaptTcpUdpTable(inIndex,inIndex);
				memset(nat_in, 0, sizeof(*nat_in));
			}

			if(nat_out->flags&NAT_OUTBOUND)
			{
				rtl8651_delAsicNaptTcpUdpTable(outIndex, outIndex);
				memset(nat_out, 0, sizeof(*nat_out));
			}
			
			if(nat_tbl.connNum>0)
			{
				nat_tbl.connNum--;
			}
		
		}
	}
	
	return SUCCESS;
}

int32 rtl865x_sw_napt_seq_read(struct seq_file *s, void *v)
{

	int i;
	struct nat_entry *natEntryPtr;
	int len=0;
	
	len = seq_printf(s, "%s\n", "sw napt table:");
	
	for(i=0; i<RTL8651_TCPUDPTBL_SIZE; i++)
	{
		natEntryPtr= &nat_tbl.nat_bucket[i];
		if(NAT_INUSE(natEntryPtr))
		{
			len += seq_printf(s, "[%4d]%s:%d.%d.%d.%d:%d<---->%d.%d.%d.%d:%d<----> %d.%d.%d.%d:%d, inbound:%d,outbound:%d\n",
			i,natEntryPtr->proto_==1?"tcp":"udp" ,NIPQUAD(natEntryPtr->int_ip_),natEntryPtr->int_port_,
			NIPQUAD(natEntryPtr->ext_ip_),natEntryPtr->ext_port_,NIPQUAD(natEntryPtr->rem_ip_),natEntryPtr->rem_port_, natEntryPtr->in,natEntryPtr->out);
		}
	
	}
	
	len += seq_printf(s, "totoal software napt connection number is %d\n",nat_tbl.connNum);
	return 0;
}

int32  rtl865x_sw_napt_seq_write( struct file *filp, const char *buff,unsigned long len, loff_t *off )
{
	char 	tmpbuf[64];
	uint32	delIndex,inIndex=0,outIndex=0;
	char		*strptr, *cmd_addr;
	char		*tokptr;
	struct nat_entry *nat_out=NULL, *nat_in=NULL, *tmp=NULL;
	
	if (buff && !copy_from_user(tmpbuf, buff, len)) {
		tmpbuf[len] = '\0';
		strptr=tmpbuf;
		cmd_addr = strsep(&strptr," ");
		if (cmd_addr==NULL)
		{
			goto errout;
		}

		if (!memcmp(cmd_addr, "flush", 5))
		{
			rtl865x_flushAllNaptConnection();
		}
		else if (!memcmp(cmd_addr, "del", 3))
		{
			tokptr = strsep(&strptr," ");
			if (tokptr==NULL)
			{
				goto errout;
			}

			delIndex=simple_strtol(tokptr, NULL, 0);
			if(delIndex>RTL8651_TCPUDPTBL_SIZE)
			{
				printk("error input!\n");
				return len;
			}
			tmp = &nat_tbl.nat_bucket[delIndex];

			if(NAT_INUSE(tmp))
			{
				outIndex=tmp->out;
				inIndex=tmp->in;
				nat_out=&nat_tbl.nat_bucket[outIndex];
				nat_in=&nat_tbl.nat_bucket[inIndex];	
			
				if(nat_in->flags&NAT_INBOUND)		
				{
					rtl8651_delAsicNaptTcpUdpTable(inIndex,inIndex);
					memset(nat_in, 0, sizeof(*nat_in));
				}

				if(nat_out->flags&NAT_OUTBOUND)
				{
					rtl8651_delAsicNaptTcpUdpTable(outIndex, outIndex);
					memset(nat_out, 0, sizeof(*nat_out));
				}
				
				if(nat_tbl.connNum>0)
				{
					nat_tbl.connNum--;
				}
				printk("del napt flow,outbound:%d,inbound:%d\n", outIndex, inIndex);
			
			}
			
		}
		else
		{
			goto errout;
		}
	}
	else
	{
errout:
		return len;
	}

	return len;
}

#endif

