#ifndef	RTL865X_LAYER4_LOCAL_H 
#define	RTL865X_LAYER4_LOCAL_H

struct nat_host_info {
	ipaddr_t						ip;
	uint16						port;
};

struct nat_tuple {
	struct nat_host_info			int_host;
	struct nat_host_info			ext_host;
	struct nat_host_info			rem_host;
	enum RTL_NP_PROTOCOL			proto;
};


struct nat_entry {
	struct nat_tuple				tuple_info;

	uint32						natip_idx;
	uint32						in;
	uint32						out;
	uint32 						flags;

#define int_ip_					tuple_info.int_host.ip
#define int_port_					tuple_info.int_host.port
#define ext_ip_					tuple_info.ext_host.ip
#define ext_port_					tuple_info.ext_host.port
#define rem_ip_					tuple_info.rem_host.ip
#define rem_port_					tuple_info.rem_host.port
#define proto_					tuple_info.proto

};

struct nat_table {

	int32						connNum;
	int32						tcp_timeout;
	int32						udp_timeout;
	
	struct nat_entry 				nat_bucket[RTL8651_TCPUDPTBL_SIZE];

	struct nat_entry *				(*nat_lookup)(struct nat_tuple *);
	int32						(*nat_init)(void);

	uint32						(*nat_asic_hash)(int8, ipaddr_t, uint16, ipaddr_t, uint16);
	int32						(*nat_asic_set)(int8, uint32, rtl865x_tblAsicDrv_naptTcpUdpParam_t *);
	int32						(*nat_asic_get)(uint32, rtl865x_tblAsicDrv_naptTcpUdpParam_t *);
	int32						(*nat_asic_del)(uint32, uint32);
	int32						(*nat_asic_tcpageL)(uint32);
	int32						(*nat_asic_tcpageM)(uint32);
	int32						(*nat_asic_tcpageF)(uint32);
	int32						(*nat_asic_udpage)(uint32);
};

extern struct natip_table					natip_tbl;
extern struct nat_table						nat_tbl;

#endif

