#ifndef	RTL865X_LAYER4_H
#define	RTL865X_LAYER4_H

//#include "common/rtl_types.h"

/* NAT timeout value */
#define TCP_TIMEOUT						60	 	/* 60 secs */
#define UDP_TIMEOUT						30		/* 30 secs */
#define TCP_CLOSED_FLOW					8

#define NAT_INBOUND				0x00000001
#define NAT_OUTBOUND			0x00000002
#define NAT_PRI_PROCESSED		0x00000004
#define NAT_INUSE(n)				( ((n)->flags&(NAT_INBOUND|NAT_OUTBOUND)) )
#define SET_NAT_FLAGS(n, v)		(n)->flags |= v
#define CLR_NAT_FLAGS(n, v)		((n)->flags &= (~v))

enum RTL_NP_PROTOCOL
{
	RTL_NP_UDP = 0,
	RTL_NP_TCP = 1,
};

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
enum RTL_RESULT
{
	/* Common error code */
	RTL_SUCCESS = 0,                     		/* Function Success */
	RTL_FAILED = -1,                     		/* General Failure, not recommended to use */
	RTL_ERROR_PARAMETER = -2,            	/* The given parameter error */
	RTL_EXIST = -3,                      		/* The entry you want to add has been existed, add failed */
	RTL_NONEXIST = -4,                   	/* The specified entry is not found */

	RTL_NOBUFFER = -1000,				/* Out of Entry Space */
	RTL_INVAPARAM = -1001,			/* Invalid parameters */
	RTL_NOTFOUND = -1002,			/* Entry not found */
	RTL_DUPENTRY = -1003,				/* Duplicate entry found */
	RTL_RTUNREACH = -1004,			/* Unreachable route */
	RTL_INVVID = -1005,				/* Invalid VID */
	RTL_IFDOWN = -1006,				/* Interface is down */
	RTL_NOARPSPACE = -1007,			/* Out of free ARP space */
	RTL_INVIF = -1008,					/* Invalid interface */
	RTL_INUSE = -1009,					/* Forbidden due to in use */
	RTL_INVEXTIP = -1010,				/* Invalid external IP address */
	RTL_COLLISION = 1011,				/* NAPT entry collision */
	RTL_NULLMACADDR = -1012,			/*null mac address */
	RTL_NOFREEBUFFER = -1013,			/*no free buffer */
};

#endif

enum RTL_NP_FLAGS
{
	RTL_NP_NONE = 0,
};

enum RTL_RESULT rtl865x_natInit(void);

/*
@func enum RTL_RESULT | rtl865x_addNaptConnection | Add a NAPT Flow
@parm enum RTL_NP_PROTOCOL | protocol | The protocol to add
@parm ipaddr_t | intIp | Internal IP address
@parm uint32 | intPort | Internal Port
@parm ipaddr_t | extIp | External IP address
@parm uint32 | extPort | External Port
@parm ipaddr_t | remIp | Remote IP address
@parm uint32 | remPort | Remote Port
@parm enum RTL_NP_FLAGS | flags | reserved for future used
@rvalue RTL_SUCCESS | Add success (can be ASIC-accelerated)
@rvalue RTL_SUCCESS | Add success (cannot be ASIC-accelerated)
@rvalue RTL_ERROR_PARAMETER | Error parameter is given
@rvalue RTL_EXIST | Add an existed flow
@rvalue RTL_FAILED | General failure
@comm 
	Add a NAPT Flow Entry to L4 TCP/UDP NAPT Table(1024-Entry)
@devnote
	Insert into ip_nat_setup_info() function in file net/ipv4/netfilter/ip_nat_core.c
*/
enum RTL_RESULT rtl865x_addNaptConnection( enum RTL_NP_PROTOCOL protocol, ipaddr_t intIp, uint32 intPort,
                                                                     ipaddr_t extIp, uint32 extPort,
                                                                     ipaddr_t remIp, uint32 remPort,
                                                                     enum RTL_NP_FLAGS flags );
/*
@func enum RTL_RESULT | rtl865x_delNaptConnection | Delete a NAPT Flow
@parm enum RTL_NP_PROTOCOL | protocol | The protocol to delete
@parm ipaddr_t | intIp | Internal IP address
@parm uint32 | intPort | Internal Port
@parm ipaddr_t | extIp | External IP address
@parm uint32 | extPort | External Port
@parm ipaddr_t | remIp | Remote IP address
@parm uint32 | remPort | Remote Port
@rvalue RTL_SUCCESS | Delete success
@rvalue RTL_NONEXIST | Delete a non-existed flow
@rvalue RTL_FAILED | General failure
@comm 
	Delete a NAPT Flow Entry of L4 TCP/UDP NAPT Table(1024-Entry)
@devnote
	Insert into ip_nat_cleanup_conntrack() function in file net/ipv4/netfilter/ip_nat_core.c
*/
enum RTL_RESULT rtl865x_delNaptConnection( enum RTL_NP_PROTOCOL protocol, ipaddr_t intIp, uint32 intPort,
                                                                     ipaddr_t extIp, uint32 extPort,
                                                                     ipaddr_t remIp, uint32 remPort );



uint32 rtl865x_naptSync( enum RTL_NP_PROTOCOL protocol, ipaddr_t intIp, uint32 intPort,
			ipaddr_t extIp, uint32 extPort,
			ipaddr_t remIp, uint32 remPort, uint32 refresh );

#endif
