#include "rtl_types.h"
#include "mbuf.h"
#include "assert.h"

#ifdef CONFIG_RTL865XB
#include "../rtl865xb_swNic.h"
#include "rtl8651_tblAsicDrv.h"
#elif defined(CONFIG_RTL865XC)
#include "../rtl865xc_swNic.h"
#include "../common/types.h"
#include "../common/rtl8651_hwPatch.h"		/* define for chip related spec */
#include <common/rtl8651_aclLocal.h>
#include "rtl865xC_tblAsicDrv.h"
#endif
#include "rtl_queue.h"
#include "rtl865xc_asicregs.h"

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#include <rtl865x_eventMgr.h>
#else
#include <rtl865x_common.h>
#endif

//#include <rtl865x_common_local.h>
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#include <rtl865x_ip.h>
#else
#include <rtl865x_layer3.h>
#include <rtl865x_layer3_local.h>
#endif

#include "rtl865x_layer4.h"
#include "rtl865x_layer4_local.h"

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#define TBLFIELD(tbl, field)	((tbl).field)
#endif

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#else
extern struct port_attribute					port_attr;
extern struct fdb_table						fdb_tbl;
extern struct rt_table						rt_tbl;
extern struct arp_table						arpt_tbl;
extern struct natip_table					natip_tbl;
extern struct pppoe_table					pppoe_tbl;
#endif



static int32 lr_nat_init(void);
static struct nat_entry *lr_nat_lookup(struct nat_tuple *);


/*======================================
 *  nat table - nat_tbl
 *======================================*/
struct nat_table nat_tbl = {
	nat_init:				lr_nat_init,
	nat_lookup:			lr_nat_lookup,

	nat_asic_hash:		rtl8651_naptTcpUdpTableIndex,
	nat_asic_set:			rtl8651_setAsicNaptTcpUdpTable,
	nat_asic_del:			rtl8651_delAsicNaptTcpUdpTable,
	nat_asic_get:			rtl8651_getAsicNaptTcpUdpTable,
	nat_asic_tcpageL:		rtl8651_setAsicNaptTcpLongTimeout,
	nat_asic_tcpageM:		rtl8651_setAsicNaptTcpMediumTimeout,
	nat_asic_tcpageF:		rtl8651_setAsicNaptTcpFastTimeout,
	nat_asic_udpage:		rtl8651_setAsicNaptUdpTimeout,
};


#ifdef CONFIG_RTL865X_LAYERED_DRIVER

static int32 lr_nat_callbackFn_for_del_ip(void *param);

static int32 lr_nat_register_event(void);

static int32 lr_nat_callbackFn_for_del_ip(void *param)
{
	int i;
	rtl865x_tblAsicDrv_extIntIpParam_t *natip;
	struct nat_entry *nat_out, *nat_in;
	struct nat_tuple nat_tuple;
	natip=(rtl865x_tblAsicDrv_extIntIpParam_t *)param;

	for(i=0; i<RTL8651_TCPUDPTBL_SIZE; i++)
	{
		if((TBLFIELD(nat_tbl, nat_bucket)[i].flags & NAT_OUTBOUND) && (TBLFIELD(nat_tbl, nat_bucket)[i].ext_ip_==natip->extIpAddr))
		{
			memcpy(&nat_tuple, &(TBLFIELD(nat_tbl, nat_bucket)[i].tuple_info), sizeof(struct nat_tuple));
			nat_out = &TBLFIELD(nat_tbl, nat_bucket)[i];
			nat_in = &TBLFIELD(nat_tbl, nat_bucket)[nat_out->in];
			TBLFIELD(nat_tbl, nat_asic_del)(nat_out->in, nat_out->in);
			TBLFIELD(nat_tbl, nat_asic_del)(nat_out->out, nat_out->out);
			memset(nat_in, 0, sizeof(*nat_in));
			memset(nat_out, 0, sizeof(*nat_out));

			if(TBLFIELD(nat_tbl, connNum)>0)
			{
				TBLFIELD(nat_tbl, connNum)--;
			}	
		}

	}
	return EVENT_CONTINUE_EXECUTE;
}

static int32 lr_nat_register_event(void)
{
	rtl865x_event_Param_t eventParam;
	
	eventParam.eventLayerId=DEFAULT_LAYER3_EVENT_LIST_ID;
	eventParam.eventId=EVENT_DEL_IP;
	eventParam.eventPriority=0;
	eventParam.event_action_fn=lr_nat_callbackFn_for_del_ip;
	rtl865x_registerEvent(&eventParam);

	return SUCCESS;
}

#endif

static int32 lr_nat_init(void)
{
	rtl865x_tblAsicDrv_naptTcpUdpParam_t naptTcpUdp;
	uint32 flowTblIdx;
	
	memset((void*)TBLFIELD(nat_tbl, nat_bucket), 0, 
		sizeof(struct nat_entry)*RTL8651_TCPUDPTBL_SIZE);

	TBLFIELD(nat_tbl, connNum) = 0;
	TBLFIELD(nat_tbl, tcp_timeout) = TCP_TIMEOUT; //24*60*60;
	TBLFIELD(nat_tbl, udp_timeout) = UDP_TIMEOUT; //60*15;

	/* Set ASIC timeout value */
	TBLFIELD(nat_tbl, nat_asic_tcpageL)(TCP_TIMEOUT);
	TBLFIELD(nat_tbl, nat_asic_tcpageM)(TCP_TIMEOUT);
	TBLFIELD(nat_tbl, nat_asic_tcpageF)(TCP_TIMEOUT);
	TBLFIELD(nat_tbl, nat_asic_udpage)(UDP_TIMEOUT);

	/*enable 865xC enhanced hash1*/
	_rtl8651_enableEnhancedHash1();
	
	/* Initial ASIC NAT Table */
	memset( &naptTcpUdp, 0, sizeof(naptTcpUdp) );
	naptTcpUdp.isCollision = 1;
	naptTcpUdp.isCollision2 = 1;
	for(flowTblIdx=0; flowTblIdx<RTL8651_TCPUDPTBL_SIZE; flowTblIdx++)
		TBLFIELD(nat_tbl, nat_asic_set)( TRUE, flowTblIdx, &naptTcpUdp );

	#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	lr_nat_register_event();
	#endif
	
	return 0;
}



static struct nat_entry *lr_nat_lookup(struct nat_tuple *nat_tuple)
{
	struct nat_entry *nat_out;
	uint32 hash;

#ifdef CONFIG_RTL865XB
	hash = TBLFIELD(nat_tbl, nat_asic_hash)((uint8)nat_tuple->proto, nat_tuple->int_host.ip, nat_tuple->int_host.port, 0, 0);
#else
	hash = TBLFIELD(nat_tbl, nat_asic_hash)((uint8)nat_tuple->proto, nat_tuple->int_host.ip, nat_tuple->int_host.port, 
											nat_tuple->rem_host.ip, nat_tuple->rem_host.port);
#endif
	nat_out = &TBLFIELD(nat_tbl, nat_bucket)[hash];
	if (!memcmp(nat_out, nat_tuple, sizeof(*nat_tuple)) &&
		NAT_INUSE(nat_out))
		return nat_out;
	return (struct nat_entry *)0;
}


enum RTL_RESULT rtl865x_natInit(void)
{
	TBLFIELD(nat_tbl, nat_init)();
	return RTL_SUCCESS;
}


#ifndef CONFIG_RTL865XC
enum RTL_RESULT rtl865x_addNaptConnection( enum RTL_NP_PROTOCOL protocol, ipaddr_t intIp, uint32 intPort,
                        ipaddr_t extIp, uint32 extPort,
                        ipaddr_t remIp, uint32 remPort,
                        enum RTL_NP_FLAGS flags )
{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	int32 retval;
#else
	rtl865x_tblAsicDrv_extIntIpParam_t *natip;
#endif
	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat;
	struct nat_entry *nat_in, *nat_out;
	struct nat_tuple nat_tuple;
	uint32 in, out, offset, ipidx, i;
	


	/* Make sure natip */
//	TBLFIELD(natip_tbl, natip_add)(extIp);
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	retval = rtl865x_getIpIdxByExtIp(extIp, &ipidx);
	if(retval != SUCCESS)
		return RTL_EINVALIDINPUT;
#else
	natip = TBLFIELD(natip_tbl, natip_lookup)(extIp, &ipidx);
	if (!natip)
		return RTL_INVEXTIP;
#endif
	memset(&nat_tuple, 0, sizeof(struct nat_tuple));
	nat_tuple.int_host.ip			= intIp;
	nat_tuple.int_host.port			= intPort;
	nat_tuple.ext_host.ip			= extIp;
	nat_tuple.ext_host.port			= extPort;
	nat_tuple.rem_host.ip			= remIp;
	nat_tuple.rem_host.port		= remPort;
	nat_tuple.proto				= protocol;
	nat_out = TBLFIELD(nat_tbl, nat_lookup)(&nat_tuple);
	if (nat_out)
		return RTL_DUPENTRY;

	offset = (extPort&0x0000ffff)>>10;
	in = extPort&0x3ff;
	out = TBLFIELD(nat_tbl, nat_asic_hash)((uint8)protocol, intIp, intPort, 0, 0);
	nat_in = &TBLFIELD(nat_tbl, nat_bucket)[in];
	nat_out = &TBLFIELD(nat_tbl, nat_bucket)[out];
	if (NAT_INUSE(nat_in) || NAT_INUSE(nat_out))
		return RTL_COLLISION;

	rtlglue_printf("LR(%s):  %s (%u.%u.%u.%u:%u -> %u.%u.%u.%u:%u) g:(%u.%u.%u.%u:%u)\n",
			("add_nat"), ((protocol)? "tcp": "udp"), 
			NIPQUAD(intIp), intPort, NIPQUAD(remIp), remPort, NIPQUAD(extIp), extPort
	);
	
	memset(nat_out, 0, sizeof(struct nat_entry));
	memset(nat_in, 0, sizeof(struct nat_entry));
	*((struct nat_tuple *)nat_out)	= *((struct nat_tuple *)nat_in) = nat_tuple;
	nat_out->out					= nat_in->out = out;
	nat_out->in					= nat_in->in = in;
	nat_out->natip_idx			= nat_in->natip_idx = ipidx;
	SET_NAT_FLAGS(nat_out, NAT_OUTBOUND);
	SET_NAT_FLAGS(nat_in, NAT_INBOUND);
	
	for(i=0; i<2; i++) {
		memset(&asic_nat, 0, sizeof(asic_nat));
		asic_nat.insideLocalIpAddr	= intIp;
		asic_nat.insideLocalPort		= intPort;
		asic_nat.isCollision			= 0;
		asic_nat.isCollision2		= 0;
		asic_nat.isDedicated		= 1;
		asic_nat.isStatic			= 1;
		asic_nat.isTcp			= (protocol==RTL_NP_TCP)? 1: 0;
		asic_nat.isValid			= 1;
		asic_nat.offset			= offset;
		asic_nat.selEIdx			= in;
		asic_nat.selExtIPIdx		= ipidx;
		asic_nat.tcpFlag			= (((in!=out)? 0x2:0x0) | ((i==0)? 1: 0));
		asic_nat.ageSec			= ((protocol==RTL_NP_TCP)? 
								   TBLFIELD(nat_tbl, tcp_timeout):
								   TBLFIELD(nat_tbl, udp_timeout));
		TBLFIELD(nat_tbl, nat_asic_set)(1, ((i==0)?out: in), &asic_nat);
	}
	return RTL_SUCCESS;
}
#else

enum RTL_RESULT rtl865x_addNaptConnection( enum RTL_NP_PROTOCOL protocol, ipaddr_t intIp, uint32 intPort,
                        ipaddr_t extIp, uint32 extPort,
                        ipaddr_t remIp, uint32 remPort,
                        enum RTL_NP_FLAGS flags )
{

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	int32 retval;
#else
	rtl865x_tblAsicDrv_extIntIpParam_t *natip;
#endif

	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat;
	struct nat_entry *nat_in, *nat_out;
	struct nat_tuple nat_tuple;
	uint32 in, out, offset, ipidx, i;
	uint16 very,selEidx_out;


	/* Make sure natip */
//	TBLFIELD(natip_tbl, natip_add)(extIp);
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	retval = rtl865x_getIpIdxByExtIp(extIp, &ipidx);
	if(retval != SUCCESS)
		return RTL_INVEXTIP;
#else
	natip = TBLFIELD(natip_tbl, natip_lookup)(extIp, &ipidx);
	if (!natip)
		return RTL_INVEXTIP;
#endif

	memset(&nat_tuple, 0, sizeof(struct nat_tuple));
	nat_tuple.int_host.ip			= intIp;
	nat_tuple.int_host.port			= intPort;
	nat_tuple.ext_host.ip			= extIp;
	nat_tuple.ext_host.port			= extPort;
	nat_tuple.rem_host.ip			= remIp;
	nat_tuple.rem_host.port		= remPort;
	nat_tuple.proto				= protocol;
	nat_out = TBLFIELD(nat_tbl, nat_lookup)(&nat_tuple);
	if (nat_out)
		return RTL_DUPENTRY;

	offset = (extPort&0x0000ffff)>>10;
	//very = TBLFIELD(nat_tbl, nat_asic_hash)(((uint8)protocol) |2 , remIp, remPort, 0, 0);
	very = TBLFIELD(nat_tbl, nat_asic_hash)(((uint8)protocol) |HASH_FOR_VERI , remIp, remPort, 0, 0);
	
	selEidx_out = extPort&0x3ff;
	//in = TBLFIELD(nat_tbl, nat_asic_hash)(((uint8)protocol |2 ), remIp, remPort, extIp, extPort);
	in = TBLFIELD(nat_tbl, nat_asic_hash)((uint8)protocol, remIp, remPort, extIp, extPort);
	out = TBLFIELD(nat_tbl, nat_asic_hash)((uint8)protocol, intIp, intPort, remIp, remPort);

	if(in==out)
	{
		return RTL_COLLISION;
	}
	
	nat_in = &TBLFIELD(nat_tbl, nat_bucket)[in];
	nat_out = &TBLFIELD(nat_tbl, nat_bucket)[out];

	#ifdef CONFIG_HARDWARE_NAT_DEBUG
	/*2007-12-19*/
	rtlglue_printf("%s:%d:outbound index(%d): inbound index(%d)\n",__FUNCTION__,__LINE__,out,in);
	#endif
	
	if (NAT_INUSE(nat_in) || NAT_INUSE(nat_out))
		return RTL_COLLISION;


	#ifdef CONFIG_HARDWARE_NAT_DEBUG
	/*2007-12-19*/
	rtlglue_printf("%s:%d:no collision\n",__FUNCTION__,__LINE__);
	rtlglue_printf("%s:%d:LR(%s):  %s (%u.%u.%u.%u:%u -> %u.%u.%u.%u:%u) g:(%u.%u.%u.%u:%u)\n",
			__FUNCTION__,__LINE__,("add_nat"), ((protocol)? "tcp": "udp"), 
			NIPQUAD(intIp), intPort, NIPQUAD(remIp), remPort, NIPQUAD(extIp), extPort);
	#endif
	
	
	memset(nat_out, 0, sizeof(struct nat_entry));
	memset(nat_in, 0, sizeof(struct nat_entry));
	*((struct nat_tuple *)nat_out)	= *((struct nat_tuple *)nat_in) = nat_tuple;
	nat_out->out					= nat_in->out = out;
	nat_out->in					= nat_in->in = in;
	nat_out->natip_idx			= nat_in->natip_idx = ipidx;
	SET_NAT_FLAGS(nat_out, NAT_OUTBOUND);
	SET_NAT_FLAGS(nat_in, NAT_INBOUND);
	
	for(i=0; i<2; i++) {
		memset(&asic_nat, 0, sizeof(asic_nat));
		asic_nat.insideLocalIpAddr	= intIp;
		asic_nat.insideLocalPort		= intPort;
		asic_nat.isCollision			= 0;
		asic_nat.isCollision2		= 0;
		asic_nat.isDedicated		= 0;
		asic_nat.isStatic			= 1;
		asic_nat.isTcp			= (protocol==RTL_NP_TCP)? 1: 0;
		asic_nat.isValid			= 1;
		asic_nat.offset			= ((i==0)?offset : (extPort & 0x3f));
		asic_nat.selEIdx			= ((i==0)?selEidx_out: very &0x3ff);
		asic_nat.selExtIPIdx		= ((i==0)?ipidx:((extPort & 0x3ff) >> 6));
		asic_nat.tcpFlag			= (((in!=out)? 0x2:0x0) | ((i==0)? 1: 0));
		asic_nat.priValid                  =0;
		asic_nat.priority                   =0;
		asic_nat.ageSec			= ((protocol==RTL_NP_TCP)? 
								   TBLFIELD(nat_tbl, tcp_timeout):
								   TBLFIELD(nat_tbl, udp_timeout));
		TBLFIELD(nat_tbl, nat_asic_set)(1, ((i==0)?out: in), &asic_nat);
	}
	TBLFIELD(nat_tbl, connNum)++;
	return RTL_SUCCESS;
}

#endif

enum RTL_RESULT rtl865x_delNaptConnection( enum RTL_NP_PROTOCOL protocol, ipaddr_t intIp, uint32 intPort,
                        ipaddr_t extIp, uint32 extPort,
                        ipaddr_t remIp, uint32 remPort )
{
	struct nat_entry *nat_out, *nat_in;
	struct nat_tuple nat_tuple;

	memset(&nat_tuple, 0, sizeof(struct nat_tuple));
	nat_tuple.int_host.ip			= intIp;
	nat_tuple.int_host.port			= intPort;
	nat_tuple.ext_host.ip			= extIp;
	nat_tuple.ext_host.port			= extPort;
	nat_tuple.rem_host.ip			= remIp;
	nat_tuple.rem_host.port		= remPort;
	nat_tuple.proto				= protocol;
	nat_out = TBLFIELD(nat_tbl, nat_lookup)(&nat_tuple);
	if (!nat_out)
		return RTL_NOTFOUND;
	nat_in = &TBLFIELD(nat_tbl, nat_bucket)[nat_out->in];
	TBLFIELD(nat_tbl, nat_asic_del)(nat_out->in, nat_out->in);
	TBLFIELD(nat_tbl, nat_asic_del)(nat_out->out, nat_out->out);
	memset(nat_in, 0, sizeof(*nat_in));
	memset(nat_out, 0, sizeof(*nat_out));

	#ifdef CONFIG_HARDWARE_NAT_DEBUG
	/*2007-12-19*/
	rtlglue_printf("LR(%s):  %s (%u.%u.%u.%u:%u -> %u.%u.%u.%u:%u) g:(%u.%u.%u.%u:%u)\n",
			("del_nat"), ((protocol)? "tcp": "udp"), 
			NIPQUAD(intIp), intPort, NIPQUAD(remIp), remPort, NIPQUAD(extIp), extPort);
	#endif

	if(TBLFIELD(nat_tbl, connNum)>0)
	{
		TBLFIELD(nat_tbl, connNum)--;
	}	
	return RTL_SUCCESS;
}


uint32 rtl865x_naptSync( enum RTL_NP_PROTOCOL protocol, ipaddr_t intIp, uint32 intPort,
			ipaddr_t extIp, uint32 extPort,
			ipaddr_t remIp, uint32 remPort, uint32 refresh )
{
	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat;
	rtl865x_tblAsicDrv_naptTcpUdpParam_t asic_nat1;
	struct nat_entry *nat_out;
	struct nat_tuple nat_tuple;
	int32 rc;

	memset(&nat_tuple, 0, sizeof(struct nat_tuple));
	nat_tuple.int_host.ip			= intIp;
	nat_tuple.int_host.port			= intPort;
	nat_tuple.ext_host.ip			= extIp;
	nat_tuple.ext_host.port			= extPort;
	nat_tuple.rem_host.ip			= remIp;
	nat_tuple.rem_host.port		= remPort;
	nat_tuple.proto				= protocol;
	nat_out = TBLFIELD(nat_tbl, nat_lookup)(&nat_tuple);
	if (!nat_out)
		return 0;
	rc = TBLFIELD(nat_tbl, nat_asic_get)(nat_out->out, &asic_nat);
	assert(rc==SUCCESS);
	rc = TBLFIELD(nat_tbl, nat_asic_get)(nat_out->in, &asic_nat1);
	assert(rc==SUCCESS);
	return (asic_nat.ageSec>asic_nat1.ageSec)? asic_nat.ageSec: asic_nat1.ageSec;
}

#ifdef CONFIG_RTL865X_PROC_DEBUG
int32 rtl865x_sw_napt_proc_read( char *page, char **start, off_t off, int count, int *eof, void *data )
{

	int i;
	struct nat_entry *natEntryPtr;
	int len=0;
	
	len = sprintf(page, "%s\n", "sw napt table:");
	
	for(i=0; i<RTL8651_TCPUDPTBL_SIZE; i++)
	{
		natEntryPtr= &TBLFIELD(nat_tbl, nat_bucket)[i];
		if(NAT_INUSE(natEntryPtr))
		{
			len += sprintf(page+len, "[%4d]%s:%d.%d.%d.%d:%d<---->%d.%d.%d.%d:%d<----> %d.%d.%d.%d:%d, inbound:%d,outbound:%d\n",
			i,natEntryPtr->proto_==1?"tcp":"udp" ,NIPQUAD(natEntryPtr->int_ip_),natEntryPtr->int_port_,
			NIPQUAD(natEntryPtr->ext_ip_),natEntryPtr->ext_port_,NIPQUAD(natEntryPtr->rem_ip_),natEntryPtr->rem_port_, natEntryPtr->in,natEntryPtr->out);
		}
	
	}
	
	if (len <= off+count) 
	{
		*eof = 1;
	}
	
	*start = page + off;
	len -= off;
	
	if (len>count)
	{
		len = count;
	}
	
	if (len<0)
	{
	  	len = 0;
	}

	return len;
}

int32  rtl865x_sw_napt_proc_write( struct file *filp, const char *buff,unsigned long len, void *data )
{
	return len;
}

#endif

