/*
* Copyright c                  Realtek Semiconductor Corporation, 2008  
* All rights reserved.
* 
* Program : nexthop table driver
* Abstract : 
* Author : hyking (hyking_liu@realsil.com.cn)  
*/
#ifndef	RTL865X_NEXTHOP_H
#define	RTL865X_NEXTHOP_H

#include "common/rtl_types.h"
#include "common/rtl865x_netif.h"
#include "common/rtl865x_netif_local.h"

typedef struct rtl865x_nextHopEntry_s 
{
	rtl865x_netif_local_t *dstNetif;	/* dst network interface*/
	uint32	nexthop;			/* ethernet: nexthop ip address, pppoe: session Id */
	rtl865x_ip_entry_t *srcIp_t;		/* for nexthop source ip table index, it's invalid  now*/

	uint16 valid:1,		/* 0: Invalid, 1: Invalid */	
		nextHopType:3,			/* IF_ETHER, IF_PPPOE */
		flag:3;			/* bit0:referenced by l3, bit2:referenced by acl */

	uint16	refCnt;			/* Reference Count */
	uint32	entryIndex;			/* Entry Index */

} rtl865x_nextHopEntry_t;

#define NEXTHOP_L3					0x01
#define NEXTHOP_DEFREDIRECT_ACL	0x02

#define NXTHOP_ENTRY_NUM	16

int32 rtl865x_initNxtHopTable(void);
int32 rtl865x_reinitNxtHopTable(void);
int32 rtl865x_addNxtHop(uint32 attr, void *ref_ptr, rtl865x_netif_local_t *netif, uint32 nexthop);
int32 rtl865x_delNxtHop(uint32 attr, uint32 entryIdx);


#endif

