#ifndef RTL865X_LAYER3_LOCAL_H 
#define RTL865X_LAYER3_LOCAL_H

#include <common/rtl865x_common_local.h>

struct arp_table {

	uint8						arp_mask[64];
	rtl865x_tblAsicDrv_arpParam_t	__arpbuff;
	
	rtl865x_tblAsicDrv_arpParam_t *	(*arp_lookup)(ipaddr_t);
	enum RTL_RESULT				(*arp_add)(ipaddr_t, ether_addr_t *, enum RTL_ARP_FLAGS);
	enum RTL_RESULT				(*arp_del)(ipaddr_t);
	int32						(*arp_init)(void);
	int32						(*arp_hash)(ipaddr_t);
	int32						(*arp_tbl_alloc)(struct if_entry *);
	int32						(*arp_tbl_free)(struct if_entry *);

	int32						(*arp_asic_set)(uint32, rtl865x_tblAsicDrv_arpParam_t *);
	int32						(*arp_asic_get)(uint32, rtl865x_tblAsicDrv_arpParam_t *);
	int32						(*arp_asic_del)(uint32);
};

#define RT_PPPOE					0x00
#define RT_L2						0x01
#define RT_ARP					0x02
#define RT_CPU					0x04
#define RT_NEXTHOP				0x05
#define RT_DROP					0x06
#define RT_POLICY					0x07
#define RT_SESSION				0x08

struct rt_table {

	ipaddr_t						pendgw[RTL8651_ROUTINGTBL_SIZE];
	rtl865x_tblAsicDrv_routingParam_t __l3buff;
	rtl865x_tblAsicDrv_routingParam_t * (*route_lookup)(ipaddr_t, ipaddr_t, uint32 *);
	enum RTL_RESULT				(*route_add)(ipaddr_t, ipaddr_t, ipaddr_t, uint8 *, enum RTL_ROUTE_FLAGS);
	enum RTL_RESULT				(*route_del)(ipaddr_t, ipaddr_t);
	int32						(*route_init)(void);

	int32						(*rt_asic_set)(uint32, rtl865x_tblAsicDrv_routingParam_t *);
	int32						(*rt_asic_get)(uint32, rtl865x_tblAsicDrv_routingParam_t *);
	int32						(*rt_asic_del)(uint32);
};


struct natip_table {

	uint32						natip_no;
	rtl865x_tblAsicDrv_extIntIpParam_t __natipbuff;
	rtl865x_tblAsicDrv_extIntIpParam_t * (*natip_lookup)(ipaddr_t, uint32 *);
	int32						(*natip_init)(void);
	int32						(*natip_add)(ipaddr_t);
	int32						(*natip_del)(ipaddr_t);
	int32						(*natip_asic_set)(uint32, rtl865x_tblAsicDrv_extIntIpParam_t *);
	int32						(*natip_asic_get)(uint32, rtl865x_tblAsicDrv_extIntIpParam_t *);
	int32						(*natip_asic_del)(uint32);
#ifndef CONFIG_RTL865XC
	int32						(*gidx_asic_set)(uint32);
	int32						(*gidx_asic_get)(uint32 *);
#endif
};


struct pppoe_table {


	struct if_entry				*ppps[RTL8651_PPPOETBL_SIZE];
	struct if_entry *				(*pppoe_lookup)(uint32, uint32 *);

	int32						(*pppoe_init)(void);
	
	int32						(*pppoe_asic_set)(uint32 ,rtl865x_tblAsicDrv_pppoeParam_t *);
	int32						(*pppoe_asic_get)(uint32, rtl865x_tblAsicDrv_pppoeParam_t *);
};

extern struct pppoe_table					pppoe_tbl;
extern struct arp_table						arpt_tbl;
extern struct rt_table						rt_tbl;

#endif
