#ifndef RTL865X_LAYER3_H
#define RTL865X_LAYER3_H

/*2007-12-19*/
#define GET_IF_VID(ifa)					(TBLFIELD(vlan_tbl, vhash)[rtl8651_vlanTableIndex((ifa)->vid)].fid)

#define RTL8651_PPPOETBL_SIZE			8

/*==========================================================================*/
/* ARP                                                                      */
/*==========================================================================*/
/* for dowhat field of rt_arp_sync() */
enum SYNC_FLAG
{
	SYNC_ADD = 0,
	SYNC_DEL = 1,
};

enum RTL_ARP_FLAGS
{
	RTL_ARP_NONE = 0,
};

/*
@func enum RTL_RESULT | rtl865x_addArp | Add an ARP mapping
@parm ipaddr_t | ip | The IP address to add
@parm ether_addr_t * | mac | The MAC address mapping to this IP address
@parm enum RTL_ARP_FLAGS | flags | reserved for future used
@rvalue RTL_SUCCESS | Add success
@rvalue RTL_FAILED | General failure
@comm 
	Add an ARP mapping (IP and MAC) to H/W ARP Table
@devnote
	Insert into arp_process() function in file net/ipv4/arp.c
*/
enum RTL_RESULT rtl865x_addArp( ipaddr_t ip, ether_addr_t * mac, enum RTL_ARP_FLAGS flags );


/*
@func enum RTL_RESULT | rtl865x_delArp | Delete an ARP mapping
@parm ipaddr_t | ip | The IP address to delete
@rvalue RTL_SUCCESS | Delete success
@rvalue RTL_FAILED | General failure
@comm 
	Delete an ARP mapping entry with IP
@devnote
	Insert into arp_process() function in file net/ipv4/arp.c
*/
enum RTL_RESULT rtl865x_delArp( ipaddr_t ip );


/*
@ func uint32 | rtl865x_arpSync | Sync asic arp with sofware arp entry.
@parm ipaddr_t | ip | IP address to sync.
@parm uint32 | refresh | Refresh arp entry.
@rvalue 0~300 | Current aging time. 
@comm
	Software sync arp entry with asic through periodically calling this API. Once the API returned 
	zero value, it means the entry has aged out in asic. In this case an attempt to remove asic
	entry should be made by software.
*/
uint32 rtl865x_arpSync( ipaddr_t ip, uint32 refresh );


/*==========================================================================*/
/* L3 Routing                                                               */
/*==========================================================================*/
enum RTL_ROUTE_FLAGS
{
	RTL_ROUTE_NONE = 0,
};

/*
@func enum RTL_RESULT | rtl865x_addRoute | Add a Routing Entry
@parm ipaddr_t | ip | The IP address to add
@parm ipaddr_t | mask | The IP mask to add
@parm ipaddr_t | gateway | The nexthop to route
@parm uint8* | ifname | The interface name to route (maximum length: 15 octets, zero-terminated)
@parm enum RTL_ROUTE_FLAGS | flags | reserved for future used
@rvalue RTL_SUCCESS | Add success
@rvalue RTL_FAILED | General failure
@comm 
	Add a Route Rule Entry to L3 Routing Table(8-Entry)
@devnote
	Insert into rt_intern_hash() function in file net/ipv4/route.c
*/
enum RTL_RESULT rtl865x_addRoute( ipaddr_t ip, ipaddr_t mask, ipaddr_t gateway, uint8* ifname, enum RTL_ROUTE_FLAGS flags );


/*
@func enum RTL_RESULT | rtl865x_delRoute | Delete a Routing Entry
@parm ipaddr_t | ip | The IP address to delete
@parm ipaddr_t | mask | The IP mask to delete
@rvalue RTL_SUCCESS | Add success
@rvalue RTL_FAILED | General failure
@comm 
	Delete a Routing Entry with IP Address and mask
@devnote
	Insert into SMP_TIMER_NAME(rt_check_expire)() function in file net/ipv4/route.c
*/
enum RTL_RESULT rtl865x_delRoute( ipaddr_t ip, ipaddr_t mask );


/*==========================================================================*/
/*NAPT Ip                                                                */
/*==========================================================================*/
enum RTL_RESULT rtl865x_addNaptIp(ipaddr_t natip);

enum RTL_RESULT rtl865x_delNaptIp(ipaddr_t natip);


/*==========================================================================*/
/* PPP Session                                                              */
/*==========================================================================*/
enum RTL_SESSION_TYPE
{
	RTL_SE_PPPOE = 1,
	RTL_SE_PPTP = 2,
	RTL_SE_L2TP = 3,
};

enum RTL_SESSION_FLAGS
{
	RTL_SE_NONE = 0,
};

#if defined(CONFIG_RTL865X_HW_PPTPL2TP) || defined(CONFIG_RTL865X_PPPOE_HWACC)
int32 rtl865x_addPppSession(uint8 *ifname, ether_addr_t *mac, uint32 sessionId, int32 type);
int32 rtl865x_delPppSession(uint8 *ifname, int32 type);
#endif

#endif
