/*
* Copyright c                  Realtek Semiconductor Corporation, 2008  
* All rights reserved.
* 
* Program : ip table driver
* Abstract : 
* Author : hyking (hyking_liu@realsil.com.cn)  
*/
#ifndef	RTL865X_IP_H
#define	RTL865X_IP_H

//#include "common/rtl_types.h"

#define IP_NUMBER	8
#define IP_TYPE_NAPT			0x00
#define IP_TYPE_NAT				0x01
#define IP_TYPE_LOCALSERVER	0x02
#define IP_TYPE_RESERVED		0x03


typedef struct rtl865x_ip_entry_s
{
	ipaddr_t intIp; /*internal ip address*/
	ipaddr_t extIp; /*external ip address*/
	uint32 valid:1, /*valid*/
		type:2,  /*napt/nat/ls/reserved*/
		defNaptIp:1; /*this ip entry is default napt ip address?*/

#if 1
	/*now, this information is invalid...*/
	void *nexthop; /*point to a nexthop entry,in preversion SoC, 
				     *used for multiple session hardware forwarding...
				     */	
#endif
}rtl865x_ip_entry_t;


int32 rtl865x_initIpTable(void);
int32 rtl865x_reinitIpTable(void);
int32 rtl865x_addIp(ipaddr_t intIp, ipaddr_t extIp, uint32 ip_type);
int32 rtl865x_delIp(ipaddr_t extIp);
int32 rtl865x_getIPIdx(rtl865x_ip_entry_t *entry, int32 *idx);
int32 rtl865x_getIpIdxByExtIp(ipaddr_t extIp, int32 *idx);


#endif

