/////////////////////////////////////////////////////////////////
////
//// This file is to be included only by rtl8651_tblDrvLocal.h
//// This file exists only to split lengthy driver definitions to several organized header files
////
////  !!!Only  put Layer 2 driver specific 
////              1) local data types, 2) #define, and 3)macros 
////        in this file
////
//// Leave all "externs" and functions prototypes to rtl8651_tblDrvlocal.h 
//// If the API or datatype is to be exported outside the driver,
//// Please put it in rtl8651_layer2.h or rtl8651_tblDrv.h 
////
/////////////////////////////////////////////////////////////////

#ifndef RTL8651_LAYER2_LOCAL_H
#define  RTL8651_LAYER2_LOCAL_H

#include <common/rtl_queue.h>
//#include <AsicDriver/rtl865xc_asicregs.h>



typedef struct rtl8651_tblDrv_ethernet_s {
	uint32 	speed:2, //0: 10Mbps, 1:100Mbps, 2:1000Mbps
			duplex:1, //0: half-duplex 1:full-duplex
			autoNegotiation:1, //0:disable 1:Enable
			fake_forceMode:1,	// used to patch switch core crash bug (see rtl8651_setEthernetPortAutoNegotiation() for more details)
#ifdef CONFIG_RTL865XC
			autoAdvCapability:4, /* Compared to RTL865xB, add 1 more bit to stand for giga capability. */
#else
			autoAdvCapability:3, // RTL8651_ETHER_AUTO_xxx
#endif
			inputBandwidthControl:4, // RTL8651_BC_xxx
			outputBandwidthControl:4, // RTL8651_BC_xxx
			linkUp:1; //0: Down 1:Up
	uint16	aggregatorIndex;//The corresponding entry index in link aggregation table
} rtl8651_tblDrv_ethernet_t;
 
typedef struct rtl8651_tblDrv_linkAggregation_s {
	uint16 pvid;//Port vlan ID
	uint16 	individual:1, // Whether this aggregator is indivual aggregator or not
			aggregated:1;//Whether this aggregator aggregate some links
	uint32 ethernetPortMask; //port i at 1<<i position, from 0 to 31
	uint32 ethernetPortUpStatus; //port i at 1<<i position, from 0 to 31
} rtl8651_tblDrv_linkAggregation_t;



/*
Note:
1. Entry property toCpu, srcBlocking destination blocking (memberPortMask) and normal forwarding (Neither toCpu nor srcBlocking) are 
    mutually exclusive. Therefore, only 2-bit to represent this situation. 
2. All entries are static configuration
3. Unable to process conflict macAddress entry process, return fail when following operation are conflict with current one.
*/
typedef struct rtl8651_tblDrv_filterDbTableEntry_s {
	ether_addr_t	macAddr;
	uint16  l2type;			// see bleow definition
	uint16	process:2,		//0: Normal forwarding, 1: destination blocking 2: source blocking 3: toCpu
			//Management flag
			refCount:8,		//Referenced by other table, such as 
			configToAsic:1,	//This entry is configured to ASIC
			asicPos:2;		//The entry position of the ASIC. Since rtl8651 only provides 4-entry. Only 2-bit is required
	uint16 	vid;				//0: don't care. 1~4094: vid of this entry
	uint32	linkId;			//For WLAN WDS.
		//cfliu: What is link Id? link Id is a virtual port number which represents a WDS link for wireless application.
		//since 8650 uses MII loopback port and 8650B has only 3 ext ports, it is always insufficient to map 8650B ext ports
		//to typical 8 WDS links.

	uint32	memberPortMask; //port i at 1<<i position, from 0 to 31
	SLIST_ENTRY(rtl8651_tblDrv_filterDbTableEntry_s) nextFDB;
} rtl8651_tblDrv_filterDbTableEntry_t;

#define RTL8651_L2_TYPEI			0x0001		/* Referenced by ARP/PPPoE */
#define RTL8651_L2_TYPEII			0x0002		/* Referenced by Protocol */
#define RTL8651_L2_TYPEIII			0x0004		/* Referenced by PCI/Extension Port */

/* Definition for L2 entry mode */
#define L2_AUTO					0x00
#define L2_FORCE_STATIC				0x01
#define L2_FORCE_DYNAMIC			0x02

typedef struct rtl8651_tblDrv_filterDbTable_s {
	uint16 sid;// Spanning tree ID, 0: CIST id, 1-4096 MST ID
	uint32 valid:1;	//Whether this filter database is valid
	SLIST_HEAD(, rtl8651_tblDrv_filterDbTableEntry_s) database[RTL8651_L2TBL_ROW];
} rtl8651_tblDrv_filterDbTable_t;

typedef struct rtl8651_tblDrv_spanningTreeTable_s {
	uint32	protocolWorking:1,	//Whether protocol is working to configure this instance
			valid:1;	//Whether this spanning tree is valid
	//RTL8651_PORT_NUMBER+rtl8651_totalExtPortNum
	int8	portState[9];// 0: disabled, 1: blocking, 2: listening, 3: Learning, 4: Forwarding
} rtl8651_tblDrv_spanningTreeTable_t;


typedef struct rtl8651_tblDrv_macAddressEntry_s {
	ether_addr_t mac;
	uint16 vid;
	uint32 	valid:1,
			allocated:1;
} rtl8651_tblDrv_macAddressEntry_t;

extern uint32 peripheralExtPortMask;

/* ================================================
	Co-work with ASIC driver
     ================================================ */
int32 _rtl8651_initAsicDrvParam( void );

/*================================================
  * PPTP/L2TP MII patch structure
  *================================================*/
#define TBLDRV_PPTP_L2TP_MII_STRUCTURE

typedef struct rtl8651_tblDrv_miiTunneling_s {
	uint32	valid;
	uint16	wanPort;
	uint16	wanVid;
	uint16	loopbackPort;
	uint16	loopBackVid;
} rtl8651_tblDrv_miiTunneling_t;

extern rtl8651_tblDrv_miiTunneling_t tunnel;

struct port_attribute {
	uint32						activePortMask;
	uint8						ing_filter[RTL8651_PORT_NUMBER];
	void							(*link_change)(uint32, int8);
	int32						(*pvid_asic_set)(uint32, uint32);
	int32						(*pvid_asic_get)(uint32, uint32 *);
};

 struct fdb_table {

	uint8						FDB[RTL8651_L2_NUMBER];
	uint8						LinkID[RTL8651_L2_NUMBER];
	rtl865x_tblAsicDrv_l2Param_t	__l2buff;
	rtl865x_tblAsicDrv_l2Param_t *	(*fdb_lookup)(uint32, ether_addr_t *, uint32, uint32 *);
	int32						(*fdb_init)(void);
	int32						(*bridge_rcv)(struct rtl_pktHdr *);
	enum RTL_RESULT				(*fdb_add)(uint32, ether_addr_t *, uint32, enum FDB_FLAGS);
	enum RTL_RESULT				(*fdb_del)(uint32, ether_addr_t *);
#ifdef CONFIG_RTL865XC
	uint32						(*fdb_asic_hash)(ether_addr_t *, uint16);
#else
	uint32						(*fdb_asic_hash)(ether_addr_t *);
#endif
	int32 						(*fdb_asic_get)(uint32, uint32, rtl865x_tblAsicDrv_l2Param_t *);
	int32 						(*fdb_asic_set)(uint32, uint32, rtl865x_tblAsicDrv_l2Param_t *);
	int32 						(*fdb_asic_del)(uint32, uint32);
};
 
extern struct port_attribute					port_attr;
extern struct fdb_table						fdb_tbl;

uint16 _rtl8651_getOneVidx(int8 internal);

int32 _rtl8651_setPvid(uint32 port, uint16 vid);
uint16 _rtl8651_getPvid(uint32 port);
 int32 _rtl8651_getL2InfoByMac(ether_addr_t *MacAddr, rtl8651_L2InfoTable_t *Info, uint16 fid );
 void _rtl8651_timeUpdateL2Table(void);
 
#endif

