#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>

#include "rtl_types.h"
#include "rtl_glue.h"
#include <asicRegs.h>
#include <common/rtl8651_aclLocal.h>
#include <AsicDriver/rtl865xC_tblAsicDrv.h>
#include <AsicDriver/rtl8651_tblAsicDrv.h>
#include <common/rtl8651_tblDrvProto.h>
#include <common/rtl865x_common.h>
#include <common/rtl865x_common_local.h>
#include <common/rtl865x_eventMgr.h>
#include "mbuf.h"
#include "rtl865x_layer2.h"
#include "rtl865x_layer2_local.h"
#include "rtl8651_tblDrvPatch.h"
#include "rtl_errno.h"
#include "assert.h"
#include <linux/proc_fs.h>

static int32 lr_fdb_init(void);
static rtl865x_tblAsicDrv_l2Param_t *lr_fdb_lookup(uint32 vfid, ether_addr_t *mac,  uint32 flags, uint32 *way);
enum RTL_RESULT rtl865x_addFdbEntry( uint32 vfid, ether_addr_t * mac, uint32 portmask, enum FDB_FLAGS flags );
enum RTL_RESULT rtl865x_delFdbEntry( uint32 vfid, ether_addr_t * mac );


/*2007-12-19*/

/*======================================
 *  FDB(Filtering Database) - fdb_tbl
 *======================================*/
struct fdb_table fdb_tbl = {
	//bridge_rcv:		lr_bridging_rcv,

	fdb_init:			lr_fdb_init,				/* Initialize FDB table */
	fdb_add:			rtl865x_addFdbEntry,		/* Add a FDB entry(static entry only) */
	fdb_del:			rtl865x_delFdbEntry,		/* Remove a FDB entry(static entry only) */
	fdb_lookup:		lr_fdb_lookup,				/* FDN entry lookup */

	fdb_asic_hash:	rtl8651_filterDbIndex,		/* Hash algorithm of FDB entry */
	fdb_asic_set:		rtl8651_setAsicL2Table,		/* ASIC Interface: configure asic fdb */
	fdb_asic_get:		rtl8651_getAsicL2Table,		/* ASIC Interface: query asic fdb */
	fdb_asic_del:		rtl8651_delAsicL2Table,		/* ASIC Interface: remove asic fdb */
};

static int32 lr_fdb_init(void)
{
	memset(TBLFIELD(fdb_tbl, FDB), 0, sizeof(uint8)*RTL8651_L2_NUMBER);
	return 0;
}


static rtl865x_tblAsicDrv_l2Param_t *lr_fdb_lookup(uint32 vfid, ether_addr_t *mac,  uint32 flags, uint32 *way)
{
	uint32 hash0, way0;
#ifdef CONFIG_RTL865XC
	hash0 = TBLFIELD(fdb_tbl, fdb_asic_hash)(mac, vfid);
#else
	hash0 = TBLFIELD(fdb_tbl, fdb_asic_hash)(mac);
#endif
	for(way0=0; way0<RTL8651_L2TBL_COLUMN; way0++) {
		if (rtl8651_getAsicL2Table(hash0, way0, &TBLFIELD(fdb_tbl, __l2buff))!=SUCCESS ||
			memcmp(&TBLFIELD(fdb_tbl, __l2buff).macAddr, mac, 6)!= 0)
			continue;
		if (((flags&FDB_STATIC) && TBLFIELD(fdb_tbl, __l2buff).isStatic) ||
			((flags&FDB_DYNAMIC) && !TBLFIELD(fdb_tbl, __l2buff).isStatic)) {
			assert(way);
			*way = way0;
			return &TBLFIELD(fdb_tbl, __l2buff);
		}
	} return (rtl865x_tblAsicDrv_l2Param_t *)0;
}


/*
@func enum RTL_RESULT | rtl865x_addFdbEntry | Add an MAC address, said Filter Database Entry
@parm uint32 | vid | The VLAN ID (valid: 0~4095)
@parm uint32 | fid | The filter database index (valid: 0~3)
@parm ether_addr_t * | mac | The MAC address to be added
@parm uint32 | portmask | The portmask of this MAC address belongs to
@parm enum FDB_FLAGS | flags | reserved for future used
@rvalue RTL_SUCCESS | Add success
@rvalue RTL_FAILED | General failure
@comm 
	Add a Filter Database Entry to L2 Table(1024-Entry)
@devnote
	(under construction)
*/
enum RTL_RESULT rtl865x_addFdbEntry( uint32 vfid, ether_addr_t * mac, uint32 portmask, enum FDB_FLAGS flags )
{
#ifdef CONFIG_RTL865XC
	uint32 way, hash=TBLFIELD(fdb_tbl, fdb_asic_hash)(mac, vfid);
#else
	uint32 way, hash=TBLFIELD(fdb_tbl, fdb_asic_hash)(mac);
#endif
	rtl865x_tblAsicDrv_l2Param_t l2;
	
	if (flags != FDB_FWD && flags != FDB_SRCBLK && flags != FDB_TRAPCPU)
		return RTL_INVAPARAM; /* Invalid parameter */

	/* check duplicate entry */
	if (TBLFIELD(fdb_tbl, fdb_lookup)(vfid, mac, FDB_STATIC, &way))
		return RTL_DUPENTRY;
	if (!TBLFIELD(fdb_tbl, fdb_lookup)(vfid, mac, FDB_DYNAMIC, &way)) {
		for(way=0; way<RTL8651_L2TBL_COLUMN; way++)
			if (TBLFIELD(fdb_tbl, fdb_asic_get)(hash, way, &l2))
				break;
		if (way == RTL8651_L2TBL_COLUMN)
			return RTL_NOBUFFER;
	}
	TBLFIELD(fdb_tbl, FDB)[(hash<<2)+way] ++;
	memset(&l2, 0, sizeof(rtl865x_tblAsicDrv_l2Param_t));
	l2.isStatic				= 1;
	l2.ageSec				= L2_AGING_TIME;
	l2.macAddr				= *(mac);
	l2.memberPortMask			= portmask;
	l2.cpu					= (flags==FDB_TRAPCPU)? 1: 0;
	l2.srcBlk					= (flags==FDB_SRCBLK)? 1: 0;
#ifdef CONFIG_RTL865XC
	l2.auth					=  0;
	l2.fid					=  vfid;
#endif
	LR_CONFIG_CHECK(TBLFIELD(fdb_tbl, fdb_asic_set)(hash, way, &l2));
	return RTL_SUCCESS;
}

/*
@func enum LR_RESULT | rtl865x_delFdbEntry | Delete an MAC address, said Filter Database Entry
@parm uint32 | vid | The VLAN ID (valid: 0~4095)
@parm uint32 | fid | The filter database index (valid: 0~3)
@parm ether_addr_t * | mac | The MAC address to be deleted
@rvalue LR_SUCCESS | Delete success
@rvalue LR_FAILED | General failure
@comm 
	Delete a Filter Database Entry of L2 Table with MAC address
@devnote
	(under construction)
*/
enum RTL_RESULT rtl865x_delFdbEntry( uint32 vfid, ether_addr_t * mac )
{
	enum RTL_RESULT res = RTL_NOTFOUND;
	uint32 way, hash;
	
	if (TBLFIELD(fdb_tbl, fdb_lookup)(vfid, mac, FDB_STATIC, &way)) {
		res = RTL_SUCCESS;
#ifdef CONFIG_RTL865XC
		hash=TBLFIELD(fdb_tbl, fdb_asic_hash)(mac, vfid);
#else
		hash=TBLFIELD(fdb_tbl, fdb_asic_hash)(mac);
#endif
		if (--TBLFIELD(fdb_tbl, FDB)[(hash<<2)+way] == 0){
			LR_CONFIG_CHECK(TBLFIELD(fdb_tbl, fdb_asic_del)(hash, way));
			TBLFIELD(fdb_tbl, LinkID)[(hash<<2)+way]  = 0;
		}
	} 
	return res;
}

int32 rtl8651_lookupL2table(uint16 fid, ether_addr_t * macAddr, enum FDB_FLAGS flags)
{
uint32 hash0, way0;
#ifdef CONFIG_RTL865XC
	hash0 = TBLFIELD(fdb_tbl, fdb_asic_hash)(macAddr, fid);
#else
	hash0 = TBLFIELD(fdb_tbl, fdb_asic_hash)(macAddr);
#endif
	for(way0=0; way0<RTL8651_L2TBL_COLUMN; way0++) {
		if (rtl8651_getAsicL2Table(hash0, way0, &TBLFIELD(fdb_tbl, __l2buff))!=SUCCESS ||
			memcmp(&TBLFIELD(fdb_tbl, __l2buff).macAddr, macAddr, 6)!= 0)
			continue;
		
			return SUCCESS;			
	}
	return FAILED;
}

int32 rtl8651_delFilterDatabaseEntry(uint16 fid, ether_addr_t * macAddr)
{
	enum RTL_RESULT res = RTL_NOTFOUND;
	uint32 way, hash;
	
	if (TBLFIELD(fdb_tbl, fdb_lookup)(fid, macAddr, FDB_DYNAMIC, &way)) {
		res = RTL_SUCCESS;
#ifdef CONFIG_RTL865XC
		hash=TBLFIELD(fdb_tbl, fdb_asic_hash)(macAddr, fid);
/*		printk("col is %d, row is %d\n", hash, way);*/
#else
		hash=TBLFIELD(fdb_tbl, fdb_asic_hash)(macAddr);
#endif
//		if (--TBLFIELD(fdb_tbl, FDB)[(hash<<2)+way] == 0){
//			LR_CONFIG_CHECK(TBLFIELD(fdb_tbl, fdb_asic_del)(hash, way));
//			TBLFIELD(fdb_tbl, LinkID)[(hash<<2)+way]  = 0;
			rtl8651_delAsicL2Table(hash, way); 
		}
//	} 
	return res;
}


